/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.datatype.editor.impl;

import org.drools.eclipse.flow.common.view.datatype.editor.Editor;
import org.drools.process.core.datatype.DataType;
import org.drools.process.core.datatype.impl.type.BooleanDataType;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class BooleanEditor
extends Composite
implements Editor {
    private static final String[] TF = new String[]{"true", "false"};
    private Combo combo;

    public BooleanEditor(Composite composite) {
        super(composite, 0);
        this.setLayout((Layout)new FillLayout());
        this.combo = new Combo((Composite)this, 8);
        this.combo.setItems(TF);
        this.combo.select(1);
    }

    public void setDataType(DataType dataType) {
        if (!(dataType instanceof BooleanDataType)) {
            throw new IllegalArgumentException("Illegal data type " + dataType);
        }
    }

    public Object getValue() {
        return this.combo.getSelectionIndex() == 0;
    }

    public void setValue(Object object) {
        if (object == null) {
            this.combo.select(1);
        } else if (object instanceof Boolean) {
            this.combo.select((Boolean)object != false ? 0 : 1);
        } else {
            throw new IllegalArgumentException("Value must be a boolean: " + object);
        }
    }

    public void reset() {
        this.combo.select(1);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.combo.setEnabled(bl);
    }
}

