/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.policy;

import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementConnectionFactory;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ProcessWrapper;
import org.drools.eclipse.flow.common.editor.core.command.DeleteConnectionCommand;
import org.drools.eclipse.flow.common.editor.core.command.SplitConnectionCommand;
import org.drools.eclipse.flow.common.editor.editpart.ElementConnectionEditPart;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;

public class ConnectionEditPolicy
extends org.eclipse.gef.editpolicies.ConnectionEditPolicy {
    private ElementConnectionFactory elementConnectionFactory;

    public void setDefaultElementConnectionFactory(ElementConnectionFactory elementConnectionFactory) {
        if (elementConnectionFactory == null) {
            throw new IllegalArgumentException("ElementConnectionFactory is null");
        }
        this.elementConnectionFactory = elementConnectionFactory;
    }

    public ElementConnectionFactory getDefaultElementConnectionFactory() {
        return this.elementConnectionFactory;
    }

    public Command getCommand(Request request) {
        if ("create child".equals(request.getType())) {
            return this.getSplitTransitionCommand(request);
        }
        return super.getCommand(request);
    }

    private PolylineConnection getConnectionFigure() {
        return (PolylineConnection)((ElementConnectionEditPart)this.getHost()).getFigure();
    }

    protected Command getDeleteCommand(GroupRequest groupRequest) {
        DeleteConnectionCommand deleteConnectionCommand = new DeleteConnectionCommand();
        ElementConnection elementConnection = (ElementConnection)this.getHost().getModel();
        deleteConnectionCommand.setAntecedentTaskConnection(elementConnection);
        deleteConnectionCommand.setSource(elementConnection.getSource());
        deleteConnectionCommand.setTarget(elementConnection.getTarget());
        return deleteConnectionCommand;
    }

    protected Command getSplitTransitionCommand(Request request) {
        if (this.elementConnectionFactory == null) {
            throw new IllegalStateException("DefaultElementConnectionFactory is null");
        }
        SplitConnectionCommand splitConnectionCommand = new SplitConnectionCommand();
        splitConnectionCommand.setElementConnection((ElementConnection)this.getHost().getModel());
        splitConnectionCommand.setNewSecondConnection(this.elementConnectionFactory.createElementConnection());
        splitConnectionCommand.setParent((ProcessWrapper)((ElementConnectionEditPart)this.getHost()).getSource().getParent().getModel());
        splitConnectionCommand.setNewElement((ElementWrapper)((CreateRequest)request).getNewObject());
        return splitConnectionCommand;
    }

    public EditPart getTargetEditPart(Request request) {
        if ("create child".equals(request.getType())) {
            return this.getHost();
        }
        return null;
    }

    public void eraseTargetFeedback(Request request) {
        if ("create child".equals(request.getType())) {
            this.getConnectionFigure().setLineWidth(1);
        }
    }

    public void showTargetFeedback(Request request) {
        if ("create child".equals(request.getType())) {
            this.getConnectionFigure().setLineWidth(2);
        }
    }
}

