/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.editpart.work;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.drools.process.core.ParameterDefinition;
import org.drools.process.core.Work;
import org.drools.process.core.WorkDefinition;
import org.drools.process.core.WorkEditor;
import org.drools.process.core.impl.WorkImpl;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SampleCustomEditor
extends EditBeanDialog
implements WorkEditor {
    private WorkDefinition workDefinition;
    private Map<String, Text> texts = new HashMap<String, Text>();

    public SampleCustomEditor(Shell shell) {
        super(shell, "Custom Work Editor");
        this.setBlockOnOpen(true);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Work work = (Work)this.getValue();
        Label label = new Label(composite2, 0);
        label.setText("Name: ");
        Text text = new Text(composite2, 0);
        text.setEditable(false);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        text.setLayoutData((Object)gridData);
        String string = work.getName();
        text.setText(string == null ? "" : string);
        Set set = this.workDefinition.getParameters();
        for (ParameterDefinition parameterDefinition : set) {
            Label label2 = new Label(composite2, 0);
            label2.setText(String.valueOf(parameterDefinition.getName()) + ": ");
            Text text2 = new Text(composite2, 0);
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            text2.setLayoutData((Object)gridData);
            this.texts.put(parameterDefinition.getName(), text2);
            Object object = work.getParameter(parameterDefinition.getName());
            text2.setText(object == null ? "" : object.toString());
        }
        return composite2;
    }

    protected Object updateValue(Object object) {
        WorkImpl workImpl = new WorkImpl();
        workImpl.setName(((Work)object).getName());
        Iterator<Map.Entry<String, Text>> iterator = this.texts.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            Map.Entry<String, Text> entry;
            workImpl.setParameter(entry.getKey(), (Object)("".equals(string = (entry = iterator.next()).getValue().getText()) ? null : string));
        }
        workImpl.setParameterDefinitions(((Work)object).getParameterDefinitions());
        return workImpl;
    }

    public Work getWork() {
        return (Work)this.getValue();
    }

    public void setWork(Work work) {
        this.setValue(work);
    }

    public void setWorkDefinition(WorkDefinition workDefinition) {
        this.workDefinition = workDefinition;
    }

    public boolean show() {
        int n = this.open();
        return n == 0;
    }
}

