/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.editpart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.flow.common.editor.editpart.ElementConnectionEditPart;
import org.drools.eclipse.flow.common.editor.editpart.ElementEditPart;
import org.drools.eclipse.flow.common.editor.editpart.ProcessEditPart;
import org.drools.eclipse.flow.common.editor.editpart.figure.ElementFigure;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;

public class DirectedGraphLayoutVisitor {
    private Map partToNodesMap;
    private DirectedGraph graph;

    public void layoutDiagram(ProcessEditPart processEditPart) {
        this.partToNodesMap = new HashMap();
        this.graph = new DirectedGraph();
        this.addNodes(processEditPart);
        if (this.graph.nodes.size() > 0) {
            this.addEdges(processEditPart);
            new DirectedGraphLayout().visit(this.graph);
            this.applyResults(processEditPart);
        }
    }

    protected void addNodes(ProcessEditPart processEditPart) {
        int n = 0;
        while (n < processEditPart.getChildren().size()) {
            ElementEditPart elementEditPart = (ElementEditPart)processEditPart.getChildren().get(n);
            this.addNodes(elementEditPart);
            ++n;
        }
    }

    protected void addNodes(ElementEditPart elementEditPart) {
        Node node = new Node((Object)elementEditPart);
        node.width = elementEditPart.getFigure().getPreferredSize((int)400, (int)300).width;
        node.height = elementEditPart.getFigure().getPreferredSize((int)400, (int)300).height;
        node.setPadding(new Insets(10, 8, 10, 12));
        this.partToNodesMap.put(elementEditPart, node);
        this.graph.nodes.add((Object)node);
    }

    protected void addEdges(ProcessEditPart processEditPart) {
        int n = 0;
        while (n < processEditPart.getChildren().size()) {
            ElementEditPart elementEditPart = (ElementEditPart)processEditPart.getChildren().get(n);
            this.addEdges(elementEditPart);
            ++n;
        }
    }

    protected void addEdges(ElementEditPart elementEditPart) {
        List list = elementEditPart.getSourceConnections();
        int n = 0;
        while (n < list.size()) {
            ElementConnectionEditPart elementConnectionEditPart = (ElementConnectionEditPart)elementEditPart.getSourceConnections().get(n);
            this.addEdges(elementConnectionEditPart);
            ++n;
        }
    }

    protected void addEdges(ElementConnectionEditPart elementConnectionEditPart) {
        Node node = (Node)this.partToNodesMap.get(elementConnectionEditPart.getSource());
        Node node2 = (Node)this.partToNodesMap.get(elementConnectionEditPart.getTarget());
        Edge edge = new Edge((Object)elementConnectionEditPart, node, node2);
        edge.weight = 2;
        this.graph.edges.add((Object)edge);
        this.partToNodesMap.put(elementConnectionEditPart, edge);
    }

    protected void applyResults(ProcessEditPart processEditPart) {
        this.applyChildrenResults(processEditPart);
    }

    protected void applyChildrenResults(ProcessEditPart processEditPart) {
        int n = 0;
        while (n < processEditPart.getChildren().size()) {
            ElementEditPart elementEditPart = (ElementEditPart)processEditPart.getChildren().get(n);
            this.applyResults(elementEditPart);
            ++n;
        }
    }

    protected void applyOwnResults(ProcessEditPart processEditPart) {
    }

    public void applyResults(ElementEditPart elementEditPart) {
        Node node = (Node)this.partToNodesMap.get(elementEditPart);
        ElementFigure elementFigure = (ElementFigure)elementEditPart.getFigure();
        Rectangle rectangle = new Rectangle(node.x, node.y, elementFigure.getPreferredSize().width, elementFigure.getPreferredSize().height);
        elementFigure.setBounds(rectangle);
        int n = 0;
        while (n < elementEditPart.getSourceConnections().size()) {
            ElementConnectionEditPart elementConnectionEditPart = (ElementConnectionEditPart)elementEditPart.getSourceConnections().get(n);
            this.applyResults(elementConnectionEditPart);
            ++n;
        }
    }

    protected void applyResults(ElementConnectionEditPart elementConnectionEditPart) {
        Edge edge = (Edge)this.partToNodesMap.get(elementConnectionEditPart);
        NodeList nodeList = edge.vNodes;
        PolylineConnection polylineConnection = (PolylineConnection)elementConnectionEditPart.getConnectionFigure();
        polylineConnection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        if (nodeList != null) {
            ArrayList<AbsoluteBendpoint> arrayList = new ArrayList<AbsoluteBendpoint>();
            int n = 0;
            while (n < nodeList.size()) {
                Node node = nodeList.getNode(n);
                int n2 = node.x;
                int n3 = node.y;
                if (edge.isFeedback()) {
                    arrayList.add(new AbsoluteBendpoint(n2, n3 + node.height));
                    arrayList.add(new AbsoluteBendpoint(n2, n3));
                } else {
                    arrayList.add(new AbsoluteBendpoint(n2, n3));
                    arrayList.add(new AbsoluteBendpoint(n2, n3 + node.height));
                }
                ++n;
            }
            polylineConnection.setRoutingConstraint(arrayList);
        } else {
            polylineConnection.setRoutingConstraint((Object)Collections.EMPTY_LIST);
        }
    }
}

