/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core.command;

import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementContainer;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.eclipse.gef.commands.Command;

public class DeleteElementCommand
extends Command {
    private ElementWrapper child;
    private ElementContainer parent;
    private List incomingElementWrappers = new ArrayList();
    private List outgoingElementWrappers = new ArrayList();
    private List incomingConnections = new ArrayList();
    private List outgoingConnections = new ArrayList();

    private void deleteConnections(ElementWrapper elementWrapper) {
        for (ElementConnection elementConnection : elementWrapper.getIncomingConnections()) {
            this.incomingElementWrappers.add(elementConnection.getSource());
            this.incomingConnections.add(elementConnection);
        }
        for (ElementConnection elementConnection : elementWrapper.getOutgoingConnections()) {
            this.outgoingElementWrappers.add(elementConnection.getTarget());
            this.outgoingConnections.add(elementConnection);
        }
        for (ElementConnection elementConnection : this.incomingConnections) {
            elementConnection.disconnect();
        }
        for (ElementConnection elementConnection : this.outgoingConnections) {
            elementConnection.disconnect();
        }
    }

    public void execute() {
        this.deleteConnections(this.child);
        this.parent.removeElement(this.child);
    }

    private void restoreConnections() {
        int n = 0;
        for (ElementConnection elementConnection : this.incomingConnections) {
            elementConnection.connect((ElementWrapper)this.incomingElementWrappers.get(n), this.child);
            ++n;
        }
        n = 0;
        for (ElementConnection elementConnection : this.outgoingConnections) {
            elementConnection.connect(this.child, (ElementWrapper)this.outgoingElementWrappers.get(n));
            ++n;
        }
        this.incomingConnections.clear();
        this.incomingElementWrappers.clear();
        this.outgoingConnections.clear();
        this.outgoingElementWrappers.clear();
    }

    public void setChild(ElementWrapper elementWrapper) {
        this.child = elementWrapper;
    }

    public void setParent(ElementContainer elementContainer) {
        this.parent = elementContainer;
    }

    public void undo() {
        this.parent.addElement(this.child);
        this.restoreConnections();
    }
}

