/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.flow.common.editor.core.ElementContainer;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.drools.eclipse.flow.common.editor.core.ModelEvent;
import org.drools.eclipse.flow.common.editor.core.ModelListener;
import org.drools.eclipse.flow.common.view.property.ListPropertyDescriptor;
import org.drools.eclipse.flow.ruleflow.view.property.exceptionHandler.ExceptionHandlersPropertyDescriptor;
import org.drools.eclipse.flow.ruleflow.view.property.swimlane.SwimlanesCellEditor;
import org.drools.eclipse.flow.ruleflow.view.property.variable.VariableListCellEditor;
import org.drools.process.core.Process;
import org.drools.process.core.context.exception.ExceptionScope;
import org.drools.process.core.context.swimlane.SwimlaneContext;
import org.drools.process.core.context.variable.VariableScope;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessWrapper
implements ElementContainer,
IPropertySource,
Serializable {
    private static final long serialVersionUID = 510L;
    public static final int CHANGE_ELEMENTS = 1;
    public static final int CHANGE_ROUTER_LAYOUT = 2;
    public static final Integer ROUTER_LAYOUT_MANUAL = new Integer(0);
    public static final Integer ROUTER_LAYOUT_MANHATTAN = new Integer(1);
    public static final Integer ROUTER_LAYOUT_SHORTEST_PATH = new Integer(2);
    public static final String NAME = "name";
    public static final String VERSION = "version";
    public static final String ID = "id";
    public static final String PACKAGE_NAME = "packageName";
    public static final String ROUTER_LAYOUT = "routerLayout";
    public static final String VARIABLES = "variables";
    public static final String SWIMLANES = "swimlanes";
    public static final String EXCEPTION_HANDLERS = "exceptionHandlers";
    private Process process;
    private Map<String, ElementWrapper> elements = new HashMap<String, ElementWrapper>();
    private transient List<ModelListener> listeners = new ArrayList<ModelListener>();
    protected IPropertyDescriptor[] descriptors;

    public ProcessWrapper() {
        this.process = (Process)this.createProcess();
    }

    protected abstract org.drools.definition.process.Process createProcess();

    public org.drools.definition.process.Process getProcess() {
        return this.process;
    }

    public void localSetProcess(org.drools.definition.process.Process process) {
        this.process = (Process)process;
    }

    public String getName() {
        return this.process.getName() == null ? "" : this.process.getName();
    }

    public void setName(String string) {
        this.process.setName(string);
    }

    public String getVersion() {
        return this.process.getVersion() == null ? "" : this.process.getVersion();
    }

    public void setVersion(String string) {
        this.process.setVersion(string);
    }

    public String getId() {
        return this.process.getId();
    }

    public void setId(String string) {
        this.process.setId(string);
    }

    public String getPackageName() {
        return this.process.getPackageName() == null ? "" : this.process.getPackageName();
    }

    public void setPackageName(String string) {
        this.process.setPackageName(string);
    }

    public Integer getRouterLayout() {
        Integer n = (Integer)this.process.getMetaData(ROUTER_LAYOUT);
        if (n == null) {
            return ROUTER_LAYOUT_MANUAL;
        }
        return n;
    }

    public void setRouterLayout(Integer n) {
        this.process.setMetaData(ROUTER_LAYOUT, (Object)n);
        this.notifyListeners(2);
    }

    @Override
    public List<ElementWrapper> getElements() {
        return Collections.unmodifiableList(new ArrayList<ElementWrapper>(this.elements.values()));
    }

    public ElementWrapper getElement(String string) {
        return this.elements.get(string);
    }

    @Override
    public void addElement(ElementWrapper elementWrapper) {
        this.internalAddElement(elementWrapper);
        this.localAddElement(elementWrapper);
        this.notifyListeners(1);
    }

    @Override
    public void localAddElement(ElementWrapper elementWrapper) {
        this.elements.put(elementWrapper.getId(), elementWrapper);
    }

    protected abstract void internalAddElement(ElementWrapper var1);

    @Override
    public void removeElement(ElementWrapper elementWrapper) {
        this.elements.remove(elementWrapper.getId());
        this.notifyListeners(1);
        this.internalRemoveElement(elementWrapper);
    }

    protected abstract void internalRemoveElement(ElementWrapper var1);

    @Override
    public ProcessWrapper getProcessWrapper() {
        return this;
    }

    public void addListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public void notifyListeners(int n) {
        ModelEvent modelEvent = new ModelEvent(n);
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged(modelEvent);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.listeners = new ArrayList<ModelListener>();
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.initPropertyDescriptors();
        }
        return this.descriptors;
    }

    public void initPropertyDescriptors() {
        this.descriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)NAME, "Name"), new TextPropertyDescriptor((Object)VERSION, "Version"), new TextPropertyDescriptor((Object)ID, "Id"), new TextPropertyDescriptor((Object)PACKAGE_NAME, "Package"), new ComboBoxPropertyDescriptor((Object)ROUTER_LAYOUT, "Connection Layout", new String[]{"Manual", "Manhattan", "Shortest Path"}), new ListPropertyDescriptor(VARIABLES, "Variables", VariableListCellEditor.class), new ListPropertyDescriptor(SWIMLANES, "Swimlanes", SwimlanesCellEditor.class), new ExceptionHandlersPropertyDescriptor((Object)EXCEPTION_HANDLERS, "Exception Handlers", (org.drools.definition.process.Process)this.process)};
    }

    public Object getPropertyValue(Object object) {
        if (NAME.equals(object)) {
            return this.getName();
        }
        if (VERSION.equals(object)) {
            return this.getVersion();
        }
        if (ID.equals(object)) {
            return String.valueOf(this.getId());
        }
        if (PACKAGE_NAME.equals(object)) {
            return this.getPackageName();
        }
        if (ROUTER_LAYOUT.equals(object)) {
            return this.getRouterLayout();
        }
        if (VARIABLES.equals(object)) {
            return ((VariableScope)this.process.getDefaultContext("VariableScope")).getVariables();
        }
        if (SWIMLANES.equals(object)) {
            return ((SwimlaneContext)this.process.getDefaultContext("SwimlaneScope")).getSwimlanes();
        }
        if (EXCEPTION_HANDLERS.equals(object)) {
            return ((ExceptionScope)this.process.getDefaultContext("ExceptionScope")).getExceptionHandlers();
        }
        return null;
    }

    public boolean isPropertySet(Object object) {
        return true;
    }

    public void resetPropertyValue(Object object) {
        if (NAME.equals(object)) {
            this.setName("");
        }
        if (VERSION.equals(object)) {
            this.setVersion("");
        }
        if (ID.equals(object)) {
            this.setId("");
        }
        if (PACKAGE_NAME.equals(object)) {
            this.setPackageName("");
        }
        if (ROUTER_LAYOUT.equals(object)) {
            this.setRouterLayout(null);
        }
        if (VARIABLES.equals(object)) {
            ((VariableScope)this.process.getDefaultContext("VariableScope")).setVariables(new ArrayList());
        }
        if (SWIMLANES.equals(object)) {
            ((SwimlaneContext)this.process.getDefaultContext("SwimlaneScope")).setSwimlanes(new ArrayList());
        }
        if (EXCEPTION_HANDLERS.equals(object)) {
            ((ExceptionScope)this.process.getDefaultContext("ExceptionScope")).setExceptionHandlers(new HashMap());
        }
    }

    public void setPropertyValue(Object object, Object object2) {
        if (NAME.equals(object)) {
            this.setName((String)object2);
        } else if (VERSION.equals(object)) {
            this.setVersion((String)object2);
        } else if (ID.equals(object)) {
            this.setId((String)object2);
        } else if (PACKAGE_NAME.equals(object)) {
            this.setPackageName((String)object2);
        } else if (ROUTER_LAYOUT.equals(object)) {
            this.setRouterLayout((Integer)object2);
        } else if (VARIABLES.equals(object)) {
            ((VariableScope)this.process.getDefaultContext("VariableScope")).setVariables((List)object2);
        } else if (SWIMLANES.equals(object)) {
            ((SwimlaneContext)this.process.getDefaultContext("SwimlaneScope")).setSwimlanes((Collection)((List)object2));
        } else if (EXCEPTION_HANDLERS.equals(object)) {
            ((ExceptionScope)this.process.getDefaultContext("ExceptionScope")).setExceptionHandlers((Map)object2);
        }
    }

    @Override
    public boolean canAddElement(ElementWrapper elementWrapper) {
        return true;
    }
}

