/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.action;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.drools.eclipse.flow.common.editor.GenericModelEditor;
import org.drools.eclipse.flow.common.editor.action.ExportImageDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ExportImageAction
extends ActionDelegate
implements IEditorActionDelegate {
    private IEditorPart editor;

    public void run(IAction iAction) {
        this.execute();
    }

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        this.editor = iEditorPart;
    }

    private void execute() {
        ExportImageDialog exportImageDialog = new ExportImageDialog(this.editor.getSite().getWorkbenchWindow().getShell());
        exportImageDialog.setOriginalFile(((IFileEditorInput)this.editor.getEditorInput()).getFile());
        exportImageDialog.open();
        IPath iPath = exportImageDialog.getResult();
        if (iPath == null) {
            return;
        }
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        final IFile iFile = iWorkspace.getRoot().getFile(iPath);
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ((GenericModelEditor)ExportImageAction.this.editor).createImage(byteArrayOutputStream, 5);
                    iFile.create((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), true, iProgressMonitor);
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.editor.getSite().getWorkbenchWindow().getShell()).run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

