/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;

public class ObjectInputStreamWithLoader
extends ObjectInputStream {
    private ClassLoader loader;

    public ObjectInputStreamWithLoader(InputStream inputStream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
        super(inputStream);
        if (classLoader == null) {
            throw new IllegalArgumentException("Illegal null argument to ObjectInputStreamWithLoader");
        }
        this.loader = classLoader;
    }

    private Class primitiveType(char c) {
        switch (c) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (string.startsWith("[")) {
            Object object;
            Class<?> clazz = null;
            int n = 1;
            while (string.charAt(n) == '[') {
                ++n;
            }
            if (string.charAt(n) == 'L') {
                object = string.substring(n + 1, string.length() - 1);
                clazz = this.loader.loadClass((String)object);
            } else {
                if (string.length() != n + 1) {
                    throw new ClassNotFoundException(string);
                }
                clazz = this.primitiveType(string.charAt(n));
            }
            object = new int[n];
            int n2 = 0;
            while (n2 < n) {
                object[n2] = false;
                ++n2;
            }
            return Array.newInstance(clazz, (int[])object).getClass();
        }
        return this.loader.loadClass(string);
    }
}

