/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class DropDownMenuWithDefaultAction
extends Action
implements IMenuCreator {
    private Menu dropDownMenu;
    private IAction delegate;
    private List list;
    private IPropertyChangeListener enabledListener;
    private SelectionListener selectionListener = new ItemSelectionListener(this);

    public DropDownMenuWithDefaultAction(IAction iAction) {
        this.setMenuCreator(this);
        this.dropDownMenu = null;
        this.setAction(iAction);
        this.list = new ArrayList();
    }

    public void dispose() {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
    }

    public void add(IContributionItem iContributionItem) {
        this.list.add(iContributionItem);
    }

    public void add(IAction iAction) {
        this.list.add(iAction);
    }

    public Menu getMenu(Control control) {
        if (this.dropDownMenu == null) {
            this.dropDownMenu = new Menu(control);
            this.populateMenu();
        }
        return this.dropDownMenu;
    }

    public Menu getMenu(Menu menu) {
        if (this.dropDownMenu == null) {
            this.dropDownMenu = new Menu(menu);
            this.populateMenu();
        }
        return this.dropDownMenu;
    }

    private void populateMenu() {
        for (Object e : this.list) {
            IContributionItem iContributionItem;
            if (e instanceof IContributionItem) {
                iContributionItem = (IContributionItem)e;
                iContributionItem.fill(this.dropDownMenu, -1);
                continue;
            }
            iContributionItem = (IAction)e;
            ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)iContributionItem);
            actionContributionItem.fill(this.dropDownMenu, -1);
        }
        MenuItem[] menuItemArray = this.dropDownMenu.getItems();
        int n = 0;
        while (n < menuItemArray.length) {
            menuItemArray[n].addSelectionListener(this.selectionListener);
            ++n;
        }
    }

    public void setAction(IAction iAction) {
        if (this.enabledListener == null) {
            this.enabledListener = new EnabledPropertyChangeListener((IAction)this);
        }
        this.setText(iAction.getText());
        this.setToolTipText(iAction.getToolTipText());
        this.setImageDescriptor(iAction.getImageDescriptor());
        this.setDisabledImageDescriptor(iAction.getDisabledImageDescriptor());
        this.setEnabled(iAction.isEnabled());
        this.setDescription(iAction.getDescription());
        this.setHelpListener(iAction.getHelpListener());
        this.setHoverImageDescriptor(iAction.getHoverImageDescriptor());
        if (this.delegate != null) {
            this.delegate.removePropertyChangeListener(this.enabledListener);
        }
        this.delegate = iAction;
        this.delegate.addPropertyChangeListener(this.enabledListener);
    }

    public void run() {
        this.delegate.run();
    }

    public static class EnabledPropertyChangeListener
    implements IPropertyChangeListener {
        private IAction action;

        public EnabledPropertyChangeListener(IAction iAction) {
            this.action = iAction;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getProperty().equals("enabled")) {
                this.action.setEnabled(((Boolean)propertyChangeEvent.getNewValue()).booleanValue());
            }
        }
    }

    public static class ItemSelectionListener
    implements SelectionListener {
        private DropDownMenuWithDefaultAction dropDownMenu;

        public ItemSelectionListener(DropDownMenuWithDefaultAction dropDownMenuWithDefaultAction) {
            this.dropDownMenu = dropDownMenuWithDefaultAction;
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            MenuItem menuItem = (MenuItem)selectionEvent.getSource();
            if (menuItem.getData() instanceof ActionContributionItem) {
                ActionContributionItem actionContributionItem = (ActionContributionItem)menuItem.getData();
                this.dropDownMenu.setAction(actionContributionItem.getAction());
            }
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            MenuItem menuItem = (MenuItem)selectionEvent.getSource();
            if (menuItem.getData() instanceof ActionContributionItem) {
                ActionContributionItem actionContributionItem = (ActionContributionItem)menuItem.getData();
                this.dropDownMenu.setAction(actionContributionItem.getAction());
            }
        }
    }
}

