/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete.part;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.drools.eclipse.editors.rete.commands.NodeSetConstraintCommand;
import org.drools.eclipse.editors.rete.model.ModelElement;
import org.drools.eclipse.editors.rete.model.ReteGraph;
import org.drools.reteoo.BaseVertex;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class DiagramEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new NodesXYLayoutEditPolicy());
    }

    protected IFigure createFigure() {
        FreeformLayer freeformLayer = new FreeformLayer();
        freeformLayer.setBorder((Border)new MarginBorder(3));
        freeformLayer.setLayoutManager((LayoutManager)new FreeformLayout());
        return freeformLayer;
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    private ReteGraph getCastedModel() {
        return (ReteGraph)this.getModel();
    }

    protected List getModelChildren() {
        return this.getCastedModel().getChildren();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("ReteGraph.ChildAdded".equals(string) || "ReteGraph.ChildRemoved".equals(string)) {
            this.refreshChildren();
        }
    }

    public Object getAdapter(Class clazz) {
        return super.getAdapter(clazz);
    }

    private static class NodesXYLayoutEditPolicy
    extends XYLayoutEditPolicy {
        private NodesXYLayoutEditPolicy() {
        }

        protected Command createChangeConstraintCommand(ChangeBoundsRequest changeBoundsRequest, EditPart editPart, Object object) {
            if (editPart instanceof NodeEditPart && object instanceof Rectangle) {
                return new NodeSetConstraintCommand((BaseVertex)editPart.getModel(), changeBoundsRequest, (Rectangle)object);
            }
            return super.createChangeConstraintCommand(changeBoundsRequest, editPart, object);
        }

        protected Command createChangeConstraintCommand(EditPart editPart, Object object) {
            return null;
        }

        protected Command getCreateCommand(CreateRequest createRequest) {
            return null;
        }
    }
}

