/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete;

import java.util.HashSet;
import java.util.List;
import org.drools.eclipse.editors.rete.RowList;
import org.drools.eclipse.editors.rete.model.Connection;
import org.drools.eclipse.editors.rete.model.ReteGraph;
import org.drools.reteoo.BaseVertex;
import org.eclipse.draw2d.geometry.Point;

public class ReteooLayoutFactory {
    public static RowList calculateReteRows(BaseVertex baseVertex) {
        RowList rowList = new RowList();
        rowList.add(0, baseVertex);
        int n = 0;
        HashSet<BaseVertex> hashSet = new HashSet<BaseVertex>();
        hashSet.add(baseVertex);
        while (n < rowList.getDepth()) {
            List list = rowList.get(n).getVertices();
            for (BaseVertex baseVertex2 : list) {
                List list2 = baseVertex2.getSourceConnections();
                for (Connection connection : list2) {
                    BaseVertex baseVertex3 = connection.getOpposite(baseVertex2);
                    if (hashSet.contains(baseVertex3)) continue;
                    rowList.add(n + 1, baseVertex3);
                    hashSet.add(baseVertex3);
                }
                hashSet.add(baseVertex2);
            }
            ++n;
        }
        rowList.optimize();
        return rowList;
    }

    public static void layoutRowList(ReteGraph reteGraph, RowList rowList) {
        new LayoutCalculator(reteGraph, rowList);
    }

    private static class LayoutCalculator {
        public static final String COORDS = "drools.LayoutCalculator.coords";
        private static final int COLUMN_SPACE = 40;
        private static final int ROW_HEIGHT_MULTIPLIER = 6;
        private RowList rowList;
        private int columnWidth;
        private int rowHeight;
        private ReteGraph graph;

        private LayoutCalculator(ReteGraph reteGraph, RowList rowList) {
            this.graph = reteGraph;
            this.rowList = rowList;
            this.computeSize();
            List list = this.getGraph().getChildren();
            for (BaseVertex baseVertex : list) {
                this.initialize_local_vertex(baseVertex);
            }
        }

        private void computeSize() {
            List list = this.getGraph().getChildren();
            for (BaseVertex baseVertex : list) {
                int n = baseVertex.getSize().width;
                int n2 = baseVertex.getSize().height;
                if (n > this.columnWidth) {
                    this.columnWidth = n;
                }
                if (n2 <= this.rowHeight) continue;
                this.rowHeight = n2;
            }
            this.columnWidth += 40;
        }

        private void initialize_local_vertex(BaseVertex baseVertex) {
            int n = this.rowList.getRow(baseVertex);
            int n2 = this.rowList.getColumn(baseVertex);
            int n3 = this.rowList.getWidth(n);
            int n4 = this.columnWidth;
            int n5 = this.rowHeight;
            double d = n2 * n4;
            double d2 = n * (n5 * 6);
            d = d + (double)(n4 / 2) - (double)((n3 - 1) * (n4 / 2));
            d2 = d2 + (double)(n5 / 2) + 3.0;
            baseVertex.setLocation(new Point(d, d2));
        }

        private ReteGraph getGraph() {
            return this.graph;
        }
    }
}

