/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete;

import java.util.ArrayList;
import java.util.Iterator;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.builder.DroolsBuilder;
import org.drools.eclipse.editors.DRLRuleEditor;
import org.drools.eclipse.editors.rete.ReteooLayoutFactory;
import org.drools.eclipse.editors.rete.RowList;
import org.drools.eclipse.editors.rete.model.ReteGraph;
import org.drools.eclipse.editors.rete.part.VertexEditPartFactory;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.reteoo.BaseVertex;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooVisitor;
import org.drools.rule.Package;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IEditorPart;

public class ReteViewer
extends GraphicalEditor {
    public static final String MSG_PARSE_ERROR = "Unable to parse rules to show RETE view!";
    private static final int SIMPLE_ROUTER_MIN_NODES = 100;
    ScalableFreeformRootEditPart rootEditPart = new ScalableFreeformRootEditPart();
    private ReteGraph diagram = new ReteGraph();
    private boolean relayoutRequired = true;
    private DRLRuleEditor drlEditor;

    public ReteViewer(DRLRuleEditor dRLRuleEditor) {
        this.drlEditor = dRLRuleEditor;
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        graphicalViewer.getControl().setBackground(ColorConstants.white);
        graphicalViewer.setEditPartFactory((EditPartFactory)new VertexEditPartFactory());
        graphicalViewer.setRootEditPart((RootEditPart)this.rootEditPart);
        graphicalViewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(graphicalViewer));
    }

    public Object getAdapter(Class clazz) {
        if (clazz == ZoomManager.class) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (clazz == GraphicalViewer.class) {
            return this.getGraphicalViewer();
        }
        if (clazz == EditPart.class && this.getGraphicalViewer() != null) {
            return this.getGraphicalViewer().getRootEditPart();
        }
        if (clazz == IFigure.class && this.getGraphicalViewer() != null) {
            return ((GraphicalEditPart)this.getGraphicalViewer().getRootEditPart()).getFigure();
        }
        return super.getAdapter(clazz);
    }

    public ReteGraph loadReteModel(IProgressMonitor iProgressMonitor, String string) throws Throwable {
        if (!this.relayoutRequired) {
            return this.diagram;
        }
        ReteGraph reteGraph = new ReteGraph();
        try {
            Object object;
            Object object2;
            Object object3;
            iProgressMonitor.beginTask("Loading RETE Tree", 100);
            iProgressMonitor.subTask("Loading Rule Base");
            ReteooRuleBase reteooRuleBase = null;
            try {
                object3 = this.drlEditor.getResource();
                object2 = DroolsBuilder.class.getClassLoader();
                if (object3.getProject().getNature("org.eclipse.jdt.core.javanature") != null) {
                    object = JavaCore.create((IProject)object3.getProject());
                    object2 = ProjectClassLoader.getProjectClassLoader((IJavaProject)object);
                }
                if ((object = DroolsEclipsePlugin.getDefault().parseResource(this.drlEditor, true, true)) == null) {
                    throw new Exception("Could not find DRL info");
                }
                if (((DRLInfo)object).getBuilderErrors().length > 0) {
                    throw new Exception(String.valueOf(((DRLInfo)object).getBuilderErrors().length) + " build errors");
                }
                if (((DRLInfo)object).getParserErrors().size() > 0) {
                    throw new Exception(String.valueOf(((DRLInfo)object).getParserErrors().size()) + " parser errors");
                }
                Package package_ = ((DRLInfo)object).getPackage();
                RuleBaseConfiguration ruleBaseConfiguration = new RuleBaseConfiguration();
                ruleBaseConfiguration.setClassLoader(new ClassLoader[]{object2});
                reteooRuleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)ruleBaseConfiguration);
                if (package_ != null) {
                    reteooRuleBase.addPackage(package_);
                }
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
                throw new Exception("Unable to parse rules to show RETE view! " + throwable.getMessage());
            }
            iProgressMonitor.worked(50);
            if (iProgressMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            iProgressMonitor.subTask("Building RETE Tree");
            object3 = new ReteooVisitor(reteGraph);
            ((ReteooVisitor)((Object)object3)).visitReteooRuleBase(reteooRuleBase);
            iProgressMonitor.worked(30);
            if (iProgressMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            iProgressMonitor.subTask("Calculating RETE Tree Layout");
            object2 = ((ReteooVisitor)((Object)object3)).getRootVertex();
            object = ReteooLayoutFactory.calculateReteRows((BaseVertex)object2);
            ReteooLayoutFactory.layoutRowList(reteGraph, (RowList)object);
            this.zeroBaseDiagram(reteGraph);
            iProgressMonitor.worked(20);
            if (iProgressMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            iProgressMonitor.done();
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof InterruptedException)) {
                DroolsEclipsePlugin.log(throwable);
            }
            throw throwable;
        }
        this.relayoutRequired = false;
        return reteGraph;
    }

    private ReteGraph getModel() {
        return this.diagram;
    }

    protected void initializeGraphicalViewer() {
        ZoomManager zoomManager = this.rootEditPart.getZoomManager();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(ZoomManager.FIT_ALL);
        arrayList.add(ZoomManager.FIT_HEIGHT);
        arrayList.add(ZoomManager.FIT_WIDTH);
        zoomManager.setZoomLevelContributions(arrayList);
        this.getGraphicalViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
    }

    private void zeroBaseDiagram(ReteGraph reteGraph) {
        Dimension dimension = this.rootEditPart.getContentPane().getSize();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = dimension.width;
        Iterator iterator = reteGraph.getChildren().iterator();
        while (iterator.hasNext()) {
            Point point = ((BaseVertex)iterator.next()).getLocation();
            n = Math.min(point.x, n);
            n3 = Math.max(point.x, n3);
            n2 = Math.min(point.y, n2);
        }
        int n5 = (n4 - (n3 - n + 20)) / 2;
        n -= n5;
        for (BaseVertex baseVertex : reteGraph.getChildren()) {
            Point point = baseVertex.getLocation();
            baseVertex.setLocation(new Point(point.x - n, point.y - n2));
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public boolean isDirty() {
        return false;
    }

    public void fireDocumentChanged() {
        this.relayoutRequired = true;
    }

    public void drawGraph(ReteGraph reteGraph) {
        boolean bl;
        LayerManager layerManager = (LayerManager)this.getGraphicalViewer().getEditPartRegistry().get(LayerManager.ID);
        ConnectionLayer connectionLayer = (ConnectionLayer)layerManager.getLayer((Object)"Connection Layer");
        if (this.getGraphicalViewer().getContents() == null) {
            this.getGraphicalViewer().setContents((Object)this.getModel());
        }
        boolean bl2 = bl = reteGraph != null && reteGraph != this.diagram;
        if (bl) {
            this.diagram.removeAll();
        }
        Object object = bl && reteGraph.getChildren().size() < 100 || !bl && this.getModel().getChildren().size() < 100 ? new ShortestPathConnectionRouter((IFigure)this.rootEditPart.getContentPane().getChildren().get(0)) : ConnectionRouter.NULL;
        connectionLayer.setConnectionRouter(object);
        if (reteGraph != null && reteGraph != this.diagram) {
            this.diagram.addAll(reteGraph.getChildren());
        }
    }
}

