/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.drools.base.ClassTypeResolver;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.core.util.asm.ClassFieldInspector;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.DroolsPluginImages;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.completion.CompletionContext;
import org.drools.eclipse.editors.completion.CompletionUtil;
import org.drools.eclipse.editors.completion.DefaultCompletionProcessor;
import org.drools.eclipse.editors.completion.ReflectionUtils;
import org.drools.eclipse.editors.completion.RuleCompletionProposal;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.lang.Location;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.FieldTemplateDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.rule.builder.dialect.mvel.MVELConsequenceBuilder;
import org.drools.rule.builder.dialect.mvel.MVELDialect;
import org.drools.runtime.rule.RuleContext;
import org.drools.spi.KnowledgeHelper;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IFileEditorInput;
import org.mvel2.ParserContext;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.compiler.ExpressionCompiler;
import org.mvel2.compiler.PropertyVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleCompletionProcessor
extends DefaultCompletionProcessor {
    private static final String DIALECT = "dialect";
    private static final Image DROOLS_ICON = DroolsPluginImages.getImage("Drools");
    private static final Image CLASS_ICON = DroolsPluginImages.getImage("Class");
    private CompletionContext context;

    public RuleCompletionProcessor(AbstractRuleEditor abstractRuleEditor) {
        super(abstractRuleEditor);
    }

    @Override
    protected List getCompletionProposals(ITextViewer iTextViewer, int n) {
        try {
            ArrayList<RuleCompletionProposal> arrayList = new ArrayList<RuleCompletionProposal>();
            IDocument iDocument = iTextViewer.getDocument();
            String string = this.readBackwards(n, iDocument);
            String string2 = CompletionUtil.stripLastWord(string);
            if (string.length() < 5) {
                return arrayList;
            }
            this.context = new CompletionContext(string);
            Location location = this.context.getLocation();
            if (location.getType() == 2000) {
                this.addRuleHeaderProposals(arrayList, n, string2, string);
            } else if (location.getType() == 1000) {
                this.addRHSCompletionProposals(arrayList, n, string2, string, (String)location.getProperty("LHSContent"), (String)location.getProperty("RHSContent"));
            } else {
                this.addLHSCompletionProposals(arrayList, n, location, string2, string);
            }
            RuleCompletionProcessor.filterProposalsOnPrefix(string2, arrayList);
            return arrayList;
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
            return null;
        }
    }

    protected void addRHSCompletionProposals(List list, int n, String string, String string2, String string3, String string4) {
        boolean bl;
        if (string4 == null || string4.length() < string.length()) {
            return;
        }
        String string5 = string4.substring(0, string4.length() - string.length());
        if (this.context == null) {
            this.context = new CompletionContext(string2);
        }
        if (bl = CompletionUtil.isStartOfDialectExpression(string5)) {
            this.addRHSKeywordCompletionProposals(list, n, string);
            this.addRHSFunctionCompletionProposals(list, n, string);
        }
        if (this.isJavaDialect()) {
            this.addRHSJavaCompletionProposals(list, n, string, string2, string4);
        } else if (this.isMvelDialect()) {
            this.addRHSMvelCompletionProposals(list, n, string, string2, string4, bl);
        }
    }

    private boolean isJavaDialect() {
        if (this.context.isJavaDialect()) {
            return true;
        }
        return this.context.isDefaultDialect() && (!this.getAttributes().containsKey(DIALECT) || this.hasPackageDialect("java"));
    }

    private boolean isMvelDialect() {
        if (this.context.isMvelDialect()) {
            return true;
        }
        return this.context.isDefaultDialect() && this.hasPackageDialect("mvel");
    }

    private boolean hasPackageDialect(String string) {
        String string2 = (String)this.getAttributes().get(DIALECT);
        return string2 != null && string.equalsIgnoreCase(string2);
    }

    protected void addLHSCompletionProposals(List<RuleCompletionProposal> list, int n, Location location, String string, String string2) {
        switch (location.getType()) {
            case 1: {
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "and", "and ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "or", "or ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "from", "from ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "forall", "forall(  )", 8, DROOLS_ICON));
                RuleCompletionProposal ruleCompletionProposal = new RuleCompletionProposal(n - string.length(), string.length(), "eval", "eval(  )", 6);
                ruleCompletionProposal.setImage(DROOLS_ICON);
                list.add(ruleCompletionProposal);
                ruleCompletionProposal = new RuleCompletionProposal(n - string.length(), string.length(), "then", "then" + System.getProperty("line.separator") + "\t");
                ruleCompletionProposal.setImage(DROOLS_ICON);
                list.add(ruleCompletionProposal);
            }
            case 3: {
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "not", "not ", DROOLS_ICON));
            }
            case 4: {
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "exists", "exists ", DROOLS_ICON));
            }
            case 2: 
            case 301: 
            case 302: {
                RuleCompletionProposal ruleCompletionProposal;
                String string3;
                int n2;
                for (String string4 : this.getImports()) {
                    n2 = string4.lastIndexOf(".");
                    if (n2 == -1) continue;
                    string3 = string4.substring(n2 + 1);
                    ruleCompletionProposal = new RuleCompletionProposal(n - string.length(), string.length(), string3, String.valueOf(string3) + "(  )", string3.length() + 2);
                    ruleCompletionProposal.setPriority(-1);
                    ruleCompletionProposal.setImage(CLASS_ICON);
                    list.add(ruleCompletionProposal);
                }
                for (String string4 : this.getClassesInPackage()) {
                    n2 = string4.lastIndexOf(".");
                    if (n2 == -1) continue;
                    string3 = string4.substring(n2 + 1);
                    ruleCompletionProposal = new RuleCompletionProposal(n - string.length(), string.length(), string3, String.valueOf(string3) + "(  )", string3.length() + 2);
                    ruleCompletionProposal.setPriority(-1);
                    ruleCompletionProposal.setImage(CLASS_ICON);
                    list.add(ruleCompletionProposal);
                }
                for (String string4 : this.getTemplates()) {
                    RuleCompletionProposal ruleCompletionProposal2 = new RuleCompletionProposal(n - string.length(), string.length(), string4, String.valueOf(string4) + "(  )", string4.length() + 2);
                    ruleCompletionProposal2.setPriority(-1);
                    ruleCompletionProposal2.setImage(CLASS_ICON);
                    list.add(ruleCompletionProposal2);
                }
                break;
            }
            case 100: {
                boolean bl;
                String string5 = (String)location.getProperty("ClassName");
                String string6 = (String)location.getProperty("PropertyName");
                if (string5 == null || (bl = this.addFactTemplatePropertyProposals(n, string, string5, list))) break;
                ClassTypeResolver classTypeResolver = new ClassTypeResolver(this.getUniqueImports(), (ClassLoader)ProjectClassLoader.getProjectClassLoader(this.getEditor()));
                try {
                    Object object2;
                    String string7 = string5;
                    if (string6 != null) {
                        object2 = string6.split("\\.");
                        int n3 = ((String[])object2).length - 1;
                        if (string6.endsWith(".")) {
                            ++n3;
                        }
                        int n4 = 0;
                        while (n4 < n3) {
                            Object object = object2[n4];
                            string7 = this.getSimplePropertyClass(string7, (String)object);
                            string7 = this.convertToNonPrimitiveClass(string7);
                            ++n4;
                        }
                    }
                    object2 = new RuleCompletionProposal(n - string.length(), string.length(), "this");
                    ((RuleCompletionProposal)object2).setImage(METHOD_ICON);
                    list.add((RuleCompletionProposal)object2);
                    Class clazz = classTypeResolver.resolveType(string7);
                    if (clazz == null) break;
                    if (Map.class.isAssignableFrom(clazz)) {
                        object2 = new RuleCompletionProposal(n - string.length(), string.length(), "this['']", "this['']", 6);
                        ((RuleCompletionProposal)object2).setImage(METHOD_ICON);
                        list.add((RuleCompletionProposal)object2);
                    }
                    ClassFieldInspector classFieldInspector = new ClassFieldInspector(clazz);
                    Map list22 = classFieldInspector.getFieldTypes();
                    for (String string3 : classFieldInspector.getFieldNames().keySet()) {
                        object2 = new RuleCompletionProposal(n - string.length(), string.length(), string3, String.valueOf(string3) + " ");
                        ((RuleCompletionProposal)object2).setImage(METHOD_ICON);
                        list.add((RuleCompletionProposal)object2);
                        Class clazz2 = (Class)list22.get(string3);
                        if (clazz2 == null || !Map.class.isAssignableFrom(clazz2)) continue;
                        string3 = String.valueOf(string3) + "['']";
                        object2 = new RuleCompletionProposal(n - string.length(), string.length(), string3, string3, string3.length() - 2);
                        ((RuleCompletionProposal)object2).setImage(METHOD_ICON);
                        list.add((RuleCompletionProposal)object2);
                    }
                }
                catch (IOException iOException) {
                }
                catch (ClassNotFoundException classNotFoundException) {}
                break;
            }
            case 101: {
                String string9 = (String)location.getProperty("ClassName");
                String string10 = (String)location.getProperty("PropertyName");
                String string11 = this.getPropertyClass(string9, string10);
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "==", "== ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "!=", "!= ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), ":", ": ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "->", "-> (  )", 5, DROOLS_ICON));
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "memberOf", "memberOf ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "not memberOf", "not memberOf ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "in", "in (  )", 5, DROOLS_ICON));
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "not in", "not in (  )", 9, DROOLS_ICON));
                if (this.isComparable(string11)) {
                    list.add(new RuleCompletionProposal(n - string.length(), string.length(), "<", "< ", DROOLS_ICON));
                    list.add(new RuleCompletionProposal(n - string.length(), string.length(), "<=", "<= ", DROOLS_ICON));
                    list.add(new RuleCompletionProposal(n - string.length(), string.length(), ">", "> ", DROOLS_ICON));
                    list.add(new RuleCompletionProposal(n - string.length(), string.length(), ">=", ">= ", DROOLS_ICON));
                }
                if (string11.equals("java.lang.String")) {
                    list.add(new RuleCompletionProposal(n - string.length(), string.length(), "matches", "matches \"\"", 9, DROOLS_ICON));
                    list.add(new RuleCompletionProposal(n - string.length(), string.length(), "not matches", "not matches \"\"", 13, DROOLS_ICON));
                }
                if (!this.isSubtypeOf(string11, "java.util.Collection")) break;
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "contains", "contains ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "not contains", "not contains ", DROOLS_ICON));
                break;
            }
            case 102: {
                RuleCompletionProposal ruleCompletionProposal;
                String string12 = (String)location.getProperty("ClassName");
                String string13 = (String)location.getProperty("PropertyName");
                String string14 = (String)location.getProperty("Operator");
                String string15 = this.getPropertyClass(string12, string13);
                if ("in".equals(string14)) {
                    list.add(new RuleCompletionProposal(n - string.length(), string.length(), "()", "(  )", 2, DROOLS_ICON));
                    break;
                }
                if ("contains".equals(string14) || "excludes".equals(string14)) {
                    string15 = "java.lang.Object";
                }
                if ("memberOf".equals(string14)) {
                    string15 = "java.util.Collection";
                }
                boolean bl = false;
                if ("java.lang.Object".equals(string15)) {
                    bl = true;
                }
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "null", "null ", DROOLS_ICON));
                if ("boolean".equals(string15)) {
                    list.add(new RuleCompletionProposal(n - string.length(), string.length(), "true", "true ", DROOLS_ICON));
                    list.add(new RuleCompletionProposal(n - string.length(), string.length(), "false", "false ", DROOLS_ICON));
                }
                if (bl || "java.lang.String".equals(string15)) {
                    list.add(new RuleCompletionProposal(n - string.length(), string.length(), "\"\"", "\"\"", 1, DROOLS_ICON));
                }
                if (bl || "java.util.Date".equals(string15)) {
                    list.add(new RuleCompletionProposal(n - string.length(), string.length(), "\"dd-mmm-yyyy\"", "\"dd-mmm-yyyy\"", 1, DROOLS_ICON));
                }
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "()", "(  )", 2, DROOLS_ICON));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                this.addRuleParameters(hashMap, this.context.getRuleParameters());
                for (Map.Entry entry : hashMap.entrySet()) {
                    String string21 = (String)entry.getKey();
                    String string4 = (String)entry.getValue();
                    if (!this.isSubtypeOf(string4, string15)) continue;
                    ruleCompletionProposal = new RuleCompletionProposal(n - string.length(), string.length(), string21);
                    ruleCompletionProposal.setPriority(-1);
                    ruleCompletionProposal.setImage(VARIABLE_ICON);
                    list.add(ruleCompletionProposal);
                }
                List<GlobalDescr> list2 = this.getGlobals();
                if (list2 == null) break;
                for (GlobalDescr string23 : list2) {
                    if (!this.isSubtypeOf(string23.getType(), string15)) continue;
                    ruleCompletionProposal = new RuleCompletionProposal(n - string.length(), string.length(), string23.getIdentifier());
                    ruleCompletionProposal.setPriority(-1);
                    ruleCompletionProposal.setImage(VARIABLE_ICON);
                    list.add(ruleCompletionProposal);
                }
                break;
            }
            case 200: {
                String string5 = (String)location.getProperty("EvalContent");
                list.addAll(this.getJavaCompletionProposals(n, string5, string, this.getRuleParameters(string2)));
                break;
            }
            case 103: {
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "&&", "&& ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "||", "|| ", DROOLS_ICON));
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), ",", ", ", DROOLS_ICON));
                break;
            }
            case 300: {
                String string6 = (String)location.getProperty("FromContent");
                int n2 = string6.indexOf(46);
                if (n2 != -1) break;
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "accumulate", "accumulate (  , init (  ), action (  ), result (  ) )", 13, DROOLS_ICON));
                PackageBuilderConfiguration packageBuilderConfiguration = new PackageBuilderConfiguration(new ClassLoader[]{ProjectClassLoader.getProjectClassLoader(this.getEditor()), null});
                Map map = packageBuilderConfiguration.getAccumulateFunctionsMap();
                for (Object object : map.keySet()) {
                    list.add(new RuleCompletionProposal(n - string.length(), string.length(), "accumulate " + (String)object, "accumulate (  , " + (String)object + "(  ) )", 13, DROOLS_ICON));
                }
                list.add(new RuleCompletionProposal(n - string.length(), string.length(), "collect", "collect (  )", 10, DROOLS_ICON));
                if ("".equals(string6)) {
                    Object object;
                    object = this.getFunctions();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string7 = String.valueOf((String)iterator.next()) + "()";
                        RuleCompletionProposal ruleCompletionProposal = new RuleCompletionProposal(n - string.length(), string.length(), string7, string7, string7.length() - 1);
                        ruleCompletionProposal.setPriority(-1);
                        ruleCompletionProposal.setImage(METHOD_ICON);
                        list.add(ruleCompletionProposal);
                    }
                }
                list.addAll(this.getJavaCompletionProposals(n, string6, string, this.getRuleParameters(string2)));
                break;
            }
            case 304: {
                String string8 = (String)location.getProperty("FromAccumulateInitContent");
                list.addAll(this.getJavaCompletionProposals(n, string8, string, this.getRuleParameters(string2)));
                break;
            }
            case 306: {
                String string10 = (String)location.getProperty("FromAccumulateInitContent");
                string10 = String.valueOf(string10) + (String)location.getProperty("FromAccumulateActionContent");
                list.addAll(this.getJavaCompletionProposals(n, string10, string, this.getRuleParameters(string2)));
                break;
            }
            case 310: {
                String string13 = (String)location.getProperty("FromAccumulateInitContent");
                string13 = String.valueOf(string13) + (String)location.getProperty("FromAccumulateActionContent");
                string13 = String.valueOf(string13) + (String)location.getProperty("FromAccumulateResultContent");
                list.addAll(this.getJavaCompletionProposals(n, string13, string, this.getRuleParameters(string2)));
            }
        }
    }

    private String getPropertyClass(String string, String string2) {
        if (string != null && string2 != null) {
            FactTemplateDescr factTemplateDescr = this.getTemplate(string);
            if (factTemplateDescr != null) {
                for (FieldTemplateDescr fieldTemplateDescr : factTemplateDescr.getFields()) {
                    if (!string2.equals(fieldTemplateDescr.getName())) continue;
                    String string3 = fieldTemplateDescr.getClassType();
                    if (this.isPrimitiveType(string3)) {
                        return string3;
                    }
                    ClassTypeResolver classTypeResolver = new ClassTypeResolver(this.getUniqueImports(), (ClassLoader)ProjectClassLoader.getProjectClassLoader(this.getEditor()));
                    try {
                        Class clazz = classTypeResolver.resolveType(string3);
                        if (clazz == null) continue;
                        return clazz.getName();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        DroolsEclipsePlugin.log(classNotFoundException);
                    }
                }
            } else {
                String[] stringArray = string2.split("\\.");
                String string4 = string;
                int n = 0;
                while (n < stringArray.length) {
                    String string5 = stringArray[n];
                    string4 = this.getSimplePropertyClass(string4, string5);
                    ++n;
                }
                return string4;
            }
        }
        return null;
    }

    private String getSimplePropertyClass(String string, String string2) {
        if ("this".equals(string2)) {
            return string;
        }
        if (string2.endsWith("]")) {
            return "java.lang.Object";
        }
        ClassTypeResolver classTypeResolver = new ClassTypeResolver(this.getUniqueImports(), (ClassLoader)ProjectClassLoader.getProjectClassLoader(this.getEditor()));
        try {
            Class clazz;
            Class clazz2 = classTypeResolver.resolveType(string);
            if (clazz2 != null && (clazz = (Class)new ClassFieldInspector(clazz2).getFieldTypes().get(string2)) != null) {
                return clazz.getName();
            }
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return "java.lang.Object";
    }

    private Map getRuleParameters(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List<GlobalDescr> list = this.getGlobals();
        if (list != null) {
            for (GlobalDescr globalDescr : list) {
                hashMap.put(globalDescr.getIdentifier(), globalDescr.getType());
            }
        }
        if (this.context == null) {
            this.context = new CompletionContext(string);
        }
        this.addRuleParameters(hashMap, this.context.getRuleParameters());
        return hashMap;
    }

    private boolean isComparable(String string) {
        if (string == null) {
            return false;
        }
        if (this.isPrimitiveNumericType(string)) {
            return true;
        }
        if (this.isObjectNumericType(string)) {
            return true;
        }
        return this.isSubtypeOf(string, "java.lang.Comparable");
    }

    private boolean isPrimitiveType(String string) {
        return this.isPrimitiveNumericType(string) || string.equals("boolean");
    }

    private boolean isPrimitiveNumericType(String string) {
        return string.equals("byte") || string.equals("short") || string.equals("int") || string.equals("long") || string.equals("float") || string.equals("double") || string.equals("char");
    }

    private boolean isObjectNumericType(String string) {
        return string.equals("java.lang.Byte") || string.equals("java.lang.Short") || string.equals("java.lang.Integer") || string.equals("java.lang.Long") || string.equals("java.lang.Float") || string.equals("java.lang.Double") || string.equals("java.lang.Char");
    }

    private boolean isSubtypeOf(String string, String string2) {
        Class clazz;
        Class clazz2;
        block4: {
            if (string == null || string2 == null) {
                return false;
            }
            string = this.convertToNonPrimitiveClass(string);
            string2 = this.convertToNonPrimitiveClass(string2);
            ClassTypeResolver classTypeResolver = new ClassTypeResolver(this.getUniqueImports(), (ClassLoader)ProjectClassLoader.getProjectClassLoader(this.getEditor()));
            try {
                clazz2 = classTypeResolver.resolveType(string);
                clazz = classTypeResolver.resolveType(string2);
                if (clazz2 != null && clazz != null) break block4;
                return false;
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
        }
        return clazz.isAssignableFrom(clazz2);
    }

    private String convertToNonPrimitiveClass(String string) {
        if (!this.isPrimitiveType(string)) {
            return string;
        }
        if ("byte".equals(string)) {
            return "java.lang.Byte";
        }
        if ("short".equals(string)) {
            return "java.lang.Short";
        }
        if ("int".equals(string)) {
            return "java.lang.Integer";
        }
        if ("long".equals(string)) {
            return "java.lang.Long";
        }
        if ("float".equals(string)) {
            return "java.lang.Float";
        }
        if ("double".equals(string)) {
            return "java.lang.Double";
        }
        if ("char".equals(string)) {
            return "java.lang.Char";
        }
        if ("boolean".equals(string)) {
            return "java.lang.Boolean";
        }
        return null;
    }

    private void addRHSFunctionCompletionProposals(List list, int n, String string) {
        List list2 = this.getFunctions();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            String string2 = String.valueOf((String)iterator.next()) + "()";
            RuleCompletionProposal ruleCompletionProposal = new RuleCompletionProposal(n - string.length(), string.length(), string2, String.valueOf(string2) + ";", string2.length() - 1);
            ruleCompletionProposal.setPriority(-1);
            ruleCompletionProposal.setImage(METHOD_ICON);
            list.add(ruleCompletionProposal);
        }
    }

    private void addRHSKeywordCompletionProposals(List list, int n, String string) {
        RuleCompletionProposal ruleCompletionProposal = new RuleCompletionProposal(n - string.length(), string.length(), "update", "update();", 7);
        ruleCompletionProposal.setImage(DROOLS_ICON);
        list.add(ruleCompletionProposal);
        ruleCompletionProposal = new RuleCompletionProposal(n - string.length(), string.length(), "retract", "retract();", 8);
        ruleCompletionProposal.setImage(DROOLS_ICON);
        list.add(ruleCompletionProposal);
        ruleCompletionProposal = new RuleCompletionProposal(n - string.length(), string.length(), "insert", "insert();", 7);
        ruleCompletionProposal.setImage(DROOLS_ICON);
        list.add(ruleCompletionProposal);
        ruleCompletionProposal = new RuleCompletionProposal(n - string.length(), string.length(), "insertLogical", "insertLogical();", 14);
        ruleCompletionProposal.setImage(DROOLS_ICON);
        list.add(ruleCompletionProposal);
    }

    private void addRHSJavaCompletionProposals(List list, int n, String string, String string2, String string3) {
        list.addAll(this.getJavaCompletionProposals(n, string3, string, this.getRuleParameters(string2)));
    }

    private void addRHSMvelCompletionProposals(List list, int n, String string, String string2, String string3, boolean bl) {
        Collection collection = this.getMvelCompletionProposals(string3, n, string, this.getRuleParameters(string2), string2, bl);
        list.addAll(collection);
    }

    private Collection getMvelCompletionProposals(String string, int n, String string2, Map map, String string3, boolean bl) {
        Object object;
        HashSet<RuleCompletionProposal> hashSet = new HashSet<RuleCompletionProposal>();
        if (!(this.getEditor().getEditorInput() instanceof IFileEditorInput)) {
            return hashSet;
        }
        try {
            boolean bl2;
            object = DroolsEclipsePlugin.getDefault().generateParsedResource("package dummy; \n" + string3, (IResource)((IFileEditorInput)this.getEditor().getEditorInput()).getFile(), false, false);
            String string4 = CompletionUtil.getTextWithoutPrefix(string, string2);
            boolean bl3 = CompletionUtil.isStartOfDialectExpression(string4);
            boolean bl4 = string4.endsWith(".");
            String string5 = CompletionUtil.getPreviousExpression(string);
            MvelContext mvelContext = this.analyzeMvelExpression(this.getResolvedMvelInputs(map), (DRLInfo)object, string5);
            HashMap hashMap = mvelContext.getContext().getVariables();
            Map map2 = mvelContext.getContext().getInputs();
            map2.putAll(hashMap);
            String string6 = CompletionUtil.getTextWithoutPrefix(CompletionUtil.getInnerExpression(string), string2);
            String string7 = CompletionUtil.getCompilableText(string6);
            MvelContext mvelContext2 = this.analyzeMvelExpression(map2, (DRLInfo)object, string7);
            String string8 = CompletionUtil.getLastExpression(string).trim();
            Matcher matcher = CompletionUtil.MODIFY_PATTERN.matcher(string8);
            boolean bl5 = bl2 = matcher.matches() && matcher.groupCount() == 3;
            if (bl4) {
                if (mvelContext2.isStaticFlag()) {
                    return this.getMvelClassCompletionsFromJDT(n, "", map, mvelContext2.getReturnedType());
                }
                return this.getMvelInstanceCompletionsFromJDT(n, "", map, mvelContext2.getReturnedType(), false);
            }
            if (bl3 && bl2) {
                String string9 = matcher.group(1);
                MvelContext mvelContext3 = this.analyzeMvelExpression(map2, (DRLInfo)object, string9);
                Class clazz = mvelContext3.getReturnedType();
                Collection collection = this.getMvelInstanceCompletionsFromJDT(n, "", map, clazz, true);
                hashSet.addAll(collection);
                return hashSet;
            }
            RuleCompletionProcessor.addMvelCompletions(hashSet, n, string2, mvelContext2.getContext().getVariables());
            RuleCompletionProcessor.addMvelCompletions(hashSet, n, string2, mvelContext2.getContext().getInputs());
            List<RuleCompletionProposal> list = this.getJavaCompletionProposals(n, string2, string2, map);
            hashSet.addAll(list);
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
        }
        object = new HashSet();
        RuleCompletionProcessor.addAllNewProposals(object, hashSet);
        return object;
    }

    private Map getResolvedMvelInputs(Map map) {
        ClassTypeResolver classTypeResolver = new ClassTypeResolver(this.getUniqueImports(), (ClassLoader)ProjectClassLoader.getProjectClassLoader(this.getEditor()));
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getValue();
            try {
                Class clazz = classTypeResolver.resolveType(string);
                hashMap.put(entry.getKey(), clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                DroolsEclipsePlugin.log(classNotFoundException);
            }
        }
        return hashMap;
    }

    private MvelContext analyzeMvelExpression(Map map, DRLInfo dRLInfo, String string) {
        String string2 = RuleCompletionProcessor.processMacros(string);
        String string3 = this.context.getRuleName();
        RuleCompletionProcessor.getCurrentRule(dRLInfo, string3);
        String string4 = String.valueOf(dRLInfo.getPackageName()) + "." + string3;
        MVELDialect mVELDialect = (MVELDialect)dRLInfo.getDialectRegistry().getDialect("mvel");
        ParserContext parserContext = RuleCompletionProcessor.createInitialContext(map, string4, mVELDialect);
        MvelContext mvelContext = new MvelContext();
        mvelContext.setInitialContext(parserContext);
        try {
            ExpressionCompiler expressionCompiler = new ExpressionCompiler(string2);
            CompiledExpression compiledExpression = expressionCompiler.compile(parserContext);
            mvelContext.setExpression(compiledExpression);
            ParserContext parserContext2 = expressionCompiler.getParserContextState();
            Class<Object> clazz = compiledExpression.getKnownEgressType();
            if (clazz != null && "java.lang.Class".equals(clazz.getName())) {
                mvelContext.setStaticFlag(true);
            }
            if (clazz == null || "java.lang.Object".equals(clazz.getName()) || "java.lang.Class".equals(clazz.getName())) {
                clazz = new PropertyVerifier(string2, parserContext2).analyze();
            }
            if (clazz == null) {
                clazz = Object.class;
            }
            mvelContext.setReturnedType(clazz);
        }
        catch (Exception exception) {}
        return mvelContext;
    }

    private static ParserContext createInitialContext(Map map, String string, MVELDialect mVELDialect) {
        ParserContext parserContext = new ParserContext(mVELDialect.getImports(), null, string);
        if (mVELDialect.getPackgeImports() != null) {
            for (String string2 : mVELDialect.getPackgeImports().values()) {
                parserContext.addPackageImport(string2);
            }
        }
        parserContext.setStrictTypeEnforcement(false);
        parserContext.setInterceptors(mVELDialect.getInterceptors());
        parserContext.setInputs(map);
        parserContext.addInput("drools", KnowledgeHelper.class);
        parserContext.addInput("kcontext", RuleContext.class);
        parserContext.setCompiled(true);
        return parserContext;
    }

    public static String processMacros(String string) {
        MVELConsequenceBuilder mVELConsequenceBuilder = new MVELConsequenceBuilder();
        String string2 = MVELConsequenceBuilder.processMacros((String)string.trim());
        return string2;
    }

    private static DRLInfo.RuleInfo getCurrentRule(DRLInfo dRLInfo, String string) {
        DRLInfo.RuleInfo ruleInfo = null;
        DRLInfo.RuleInfo[] ruleInfoArray = dRLInfo.getRuleInfos();
        int n = 0;
        while (n < ruleInfoArray.length) {
            if (string.equals(ruleInfoArray[n].getRuleName())) {
                ruleInfo = ruleInfoArray[n];
                break;
            }
            ++n;
        }
        return ruleInfo;
    }

    private Collection getMvelInstanceCompletionsFromJDT(int n, String string, Map map, Class clazz, boolean bl) {
        if (clazz == null) {
            clazz = Object.class;
        }
        String string2 = "\n" + clazz.getPackage().getName() + "." + CompletionUtil.getSimpleClassName(clazz) + " " + "mvdrlofc" + ";\n" + "mvdrlofc" + ".";
        ArrayList arrayList = new ArrayList();
        this.requestJavaCompletionProposals(string2, string, n, map, arrayList);
        ArrayList arrayList2 = arrayList;
        Collection collection = RuleCompletionProcessor.mvelifyProposals(arrayList2, bl);
        return collection;
    }

    private Collection getMvelClassCompletionsFromJDT(int n, String string, Map map, Class clazz) {
        if (clazz == null) {
            clazz = Object.class;
        }
        String string2 = "\n" + CompletionUtil.getSimpleClassName(clazz) + ".";
        ArrayList arrayList = new ArrayList();
        this.requestJavaCompletionProposals(string2, string, n, map, arrayList);
        ArrayList arrayList2 = arrayList;
        Collection collection = RuleCompletionProcessor.mvelifyProposals(arrayList2, false);
        return collection;
    }

    private static void addMvelCompletions(Collection collection, int n, String string, Map map) {
        HashSet<RuleCompletionProposal> hashSet = new HashSet<RuleCompletionProposal>();
        for (Map.Entry entry : map.entrySet()) {
            String string2 = (String)entry.getKey();
            Class clazz = (Class)entry.getValue();
            String string3 = String.valueOf(string2) + "  " + CompletionUtil.getSimpleClassName(clazz);
            RuleCompletionProposal ruleCompletionProposal = new RuleCompletionProposal(n - string.length(), string.length(), string3, string2);
            ruleCompletionProposal.setImage(DefaultCompletionProcessor.VARIABLE_ICON);
            hashSet.add(ruleCompletionProposal);
        }
        RuleCompletionProcessor.addAllNewProposals(collection, hashSet);
    }

    public static void addAllNewProposals(Collection collection, Collection collection2) {
        for (ICompletionProposal iCompletionProposal : collection2) {
            String string = iCompletionProposal.getDisplayString();
            if (RuleCompletionProcessor.containsProposal(collection, string)) continue;
            collection.add(iCompletionProposal);
        }
    }

    public static boolean containsProposal(Collection collection, String string) {
        for (ICompletionProposal iCompletionProposal : collection) {
            String[] stringArray;
            String string2 = iCompletionProposal.getDisplayString();
            String[] stringArray2 = string2.split(" ");
            if (stringArray2.length == 0 || (stringArray = string.split(" ")).length == 0 || !stringArray2[0].equals(stringArray[0])) continue;
            return true;
        }
        return false;
    }

    private void addRuleParameters(Map<String, String> map, Map<String, String[]> map2) {
        for (Map.Entry<String, String[]> entry : map2.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue()[0];
            String string3 = entry.getValue()[1];
            String string4 = string3 == null ? string2 : this.getPropertyClass(string2, string3);
            map.put(string, string4);
        }
    }

    private void addRuleHeaderProposals(List list, int n, String string, String string2) {
        list.add(new RuleCompletionProposal(n - string.length(), string.length(), "salience", "salience ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(n - string.length(), string.length(), "no-loop", "no-loop ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(n - string.length(), string.length(), "agenda-group", "agenda-group ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(n - string.length(), string.length(), "duration", "duration ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(n - string.length(), string.length(), "auto-focus", "auto-focus ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(n - string.length(), string.length(), "when", "when" + System.getProperty("line.separator") + "\t ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(n - string.length(), string.length(), "activation-group", "activation-group ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(n - string.length(), string.length(), "date-effective", "date-effective \"dd-MMM-yyyy\"", 16, DROOLS_ICON));
        list.add(new RuleCompletionProposal(n - string.length(), string.length(), "date-expires", "date-expires \"dd-MMM-yyyy\"", 14, DROOLS_ICON));
        list.add(new RuleCompletionProposal(n - string.length(), string.length(), "enabled", "enabled false", DROOLS_ICON));
        list.add(new RuleCompletionProposal(n - string.length(), string.length(), "ruleflow-group", "ruleflow-group \"\"", 16, DROOLS_ICON));
        list.add(new RuleCompletionProposal(n - string.length(), string.length(), "lock-on-active", "lock-on-active ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(n - string.length(), string.length(), "dialect \"java\"", "dialect \"java\" ", DROOLS_ICON));
        list.add(new RuleCompletionProposal(n - string.length(), string.length(), "dialect \"mvel\"", "dialect \"mvel\" ", DROOLS_ICON));
    }

    private boolean addFactTemplatePropertyProposals(int n, String string, String string2, List list) {
        FactTemplateDescr factTemplateDescr = this.getTemplate(string2);
        if (factTemplateDescr == null) {
            return false;
        }
        for (FieldTemplateDescr fieldTemplateDescr : factTemplateDescr.getFields()) {
            String string3 = fieldTemplateDescr.getName();
            RuleCompletionProposal ruleCompletionProposal = new RuleCompletionProposal(n - string.length(), string.length(), string3, String.valueOf(string3) + " ");
            ruleCompletionProposal.setImage(METHOD_ICON);
            list.add(ruleCompletionProposal);
        }
        return true;
    }

    public static Collection mvelifyProposals(List list, boolean bl) {
        HashSet hashSet = new HashSet();
        for (Object e : list) {
            if (e instanceof JavaMethodCompletionProposal) {
                RuleCompletionProcessor.processJavaMethodCompletionProposal(list, bl, hashSet, e);
                continue;
            }
            if (e instanceof JavaCompletionProposal) {
                RuleCompletionProcessor.processesJavaCompletionProposal(bl, hashSet, e);
                continue;
            }
            if (bl) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    private static void processesJavaCompletionProposal(boolean bl, Collection collection, Object object) {
        if (bl) {
            JavaCompletionProposal javaCompletionProposal = (JavaCompletionProposal)object;
            IJavaElement iJavaElement = javaCompletionProposal.getJavaElement();
            if (iJavaElement.getElementType() == 8) {
                collection.add(object);
            }
        } else {
            collection.add(object);
        }
    }

    private static void processJavaMethodCompletionProposal(List list, boolean bl, Collection collection, Object object) {
        LazyJavaCompletionProposal lazyJavaCompletionProposal = (LazyJavaCompletionProposal)object;
        Object object2 = ReflectionUtils.getField(object, "fProposal");
        if (object2 != null && object2 instanceof CompletionProposal) {
            CompletionProposal completionProposal = (CompletionProposal)object2;
            String string = new String(completionProposal.getCompletion());
            String string2 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (bl) {
                string2 = CompletionUtil.getWritablePropertyName(string, completionProposal.getSignature());
                bl2 = !string.equals(string2);
            } else {
                string2 = CompletionUtil.getPropertyName(string, completionProposal.getSignature());
                bl3 = !string.equals(string2);
            }
            boolean bl4 = DefaultCompletionProcessor.doesNotContainFieldCompletion(string2, list);
            if ((bl && bl2 || !bl && bl3) && bl4) {
                RuleCompletionProposal ruleCompletionProposal = new RuleCompletionProposal(lazyJavaCompletionProposal.getReplacementOffset(), lazyJavaCompletionProposal.getReplacementLength(), string2);
                ruleCompletionProposal.setImage(DefaultCompletionProcessor.VARIABLE_ICON);
                ruleCompletionProposal.setPriority(1000);
                collection.add(ruleCompletionProposal);
            } else if (!bl) {
                collection.add(object);
            }
        }
    }

    class MvelContext {
        private CompiledExpression expression;
        private ParserContext initialContext;
        private Class returnedType;
        private boolean staticFlag;

        MvelContext() {
        }

        public ParserContext getContext() {
            if (this.getExpression() != null && this.getExpression().getParserContext() != null) {
                return this.getExpression().getParserContext();
            }
            return this.getInitialContext();
        }

        void setExpression(CompiledExpression compiledExpression) {
            this.expression = compiledExpression;
        }

        CompiledExpression getExpression() {
            return this.expression;
        }

        void setInitialContext(ParserContext parserContext) {
            this.initialContext = parserContext;
        }

        ParserContext getInitialContext() {
            return this.initialContext;
        }

        void setReturnedType(Class clazz) {
            this.returnedType = clazz;
        }

        Class getReturnedType() {
            return this.returnedType;
        }

        public boolean isStaticFlag() {
            return this.staticFlag;
        }

        public void setStaticFlag(boolean bl) {
            this.staticFlag = bl;
        }
    }
}

