/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.core.util.StringUtils;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.DroolsPluginImages;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.DRLRuleEditor;
import org.drools.eclipse.editors.completion.AbstractCompletionProcessor;
import org.drools.eclipse.editors.completion.CompletionUtil;
import org.drools.eclipse.editors.completion.RuleCompletionProposal;
import org.drools.lang.descr.FactTemplateDescr;
import org.drools.lang.descr.GlobalDescr;
import org.drools.rule.builder.dialect.java.KnowledgeHelperFixer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCompletionProcessor
extends AbstractCompletionProcessor {
    private static final String NEW_RULE_TEMPLATE = "rule \"new rule\"" + System.getProperty("line.separator") + "\twhen" + System.getProperty("line.separator") + "\t\t" + System.getProperty("line.separator") + "\tthen" + System.getProperty("line.separator") + "\t\t" + System.getProperty("line.separator") + "end";
    private static final String NEW_QUERY_TEMPLATE = "query \"query name\"" + System.getProperty("line.separator") + "\t#conditions" + System.getProperty("line.separator") + "end";
    private static final String NEW_FUNCTION_TEMPLATE = "function void yourFunction(Type arg) {" + System.getProperty("line.separator") + "\t/* code goes here*/" + System.getProperty("line.separator") + "}";
    private static final String NEW_TEMPLATE_TEMPLATE = "template Name" + System.getProperty("line.separator") + "\t" + System.getProperty("line.separator") + "end";
    protected static final Pattern IMPORT_PATTERN = Pattern.compile(".*\n\\W*import\\W[^;\\s]*", 32);
    private static final Pattern FUNCTION_PATTERN = Pattern.compile(".*\n\\W*function\\s+(\\S+)\\s+(\\S+)\\s*\\(([^\\)]*)\\)\\s*\\{([^\\}]*)", 32);
    protected static final Image VARIABLE_ICON = DroolsPluginImages.getImage("Variable");
    protected static final Image METHOD_ICON = DroolsPluginImages.getImage("Method");
    protected static final Image CLASS_ICON = DroolsPluginImages.getImage("Class");

    public DefaultCompletionProcessor(AbstractRuleEditor abstractRuleEditor) {
        super((IEditorPart)abstractRuleEditor);
    }

    @Override
    protected List getCompletionProposals(ITextViewer iTextViewer, int n) {
        try {
            IDocument iDocument = iTextViewer.getDocument();
            String string = this.readBackwards(n, iDocument);
            String string2 = CompletionUtil.stripLastWord(string);
            List<RuleCompletionProposal> list = null;
            Matcher matcher = IMPORT_PATTERN.matcher(string);
            if (matcher.matches()) {
                String string3 = string.substring(string.lastIndexOf("import") + 7);
                list = this.getAllClassProposals(string3, n, string2);
            } else {
                matcher = FUNCTION_PATTERN.matcher(string);
                if (matcher.matches()) {
                    Map map = this.extractParams(matcher.group(3));
                    String string4 = matcher.group(4);
                    list = this.getJavaCompletionProposals(n, string4, string2, map, false, false);
                    DefaultCompletionProcessor.filterProposalsOnPrefix(string2, list);
                } else {
                    list = this.getPossibleProposals(iTextViewer, n, string, string2);
                }
            }
            return list;
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
            return null;
        }
    }

    private Map extractParams(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = StringUtils.split((String)string, (String)",");
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = StringUtils.split((String)stringArray[n]);
            if (stringArray2.length == 2) {
                hashMap.put(stringArray2[1], stringArray2[0]);
            }
            ++n;
        }
        return hashMap;
    }

    private IJavaProject getCurrentJavaProject() {
        IEditorInput iEditorInput = this.getEditor().getEditorInput();
        if (!(iEditorInput instanceof IFileEditorInput)) {
            return null;
        }
        IProject iProject = ((IFileEditorInput)iEditorInput).getFile().getProject();
        IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
        return iJavaProject;
    }

    protected List getAllClassProposals(String string, int n, String string2) {
        ArrayList<IJavaCompletionProposal> arrayList = new ArrayList<IJavaCompletionProposal>();
        IJavaProject iJavaProject = this.getCurrentJavaProject();
        if (iJavaProject == null) {
            return arrayList;
        }
        CompletionProposalCollector completionProposalCollector = new CompletionProposalCollector(iJavaProject){

            public void accept(CompletionProposal completionProposal) {
                if (completionProposal.getKind() == 8 || completionProposal.getKind() == 9) {
                    super.accept(completionProposal);
                }
            }
        };
        completionProposalCollector.acceptContext(new CompletionContext());
        try {
            IEvaluationContext iEvaluationContext = iJavaProject.newEvaluationContext();
            iEvaluationContext.codeComplete(string, string.length(), (CompletionRequestor)completionProposalCollector);
            IJavaCompletionProposal[] iJavaCompletionProposalArray = completionProposalCollector.getJavaCompletionProposals();
            int n2 = 0;
            while (n2 < iJavaCompletionProposalArray.length) {
                if (iJavaCompletionProposalArray[n2] instanceof AbstractJavaCompletionProposal) {
                    String string3;
                    int n3;
                    AbstractJavaCompletionProposal abstractJavaCompletionProposal = (AbstractJavaCompletionProposal)iJavaCompletionProposalArray[n2];
                    int n4 = n - (string.length() - abstractJavaCompletionProposal.getReplacementOffset());
                    abstractJavaCompletionProposal.setReplacementOffset(n4);
                    if (abstractJavaCompletionProposal instanceof LazyJavaTypeCompletionProposal && (n3 = (string3 = string.substring(string.length() - abstractJavaCompletionProposal.getReplacementLength())).lastIndexOf(46)) != -1) {
                        abstractJavaCompletionProposal.setReplacementString(((LazyJavaTypeCompletionProposal)abstractJavaCompletionProposal).getQualifiedTypeName());
                    }
                    arrayList.add(iJavaCompletionProposalArray[n2]);
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
        }
        return arrayList;
    }

    protected List<RuleCompletionProposal> getPossibleProposals(ITextViewer iTextViewer, int n, String string, String string2) {
        ArrayList<RuleCompletionProposal> arrayList = new ArrayList<RuleCompletionProposal>();
        arrayList.add(new RuleCompletionProposal(n - string2.length(), string2.length(), "rule", NEW_RULE_TEMPLATE, 6));
        arrayList.add(new RuleCompletionProposal(n - string2.length(), string2.length(), "import", "import "));
        arrayList.add(new RuleCompletionProposal(n - string2.length(), string2.length(), "expander", "expander "));
        arrayList.add(new RuleCompletionProposal(n - string2.length(), string2.length(), "global", "global "));
        arrayList.add(new RuleCompletionProposal(n - string2.length(), string2.length(), "package", "package "));
        arrayList.add(new RuleCompletionProposal(n - string2.length(), string2.length(), "query", NEW_QUERY_TEMPLATE));
        arrayList.add(new RuleCompletionProposal(n - string2.length(), string2.length(), "function", NEW_FUNCTION_TEMPLATE, 14));
        arrayList.add(new RuleCompletionProposal(n - string2.length(), string2.length(), "template", NEW_TEMPLATE_TEMPLATE, 9));
        arrayList.add(new RuleCompletionProposal(n - string2.length(), string2.length(), "dialect \"java\"", "dialect \"java\" "));
        arrayList.add(new RuleCompletionProposal(n - string2.length(), string2.length(), "dialect \"mvel\"", "dialect \"mvel\" "));
        DefaultCompletionProcessor.filterProposalsOnPrefix(string2, arrayList);
        return arrayList;
    }

    protected List<RuleCompletionProposal> getJavaCompletionProposals(int n, String string, String string2, Map map) {
        return this.getJavaCompletionProposals(n, string, string2, map, true, false);
    }

    protected List<RuleCompletionProposal> getJavaCompletionProposals(int n, String string, String string2, Map map, boolean bl, boolean bl2) {
        ArrayList<RuleCompletionProposal> arrayList = new ArrayList<RuleCompletionProposal>();
        this.requestJavaCompletionProposals(string, string2, n, map, arrayList, bl, bl2);
        return arrayList;
    }

    protected static boolean doesNotContainFieldCompletion(String string, List list) {
        if (string == null || string.length() == 0 || list == null) {
            return false;
        }
        for (Object e : list) {
            IJavaElement iJavaElement;
            AbstractJavaCompletionProposal abstractJavaCompletionProposal;
            String string2;
            if (!(e instanceof AbstractJavaCompletionProposal) || !string.equals(string2 = (abstractJavaCompletionProposal = (AbstractJavaCompletionProposal)e).getReplacementString()) || !((iJavaElement = abstractJavaCompletionProposal.getJavaElement()) instanceof ILocalVariable) && !(iJavaElement instanceof IField)) continue;
            return false;
        }
        return true;
    }

    protected void requestJavaCompletionProposals(String string, String string2, int n, Map map, Collection collection) {
        this.requestJavaCompletionProposals(string, string2, n, map, collection, true, false);
    }

    protected void requestJavaCompletionProposals(String string, String string2, int n, Map map, Collection collection, boolean bl, boolean bl2) {
        IJavaProject iJavaProject;
        String string3 = CompletionUtil.getTextWithoutPrefix(string, string2);
        boolean bl3 = false;
        if ("".equals(string3.trim()) || CompletionUtil.START_OF_NEW_JAVA_STATEMENT.matcher(string3).matches()) {
            bl3 = true;
        }
        if ((iJavaProject = this.getCurrentJavaProject()) == null) {
            return;
        }
        CompletionProposalCollector completionProposalCollector = new CompletionProposalCollector(iJavaProject);
        completionProposalCollector.acceptContext(new CompletionContext());
        try {
            IEvaluationContext iEvaluationContext = iJavaProject.newEvaluationContext();
            List<String> list = this.getImports();
            if (list != null && list.size() > 0) {
                iEvaluationContext.setImports(list.toArray(new String[list.size()]));
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (Map.Entry object2 : map.entrySet()) {
                stringBuffer.append(object2.getValue() + " " + object2.getKey() + ";\n");
            }
            if (bl) {
                stringBuffer.append("org.drools.spi.KnowledgeHelper drools;");
                stringBuffer.append("org.drools.runtime.rule.RuleContext kcontext;");
            }
            if (bl2) {
                stringBuffer.append("org.drools.spi.ProcessContext context;");
                stringBuffer.append("org.drools.runtime.process.ProcessContext kcontext;");
            }
            stringBuffer.append(string);
            String string4 = stringBuffer.toString();
            String string5 = new KnowledgeHelperFixer().fix(string4);
            iEvaluationContext.codeComplete(string5, string5.length(), (CompletionRequestor)completionProposalCollector);
            IJavaCompletionProposal[] iJavaCompletionProposalArray = completionProposalCollector.getJavaCompletionProposals();
            int n2 = 0;
            while (n2 < iJavaCompletionProposalArray.length) {
                if (iJavaCompletionProposalArray[n2] instanceof AbstractJavaCompletionProposal) {
                    String string6;
                    int n3;
                    AbstractJavaCompletionProposal abstractJavaCompletionProposal = (AbstractJavaCompletionProposal)iJavaCompletionProposalArray[n2];
                    int n4 = n - (string5.length() - abstractJavaCompletionProposal.getReplacementOffset());
                    abstractJavaCompletionProposal.setReplacementOffset(n4);
                    if (abstractJavaCompletionProposal instanceof LazyJavaTypeCompletionProposal && (n3 = (string6 = string.substring(string.length() - abstractJavaCompletionProposal.getReplacementLength())).lastIndexOf(46)) != -1) {
                        abstractJavaCompletionProposal.setReplacementString(((LazyJavaTypeCompletionProposal)abstractJavaCompletionProposal).getQualifiedTypeName());
                    }
                    if (!bl3 || !(iJavaCompletionProposalArray[n2] instanceof JavaMethodCompletionProposal)) {
                        collection.add(iJavaCompletionProposalArray[n2]);
                    }
                }
                ++n2;
            }
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
        }
    }

    protected String getPackage() {
        if (this.getEditor() instanceof DRLRuleEditor) {
            return ((DRLRuleEditor)this.getEditor()).getPackage();
        }
        return "";
    }

    protected List<String> getImports() {
        if (this.getEditor() instanceof DRLRuleEditor) {
            return ((DRLRuleEditor)this.getEditor()).getImports();
        }
        return Collections.EMPTY_LIST;
    }

    protected Set getUniqueImports() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.getImports());
        return hashSet;
    }

    protected List getFunctions() {
        if (this.getEditor() instanceof DRLRuleEditor) {
            return ((DRLRuleEditor)this.getEditor()).getFunctions();
        }
        return Collections.EMPTY_LIST;
    }

    protected Map getAttributes() {
        if (this.getEditor() instanceof DRLRuleEditor) {
            return ((DRLRuleEditor)this.getEditor()).getAttributes();
        }
        return Collections.EMPTY_MAP;
    }

    protected Set getTemplates() {
        if (this.getEditor() instanceof DRLRuleEditor) {
            return ((DRLRuleEditor)this.getEditor()).getTemplates();
        }
        return Collections.EMPTY_SET;
    }

    protected FactTemplateDescr getTemplate(String string) {
        if (this.getEditor() instanceof DRLRuleEditor) {
            return ((DRLRuleEditor)this.getEditor()).getTemplate(string);
        }
        return null;
    }

    protected List<GlobalDescr> getGlobals() {
        if (this.getEditor() instanceof DRLRuleEditor) {
            return ((DRLRuleEditor)this.getEditor()).getGlobals();
        }
        return Collections.EMPTY_LIST;
    }

    protected List<String> getClassesInPackage() {
        if (this.getEditor() instanceof DRLRuleEditor) {
            return ((DRLRuleEditor)this.getEditor()).getClassesInPackage();
        }
        return Collections.EMPTY_LIST;
    }
}

