/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.eclipse.editors.completion.Node;
import org.drools.lang.dsl.DSLMapping;
import org.drools.lang.dsl.DSLMappingEntry;

public class DSLTree {
    public static final String separator = "=";
    public static final String tab = "  ";
    private Node current = null;
    private Node last = null;
    private Node rootCond = null;
    private Node rootConseq = null;
    private boolean empty = true;
    private ArrayList suggestions = new ArrayList();
    private HashMap objToNL = new HashMap();

    public DSLTree() {
        this.rootCond = new Node("root");
        this.rootConseq = new Node("root");
    }

    public void buildTree(String string) {
        this.buildTree(this.openDSLFile(string));
    }

    public void buildTree(Reader reader) {
        this.buildTree(this.createBufferedReader(reader));
    }

    private void buildTree(BufferedReader bufferedReader) {
        this.rootCond.clearChildren();
        this.rootConseq.clearChildren();
        this.parseFile(bufferedReader);
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.empty = false;
    }

    protected BufferedReader openDSLFile(String string) {
        try {
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            return bufferedReader;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    protected BufferedReader createBufferedReader(Reader reader) {
        return new BufferedReader(reader);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    protected void parseFile(BufferedReader bufferedReader) {
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                DSLMappingEntry.Section section = this.getSection(string);
                String string2 = this.stripHeadingAndCode(string);
                String string3 = this.getObjMetadata(string2);
                string2 = this.stripObjMetadata(string2);
                this.addEntry(section, string2, string3);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void buildTree(DSLMapping dSLMapping) {
        List list = dSLMapping.getEntries();
        for (DSLMappingEntry dSLMappingEntry : list) {
            DSLMappingEntry.Section section = dSLMappingEntry.getSection();
            String string = dSLMappingEntry.getMappingKey();
            String string2 = dSLMappingEntry.getMetaData().getMetaData();
            this.addEntry(section, string, string2);
        }
    }

    private void addEntry(DSLMappingEntry.Section section, String string, String string2) {
        if (!string.startsWith("-")) {
            if (string2 != null && !"".equals(string2)) {
                this.addObjToNLMap(string2, string);
            }
            String[] stringArray = string.split("\\s");
            if (section == DSLMappingEntry.CONDITION || section == DSLMappingEntry.ANY) {
                this.addTokens(stringArray, this.rootCond);
            }
            if (section == DSLMappingEntry.CONSEQUENCE || section == DSLMappingEntry.ANY) {
                this.addTokens(stringArray, this.rootConseq);
            }
        } else {
            String string3 = (String)this.objToNL.get(string2);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            this.addTokens(string3, stringTokenizer);
        }
    }

    public void addObjToNLMap(String string, String string2) {
        if (!string.startsWith("-")) {
            this.objToNL.put(string, string2);
        }
    }

    protected DSLMappingEntry.Section getSection(String string) {
        if (string.startsWith(DSLMappingEntry.CONDITION.getSymbol())) {
            return DSLMappingEntry.CONDITION;
        }
        if (string.startsWith(DSLMappingEntry.CONSEQUENCE.getSymbol())) {
            return DSLMappingEntry.CONSEQUENCE;
        }
        if (string.startsWith(DSLMappingEntry.ANY.getSymbol())) {
            return DSLMappingEntry.ANY;
        }
        if (string.startsWith(DSLMappingEntry.KEYWORD.getSymbol())) {
            return DSLMappingEntry.KEYWORD;
        }
        return null;
    }

    protected String stripHeadingAndCode(String string) {
        if (string.startsWith(DSLMappingEntry.CONDITION.getSymbol())) {
            return string.substring(DSLMappingEntry.CONDITION.getSymbol().length() + 2, string.indexOf(separator));
        }
        if (string.startsWith(DSLMappingEntry.CONSEQUENCE.getSymbol())) {
            return string.substring(DSLMappingEntry.CONSEQUENCE.getSymbol().length() + 2, string.indexOf(separator));
        }
        if (string.startsWith(DSLMappingEntry.ANY.getSymbol())) {
            return string.substring(DSLMappingEntry.ANY.getSymbol().length() + 2, string.indexOf(separator));
        }
        if (string.startsWith("#")) {
            return "";
        }
        return string;
    }

    protected String getObjMetadata(String string) {
        if (string.startsWith("[")) {
            return string.substring(1, string.lastIndexOf("]"));
        }
        return "";
    }

    protected String stripObjMetadata(String string) {
        if (string.startsWith("[")) {
            return string.substring(string.lastIndexOf("]") + 1);
        }
        return string;
    }

    public void addTokens(String string, StringTokenizer stringTokenizer) {
        Node node;
        Node node2 = node = this.rootCond.addToken(string);
        while (stringTokenizer.hasMoreTokens()) {
            Node node3;
            node2 = node3 = node2.addToken(stringTokenizer.nextToken());
        }
    }

    public void addTokens(String[] stringArray, Node node) {
        Node node2 = node;
        int n = 0;
        while (n < stringArray.length) {
            Node node3;
            node2 = node3 = node2.addToken(stringArray[n]);
            ++n;
        }
    }

    public Node[] getConditionChildren(String string) {
        Object object;
        Object object2;
        Node node = this.rootCond;
        if (string.length() > 0) {
            object2 = new StringTokenizer(string);
            this.last = this.current;
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                Node node2 = node.getChild((String)object);
                if (node2 == null) break;
                node = node2;
            }
            if (node != this.rootCond) {
                this.current = node;
            }
        }
        object2 = node.getChildren();
        object = new Node[object2.size()];
        return object2.toArray((T[])object);
    }

    public Node[] getConsequenceChildren(String string) {
        Object object;
        Object object2;
        Node node = this.rootConseq;
        if (string.length() >= 0) {
            object2 = new StringTokenizer(string);
            this.last = this.current;
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken();
                Node node2 = node.getChild((String)object);
                if (node2 == null) break;
                node = node2;
            }
            if (node != this.rootConseq) {
                this.current = node;
            }
        }
        object2 = node.getChildren();
        object = new Node[object2.size()];
        return object2.toArray((T[])object);
    }

    public Node[] getChildren(String string, String string2) {
        Object object;
        Object object2;
        Object object4 = this.rootCond.getChild(string);
        if (object4 == null) {
            for (Node object32 : this.rootCond.getChildren()) {
                int n;
                object2 = object32.getToken();
                if (object2 == null || (n = ((String)object2).indexOf("{")) == -1) continue;
                String string3 = ((String)object2).substring(0, n);
                if (string == null || !string.startsWith(string3)) continue;
                object4 = object32;
            }
        }
        if (object4 != null && string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            this.last = this.current;
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                object2 = ((Node)object4).getChild((String)object);
                if (object2 == null) break;
                object4 = object2;
            }
            if (object4 != this.rootCond) {
                this.current = object4;
            }
        }
        if (object4 == null) {
            return null;
        }
        Collection<Node> collection = ((Node)object4).getChildren();
        object = new Node[collection.size()];
        return collection.toArray((T[])object);
    }

    public ArrayList getConditionChildrenList(String string, boolean bl) {
        Node[] nodeArray = this.getConditionChildren(string);
        this.suggestions.clear();
        int n = 0;
        while (n < nodeArray.length) {
            this.suggestions.add(nodeArray[n].getToken());
            if (bl) {
                this.addChildToList(nodeArray[n], nodeArray[n].getToken(), this.suggestions);
            }
            ++n;
        }
        return this.suggestions;
    }

    public ArrayList getConsequenceChildrenList(String string, boolean bl) {
        Node[] nodeArray = this.getConsequenceChildren(string);
        this.suggestions.clear();
        int n = 0;
        while (n < nodeArray.length) {
            if (bl) {
                this.addChildToList(nodeArray[n], nodeArray[n].getToken(), this.suggestions);
            } else {
                this.suggestions.add(nodeArray[n].getToken());
            }
            ++n;
        }
        return this.suggestions;
    }

    public ArrayList getChildrenList(String string, String string2, boolean bl, boolean bl2) {
        Node[] nodeArray = this.getChildren(string, string2);
        this.suggestions.clear();
        if (nodeArray != null) {
            int n = 0;
            while (n < nodeArray.length) {
                if (bl) {
                    this.addChildToList(nodeArray[n], nodeArray[n].getToken(), this.suggestions);
                } else {
                    this.suggestions.add(nodeArray[n].getToken());
                }
                ++n;
            }
        }
        if (string2.trim().length() == 0 || this.suggestions.isEmpty()) {
            for (Node node : this.rootCond.getChildren()) {
                if (bl2 && node.getToken() == null || this.suggestions.contains(node.getToken())) continue;
                if (bl) {
                    this.addChildToList(node, node.getToken(), this.suggestions);
                    continue;
                }
                this.suggestions.add(node.getToken());
            }
        }
        return this.suggestions;
    }

    public void addChildToList(Node node, String string, ArrayList arrayList) {
        if (node.getChildren().size() > 0) {
            for (Node node2 : node.getChildren()) {
                if (string != null && "-".equals(node2.getToken())) {
                    if (!arrayList.contains(string)) {
                        arrayList.add(string);
                    }
                    return;
                }
                String string2 = String.valueOf(string == null ? "" : String.valueOf(string) + " ") + node2.getToken();
                this.addChildToList(node2, string2, arrayList);
            }
        } else if (!arrayList.contains(string)) {
            arrayList.add(string);
        }
    }

    public Node getCurrent() {
        return this.current;
    }

    public void setCurrent(Node node) {
        this.current = node;
    }

    public Node getLast() {
        return this.last;
    }

    public void setLast(Node node) {
        this.last = node;
    }

    public void printTree() {
        System.out.println("ROOT");
        for (Node node : this.rootCond.getChildren()) {
            this.printNode(node);
        }
    }

    protected void printNode(Node node) {
        this.printTabs(node.getDepth());
        System.out.println("- \"" + node.getToken() + "\"");
        for (Node node2 : node.getChildren()) {
            this.printNode(node2);
        }
    }

    protected void printTabs(int n) {
        int n2 = 0;
        while (n2 < n) {
            System.out.print(tab);
            ++n2;
        }
    }
}

