/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.dsl.editor;

import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;

public abstract class TransformedDocument
extends AbstractDocument {
    private IDocument parentDocument;
    private boolean changed = true;

    public TransformedDocument(IDocument iDocument) {
        this.parentDocument = iDocument;
        iDocument.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent documentEvent) {
            }

            public void documentChanged(DocumentEvent documentEvent) {
                TransformedDocument.this.changed = true;
            }
        });
        this.setTextStore(new StringTextStore());
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.completeInitialization();
    }

    protected ITextStore getStore() {
        if (this.changed) {
            this.update();
        }
        return super.getStore();
    }

    private void update() {
        String string = this.transformInput(this.parentDocument.get());
        super.getStore().set(string);
        this.getTracker().set(string);
        this.changed = false;
    }

    protected abstract String transformInput(String var1);

    private static class StringTextStore
    implements ITextStore {
        private String fContent;

        public char get(int n) {
            return this.fContent.charAt(n);
        }

        public String get(int n, int n2) {
            return this.fContent.substring(n, n + n2);
        }

        public int getLength() {
            return this.fContent.length();
        }

        public void replace(int n, int n2, String string) {
        }

        public void set(String string) {
            this.fContent = string;
        }
    }
}

