/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.dsl.editor;

import java.io.Reader;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.dsl.editor.DSLAdapter;
import org.drools.eclipse.dsl.editor.DSLRuleEditor;
import org.drools.eclipse.dsl.editor.DSLtoDRLRuleViewer;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.lang.dsl.DefaultExpander;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;

public class DSLRuleEditor2
extends FormEditor {
    private DSLRuleEditor dslRuleEditor;
    private DSLtoDRLRuleViewer drlRuleViewer;
    private int selection;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        this.setPartName(iEditorInput.getName());
    }

    protected void addPages() {
        try {
            this.dslRuleEditor = new DSLRuleEditor(){

                public void close(boolean bl) {
                    super.close(bl);
                    DSLRuleEditor2.this.close(bl);
                }

                protected void setPartName(String string) {
                    super.setPartName(string);
                    DSLRuleEditor2.this.setPartName(string);
                }
            };
            int n = this.addPage((IEditorPart)this.dslRuleEditor, this.getEditorInput());
            this.setPageText(n, "Text Editor");
            this.drlRuleViewer = new DSLtoDRLRuleViewer(this.dslRuleEditor);
            n = this.addPage((IEditorPart)this.drlRuleViewer, this.getEditorInput());
            this.setPageText(n, "DRL Viewer");
        }
        catch (PartInitException partInitException) {
            DroolsEclipsePlugin.log(partInitException);
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        this.dslRuleEditor.doSave(iProgressMonitor);
        this.setInput(this.getEditorInput());
    }

    public void doSaveAs() {
        this.dslRuleEditor.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return this.dslRuleEditor.isSaveAsAllowed();
    }

    public Object getAdapter(Class clazz) {
        return this.dslRuleEditor.getAdapter(clazz);
    }

    public void setFocus() {
        if (this.getActivePage() == 1) {
            try {
                DefaultExpander defaultExpander = new DefaultExpander();
                String string = this.dslRuleEditor.getContent();
                Reader reader = DSLAdapter.getDSLContent(string, this.dslRuleEditor.getResource());
                if (reader == null) {
                    throw new IllegalArgumentException("Could not find dsl definition.");
                }
                DSLTokenizedMappingFile dSLTokenizedMappingFile = new DSLTokenizedMappingFile();
                dSLTokenizedMappingFile.parseAndLoad(reader);
                reader.close();
                defaultExpander.addDSLMapping(dSLTokenizedMappingFile.getMapping());
                defaultExpander.expand(string);
                this.drlRuleViewer.setInput(this.getEditorInput());
                this.drlRuleViewer.setSelectedRange(this.selection);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.handleError(throwable);
                this.setActivePage(0);
            }
        } else if (this.getActivePage() == 0) {
            this.selection = this.drlRuleViewer.getSelectedRange();
        }
        super.setFocus();
    }

    private void handleError(Throwable throwable) {
        String string;
        DroolsEclipsePlugin.log(throwable);
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null) {
            throwable2 = throwable;
        }
        if ((string = String.valueOf(throwable2.getClass().getName()) + ": " + throwable2.getMessage()) == null || string.length() == 0) {
            string = "Uncategorized Error!";
        }
        Status status = new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), -1, string, null);
        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"DSL Rule Translation Error!", (String)"DSL Rule Translation Error!", (IStatus)status);
    }
}

