/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.dsl.editor;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.dsl.editor.DSLContentProvider;
import org.drools.eclipse.dsl.editor.DSLLabelProvider;
import org.drools.eclipse.dsl.editor.DSLMappingSorter;
import org.drools.eclipse.dsl.editor.MappingEditor;
import org.drools.eclipse.dsl.editor.NLGrammarModel;
import org.drools.lang.dsl.AntlrDSLMappingEntry;
import org.drools.lang.dsl.DSLMapping;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DSLMappingFile;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class DSLEditor
extends EditorPart {
    private Table table;
    private TableViewer tableViewer;
    private NLGrammarModel model;
    private boolean dirty = false;
    private Text exprText;
    private Text mappingText;
    private Text descriptionText;
    private Text objText;
    private Combo sortCombo;

    public void doSave(IProgressMonitor iProgressMonitor) {
        FileEditorInput fileEditorInput = (FileEditorInput)this.getEditorInput();
        File file = fileEditorInput.getFile().getLocation().toFile();
        this.saveFile(iProgressMonitor, file, fileEditorInput);
    }

    private void saveFile(IProgressMonitor iProgressMonitor, File file, FileEditorInput fileEditorInput) {
        try {
            this.validate(fileEditorInput);
            FileWriter fileWriter = new FileWriter(file);
            DSLMappingFile.saveMapping((Writer)fileWriter, (DSLMapping)this.model);
            this.makeClean();
            fileWriter.close();
            fileEditorInput.getFile().getProject().refreshLocal(2, iProgressMonitor);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unable to save DSL configuration file. (IOException: " + iOException.getMessage() + ")");
        }
        catch (CoreException coreException) {
            throw new IllegalStateException("Unable to resync workbench after DSL save. (CoreException: " + coreException.getMessage() + ")");
        }
    }

    private void validate(FileEditorInput fileEditorInput) {
        this.removeProblemsFor((IResource)fileEditorInput.getFile());
        ArrayList arrayList = new ArrayList();
        for (DSLMappingEntry dSLMappingEntry : this.model.getEntries()) {
            arrayList.addAll(dSLMappingEntry.getErrors());
        }
        if (arrayList.size() > 0) {
            for (DSLMappingEntry dSLMappingEntry : arrayList) {
                this.createMarker((IResource)fileEditorInput.getFile(), String.valueOf(dSLMappingEntry.getMessage()) + "  From [" + dSLMappingEntry.getTemplateText() + "]", -1);
            }
        }
    }

    private void createMarker(final IResource iResource, final String string, final int n) {
        try {
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    IMarker iMarker = iResource.createMarker("org.drools.eclipse.problem");
                    iMarker.setAttribute("message", (Object)string);
                    iMarker.setAttribute("severity", 1);
                    iMarker.setAttribute("lineNumber", n);
                }
            };
            iResource.getWorkspace().run(iWorkspaceRunnable, null, 1, null);
        }
        catch (CoreException coreException) {
            DroolsEclipsePlugin.log(coreException);
        }
    }

    private void removeProblemsFor(IResource iResource) {
        try {
            if (iResource != null && iResource.exists()) {
                iResource.deleteMarkers("org.drools.eclipse.problem", false, 2);
            }
        }
        catch (CoreException coreException) {
            DroolsEclipsePlugin.log(coreException);
        }
    }

    void makeClean() {
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.setVisibleName(iEditorInput);
        try {
            FileEditorInput fileEditorInput;
            InputStream inputStream = null;
            if (iEditorInput instanceof FileEditorInput) {
                fileEditorInput = (FileEditorInput)iEditorInput;
                inputStream = fileEditorInput.getFile().getContents();
            } else if (iEditorInput instanceof IStorageEditorInput) {
                fileEditorInput = (IStorageEditorInput)iEditorInput;
                inputStream = fileEditorInput.getStorage().getContents();
            }
            this.model = new NLGrammarModel();
            fileEditorInput = new DSLTokenizedMappingFile();
            fileEditorInput.parseAndLoad((Reader)new InputStreamReader(inputStream));
            this.model.addEntries(fileEditorInput.getMapping().getEntries());
            inputStream.close();
        }
        catch (CoreException coreException) {
            throw new IllegalStateException("Unable to load DSL configuration file. (CoreException: " + coreException.getMessage() + ")");
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Unabel to close stream fo DSL config file. (IOException: " + iOException.getMessage() + ")");
        }
    }

    private void setVisibleName(IEditorInput iEditorInput) {
        this.setPartName(iEditorInput.getName());
        this.setContentDescription("Editing Domain specific language: [" + iEditorInput.getName() + "]");
    }

    public boolean isDirty() {
        return this.dirty;
    }

    void makeDirty() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    public void sortModel() {
        if (this.sortCombo.getSelectionIndex() == 1) {
            this.tableViewer.setSorter((ViewerSorter)new DSLMappingSorter(1));
        } else if (this.sortCombo.getSelectionIndex() == 0) {
            this.tableViewer.setSorter((ViewerSorter)new DSLMappingSorter(0));
        } else if (this.sortCombo.getSelectionIndex() == 3) {
            this.tableViewer.setSorter((ViewerSorter)new DSLMappingSorter(3));
        } else if (this.sortCombo.getSelectionIndex() == 2) {
            this.tableViewer.setSorter((ViewerSorter)new DSLMappingSorter(2));
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite composite) {
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 4;
        composite.setLayout((Layout)gridLayout);
        this.createDescriptionField(composite);
        this.createTable(composite);
        this.createTableViewer();
        this.tableViewer.setContentProvider((IContentProvider)new DSLContentProvider(this.tableViewer, this.model));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new DSLLabelProvider());
        this.refreshModel();
        this.createExpressionViewField(composite);
        this.createEditButton(composite);
        this.createMappingViewField(composite);
        this.createDeleteButton(composite);
        this.createObjectViewField(composite);
        this.createAddButton(composite);
        this.createSortField(composite);
        this.createSortButton(composite);
        this.createCopyButton(composite);
        this.createTableListeners();
    }

    private void createTableListeners() {
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                this.populate();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.populate();
            }

            private void populate() {
                DSLMappingEntry dSLMappingEntry = DSLEditor.this.getCurrentSelected();
                DSLEditor.this.exprText.setText(dSLMappingEntry.getMappingKey());
                DSLEditor.this.mappingText.setText(dSLMappingEntry.getMappingValue());
                DSLEditor.this.objText.setText(dSLMappingEntry.getMetaData().getMetaData() == null ? "" : dSLMappingEntry.getMetaData().getMetaData());
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                DSLEditor.this.showEditPopup();
            }

            public void mouseDown(MouseEvent mouseEvent) {
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
    }

    private void createDescriptionField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Description:");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        label.setLayoutData((Object)gridData);
        this.descriptionText = new Text(composite, 2048);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        this.descriptionText.setText(this.model.getDescription() == null ? "" : this.model.getDescription());
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                String string = DSLEditor.this.descriptionText.getText();
                if (!string.equals(DSLEditor.this.model.getDescription())) {
                    DSLEditor.this.model.setDescription(string);
                    DSLEditor.this.makeDirty();
                }
            }
        });
    }

    private void createMappingViewField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Mapping:");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        label.setLayoutData((Object)gridData);
        this.mappingText = new Text(composite, 2048);
        this.mappingText.setEditable(false);
        this.mappingText.setLayoutData((Object)new GridData(768));
    }

    private void createExpressionViewField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Expression:");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        label.setLayoutData((Object)gridData);
        this.exprText = new Text(composite, 2048);
        this.exprText.setEditable(false);
        gridData = new GridData(768);
        this.exprText.setLayoutData((Object)gridData);
    }

    private void createObjectViewField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Object:");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        label.setLayoutData((Object)gridData);
        this.objText = new Text(composite, 2048);
        this.objText.setEditable(false);
        gridData = new GridData(768);
        this.objText.setLayoutData((Object)gridData);
    }

    private void createSortField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Sort by:");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        label.setLayoutData((Object)gridData);
        this.sortCombo = new Combo(composite, 8);
        this.sortCombo.add("Object", 0);
        this.sortCombo.add("Language Expression", 1);
        this.sortCombo.add("Rule Language Mapping", 2);
        this.sortCombo.add("Scope", 3);
        gridData = new GridData(768);
        this.sortCombo.setLayoutData((Object)gridData);
    }

    private void refreshModel() {
        this.tableViewer.setInput((Object)this.model);
    }

    private void createEditButton(Composite composite) {
        Button button = new Button(composite, 0x1000008);
        button.setText("Edit");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DSLEditor.this.showEditPopup();
            }
        });
    }

    private void showEditPopup() {
        DSLMappingEntry dSLMappingEntry = this.getCurrentSelected();
        if (dSLMappingEntry != null) {
            MappingEditor mappingEditor = new MappingEditor(this.getSite().getShell());
            mappingEditor.create();
            mappingEditor.getShell().setText("Edit language mapping");
            mappingEditor.setTitle("Edit an existing language mapping item.");
            mappingEditor.setTitleImage(this.getTitleImage());
            mappingEditor.setNLMappingItem(dSLMappingEntry);
            mappingEditor.open();
            if (!mappingEditor.isCancelled()) {
                this.refreshModel();
                this.makeDirty();
            }
        }
    }

    private void createDeleteButton(Composite composite) {
        Button button = new Button(composite, 0x1000008);
        button.setText("Remove");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DSLEditor.this.model.removeEntry(DSLEditor.this.getCurrentSelected());
                DSLEditor.this.refreshModel();
                DSLEditor.this.makeDirty();
                DSLEditor.this.exprText.setText("");
                DSLEditor.this.mappingText.setText("");
                DSLEditor.this.objText.setText("");
            }
        });
    }

    private void createSortButton(Composite composite) {
        Button button = new Button(composite, 0x1000008);
        button.setText("Sort");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DSLEditor.this.sortModel();
                DSLEditor.this.refreshModel();
                DSLEditor.this.makeDirty();
            }
        });
    }

    private DSLMappingEntry getCurrentSelected() {
        return (DSLMappingEntry)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
    }

    private void createAddButton(Composite composite) {
        Button button = new Button(composite, 0x1000008);
        button.setText("Add");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AntlrDSLMappingEntry antlrDSLMappingEntry = new AntlrDSLMappingEntry();
                MappingEditor mappingEditor = new MappingEditor(DSLEditor.this.getSite().getShell());
                mappingEditor.create();
                mappingEditor.getShell().setText("New language mapping");
                mappingEditor.setTitle("Create a new language element mapping.");
                mappingEditor.setTitleImage(DSLEditor.this.getTitleImage());
                mappingEditor.setNLMappingItem((DSLMappingEntry)antlrDSLMappingEntry);
                mappingEditor.open();
                if (!mappingEditor.isCancelled()) {
                    DSLEditor.this.model.addEntry((DSLMappingEntry)antlrDSLMappingEntry);
                    DSLEditor.this.refreshModel();
                    DSLEditor.this.makeDirty();
                }
            }
        });
    }

    private void createCopyButton(Composite composite) {
        Button button = new Button(composite, 0x1000008);
        button.setText("Copy");
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DSLMappingEntry dSLMappingEntry = DSLEditor.this.getCurrentSelected();
                if (dSLMappingEntry != null) {
                    AntlrDSLMappingEntry antlrDSLMappingEntry = new AntlrDSLMappingEntry(dSLMappingEntry.getSection(), dSLMappingEntry.getMetaData(), dSLMappingEntry.getMappingKey(), dSLMappingEntry.getMappingValue(), null, null);
                    MappingEditor mappingEditor = new MappingEditor(DSLEditor.this.getSite().getShell());
                    mappingEditor.create();
                    mappingEditor.getShell().setText("New language mapping");
                    mappingEditor.setTitle("Create a new language element mapping from a copy.");
                    mappingEditor.setTitleImage(DSLEditor.this.getTitleImage());
                    mappingEditor.setNLMappingItem((DSLMappingEntry)antlrDSLMappingEntry);
                    mappingEditor.open();
                    if (!mappingEditor.isCancelled()) {
                        DSLEditor.this.model.addEntry((DSLMappingEntry)antlrDSLMappingEntry);
                        DSLEditor.this.refreshModel();
                        DSLEditor.this.makeDirty();
                    }
                }
            }
        });
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
    }

    private void createTable(Composite composite) {
        int n = 101124;
        this.table = new Table(composite, n);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 16384, 0);
        tableColumn.setText("Language Expression");
        tableColumn.setWidth(350);
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DSLEditor.this.tableViewer.setSorter((ViewerSorter)new DSLMappingSorter(1));
            }
        });
        tableColumn = new TableColumn(this.table, 16384, 1);
        tableColumn.setText("Rule Language Mapping");
        tableColumn.setWidth(200);
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DSLEditor.this.tableViewer.setSorter((ViewerSorter)new DSLMappingSorter(2));
            }
        });
        tableColumn = new TableColumn(this.table, 16384, 2);
        tableColumn.setText("Object");
        tableColumn.setWidth(80);
        tableColumn = new TableColumn(this.table, 16384, 3);
        tableColumn.setText("Scope");
        tableColumn.setWidth(80);
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DSLEditor.this.tableViewer.setSorter((ViewerSorter)new DSLMappingSorter(3));
            }
        });
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }
}

