/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug.core;

import java.util.HashMap;
import java.util.Map;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaLineBreakpoint;

public class DroolsLineBreakpoint
extends JavaLineBreakpoint {
    private static final String DIALECT = "org.drools.eclipse.debug.core.breakpointDialect";

    public DroolsLineBreakpoint() {
    }

    public DroolsLineBreakpoint(IResource iResource, int n) throws CoreException {
        super(iResource, "", -1, -1, -1, 0, true, DroolsLineBreakpoint.createAttributesMap(n), "org.drools.eclipse.droolsBreakpointMarker");
        this.setJavaBreakpointProperties();
    }

    private static Map createAttributesMap(int n) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("Drools_DRL_LineNumber", new Integer(n));
        return hashMap;
    }

    public int getDRLLineNumber() {
        return this.getMarker().getAttribute("Drools_DRL_LineNumber", -1);
    }

    public String getModelIdentifier() {
        return "org.drools.eclipse.debug";
    }

    public String getDialectName() {
        return this.getMarker().getAttribute(DIALECT, "Unknown");
    }

    public Map getFileRuleMappings() {
        String string = this.getMarker().getAttribute("org.drools.eclipse.debug.DRL_RULES", "");
        return DroolsLineBreakpoint.unpackRuleMapping(string);
    }

    public void setJavaBreakpointProperties() throws CoreException {
        IMarker iMarker = this.getMarker();
        int n = this.getDRLLineNumber();
        if (iMarker.exists()) {
            try {
                DRLInfo dRLInfo = DroolsEclipsePlugin.getDefault().parseResource(iMarker.getResource(), true);
                DRLInfo.RuleInfo[] ruleInfoArray = dRLInfo.getRuleInfos();
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (n2 < ruleInfoArray.length) {
                    int n3 = ruleInfoArray[n2].getConsequenceDrlLineNumber();
                    String string = String.valueOf(ruleInfoArray[n2].getClassName()) + ":" + n3;
                    stringBuffer.append(string);
                    if (n2 < ruleInfoArray.length - 1) {
                        stringBuffer.append(";");
                    }
                    ++n2;
                }
                iMarker.setAttribute("org.drools.eclipse.debug.DRL_RULES", (Object)stringBuffer.toString());
                iMarker.setAttribute("org.eclipse.jdt.debug.core.typeName", (Object)this.getRuleClassName(dRLInfo, iMarker.getResource().toString(), n));
                n2 = this.getRuleLineNumber(dRLInfo, iMarker.getResource().toString(), n);
                iMarker.setAttribute("lineNumber", n2);
                iMarker.setAttribute(DIALECT, (Object)this.getDialect(dRLInfo, n));
            }
            catch (Throwable throwable) {
                throw new CoreException((IStatus)new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), 0, "Cannot determine ruleInfo " + iMarker.getResource() + " " + n, throwable));
            }
        }
    }

    private String getDialect(DRLInfo dRLInfo, int n) {
        if (dRLInfo != null) {
            return dRLInfo.getRuleInfo(n).getDialectName();
        }
        return null;
    }

    private String getRuleClassName(DRLInfo dRLInfo, String string, int n) throws CoreException {
        if (dRLInfo != null) {
            DRLInfo.RuleInfo ruleInfo = dRLInfo.getRuleInfo(n);
            if (ruleInfo != null) {
                return ruleInfo.getClassName();
            }
            DRLInfo.FunctionInfo functionInfo = dRLInfo.getFunctionInfo(n);
            if (functionInfo != null) {
                return functionInfo.getClassName();
            }
        }
        throw new CoreException((IStatus)new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), 0, "Cannot determine ruleClassName for " + string + " " + n, null));
    }

    private int getRuleLineNumber(DRLInfo dRLInfo, String string, int n) throws CoreException {
        if (dRLInfo != null) {
            DRLInfo.RuleInfo ruleInfo = dRLInfo.getRuleInfo(n);
            if (ruleInfo != null && ruleInfo.getConsequenceDrlLineNumber() < n) {
                int n2 = ruleInfo.getConsequenceJavaLineNumber() + (n - ruleInfo.getConsequenceDrlLineNumber());
                if (ruleInfo.getDialectName() != null && ruleInfo.getDialectName().equals("mvel")) {
                    return n2;
                }
                return n2 + 1;
            }
            DRLInfo.FunctionInfo functionInfo = dRLInfo.getFunctionInfo(n);
            if (functionInfo != null) {
                return functionInfo.getJavaLineNumber() + (n - functionInfo.getDrlLineNumber());
            }
        }
        throw new CoreException((IStatus)new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), 0, "Cannot determine ruleLineNumber for " + string + " " + n, null));
    }

    public String getRuleName() {
        IMarker iMarker = this.getMarker();
        if (iMarker.exists()) {
            try {
                return (String)iMarker.getAttribute("org.eclipse.jdt.debug.core.typeName");
            }
            catch (CoreException coreException) {
                DroolsEclipsePlugin.log(coreException);
            }
        }
        return null;
    }

    private static final Map unpackRuleMapping(String string) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        String[] stringArray = string.split("\\;");
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length() > 0) {
                String[] stringArray2 = stringArray[n].split("\\:");
                hashMap.put(stringArray2[0], Integer.valueOf(stringArray2[1]));
            }
            ++n;
        }
        return hashMap;
    }
}

