/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug.core;

import com.sun.jdi.ClassType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.core.DroolsLineBreakpoint;
import org.drools.eclipse.debug.core.DroolsThread;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jdi.TimeoutException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.IJDIEventListener;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;

public class DroolsDebugTarget
extends JDIDebugTarget {
    private ArrayList fThreads;
    private ThreadStartHandler fThreadStartHandler = null;
    private boolean fSuspended = true;

    public DroolsDebugTarget(ILaunch iLaunch, VirtualMachine virtualMachine, String string, boolean bl, boolean bl2, IProcess iProcess, boolean bl3) {
        super(iLaunch, virtualMachine, string, bl, bl2, iProcess, bl3);
    }

    public void breakpointAdded(IBreakpoint iBreakpoint) {
        try {
            if (iBreakpoint instanceof DroolsLineBreakpoint) {
                ((DroolsLineBreakpoint)iBreakpoint).setJavaBreakpointProperties();
                final DroolsLineBreakpoint droolsLineBreakpoint = (DroolsLineBreakpoint)iBreakpoint;
                if (droolsLineBreakpoint.getDialectName().equals("mvel")) {
                    Iterator<ReferenceType> iterator = this.getVM().classesByName("org.drools.base.mvel.MVELDebugHandler").iterator();
                    if (!iterator.hasNext()) {
                        ClassPrepareRequest classPrepareRequest = this.getEventRequestManager().createClassPrepareRequest();
                        classPrepareRequest.addClassFilter("org.drools.base.mvel.MVELDebugHandler");
                        classPrepareRequest.setSuspendPolicy(2);
                        this.addJDIEventListener(new IJDIEventListener(){

                            public boolean handleEvent(Event event, JDIDebugTarget jDIDebugTarget) {
                                DroolsDebugTarget.this.addRemoteBreakpoint(droolsLineBreakpoint);
                                return true;
                            }

                            public void wonSuspendVote(Event event, JDIDebugTarget jDIDebugTarget) {
                            }

                            public void eventSetComplete(Event event, JDIDebugTarget jDIDebugTarget, boolean bl, EventSet eventSet) {
                                this.wonSuspendVote(event, jDIDebugTarget);
                            }

                            public boolean handleEvent(Event event, JDIDebugTarget jDIDebugTarget, boolean bl, EventSet eventSet) {
                                return this.handleEvent(event, jDIDebugTarget);
                            }
                        }, classPrepareRequest);
                        classPrepareRequest.enable();
                        return;
                    }
                    this.addRemoteBreakpoint(droolsLineBreakpoint);
                } else {
                    super.breakpointAdded(iBreakpoint);
                }
            } else {
                super.breakpointAdded(iBreakpoint);
            }
        }
        catch (Throwable throwable) {
            DroolsEclipsePlugin.log(throwable);
        }
    }

    protected synchronized void initialize() {
        this.setThreadList(new ArrayList(5));
        super.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JDIThread createThread(ThreadReference threadReference) {
        DroolsThread droolsThread = null;
        try {
            droolsThread = new DroolsThread(this, threadReference);
        }
        catch (ObjectCollectedException objectCollectedException) {
            return null;
        }
        if (this.isDisconnected()) {
            return null;
        }
        ArrayList arrayList = this.fThreads;
        synchronized (arrayList) {
            this.fThreads.add(droolsThread);
        }
        droolsThread.fireCreationEvent();
        return droolsThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator getThreadIterator() {
        List list;
        ArrayList arrayList = this.fThreads;
        synchronized (arrayList) {
            list = (List)this.fThreads.clone();
        }
        return list.iterator();
    }

    private boolean hasSuspendedThreads() {
        Iterator iterator = this.getThreadIterator();
        while (iterator.hasNext()) {
            IThread iThread = (IThread)iterator.next();
            if (!iThread.isSuspended()) continue;
            return true;
        }
        return false;
    }

    public boolean canResume() {
        return (this.isSuspended() || this.hasSuspendedThreads()) && this.isAvailable() && !this.isPerformingHotCodeReplace();
    }

    protected void resume(boolean bl) throws DebugException {
        if (!this.isSuspended() && !this.hasSuspendedThreads() || !this.isAvailable()) {
            return;
        }
        try {
            this.setSuspended(false);
            this.resumeThreads();
            VirtualMachine virtualMachine = this.getVM();
            if (virtualMachine != null) {
                virtualMachine.resume();
            }
            if (bl) {
                this.fireResumeEvent(32);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.disconnected();
            return;
        }
        catch (RuntimeException runtimeException) {
            this.setSuspended(true);
            this.fireSuspendEvent(32);
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIDebugTarget_exception_resume, runtimeException.toString()), runtimeException);
        }
    }

    private void setSuspended(boolean bl) {
        this.fSuspended = bl;
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    private void setThreadList(ArrayList arrayList) {
        this.fThreads = arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IThread[] getThreads() {
        ArrayList arrayList = this.fThreads;
        synchronized (arrayList) {
            return this.fThreads.toArray(new IThread[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllThreads() {
        Object object;
        Iterator iterator = this.getThreadIterator();
        while (iterator.hasNext()) {
            object = (DroolsThread)((Object)iterator.next());
            ((DroolsThread)((Object)object)).terminated();
        }
        object = this.fThreads;
        synchronized (object) {
            this.fThreads.clear();
        }
    }

    protected void initializeRequests() {
        this.setThreadStartHandler(new ThreadStartHandler());
        new ThreadDeathHandler();
        new MVELTraceHandler();
    }

    private void disposeThreadHandler() {
        ThreadStartHandler threadStartHandler = this.getThreadStartHandler2();
        if (threadStartHandler != null) {
            threadStartHandler.deleteRequest();
        }
    }

    public boolean hasThreads() {
        return this.fThreads.size() > 0;
    }

    protected ThreadStartHandler getThreadStartHandler2() {
        return this.fThreadStartHandler;
    }

    protected void setThreadStartHandler(ThreadStartHandler threadStartHandler) {
        this.fThreadStartHandler = threadStartHandler;
    }

    public boolean isOutOfSynch() throws DebugException {
        Iterator iterator = this.getThreadIterator();
        while (iterator.hasNext()) {
            JDIThread jDIThread = (JDIThread)iterator.next();
            if (!jDIThread.isOutOfSynch()) continue;
            return true;
        }
        return false;
    }

    public boolean mayBeOutOfSynch() {
        Iterator iterator = this.getThreadIterator();
        while (iterator.hasNext()) {
            JDIThread jDIThread = (JDIThread)iterator.next();
            if (!jDIThread.mayBeOutOfSynch()) continue;
            return true;
        }
        return false;
    }

    public JDIThread findThread(ThreadReference threadReference) {
        Iterator iterator = this.getThreadIterator();
        while (iterator.hasNext()) {
            JDIThread jDIThread = (JDIThread)iterator.next();
            if (!jDIThread.getUnderlyingThread().equals(threadReference)) continue;
            return jDIThread;
        }
        return null;
    }

    public void breakpointRemoved(IBreakpoint iBreakpoint, IMarkerDelta iMarkerDelta) {
        if (!this.isAvailable()) {
            return;
        }
        if (this.supportsBreakpoint(iBreakpoint)) {
            try {
                Object object;
                if (iBreakpoint instanceof DroolsLineBreakpoint) {
                    ((DroolsLineBreakpoint)iBreakpoint).setJavaBreakpointProperties();
                    object = (DroolsLineBreakpoint)iBreakpoint;
                    if (((DroolsLineBreakpoint)((Object)object)).getDialectName().equals("mvel")) {
                        this.removeRemoteBreakpoint((DroolsLineBreakpoint)iBreakpoint, iMarkerDelta);
                    }
                }
                ((JavaBreakpoint)iBreakpoint).removeFromTarget((JDIDebugTarget)this);
                this.getBreakpoints().remove(iBreakpoint);
                object = this.getThreadIterator();
                while (object.hasNext()) {
                    ((DroolsThread)((Object)object.next())).removeCurrentBreakpoint(iBreakpoint);
                }
            }
            catch (CoreException coreException) {
                this.logError((Exception)((Object)coreException));
            }
        }
    }

    protected void suspendThreads() {
        Iterator iterator = this.getThreadIterator();
        while (iterator.hasNext()) {
            ((DroolsThread)((Object)iterator.next())).suspendedByVM();
        }
    }

    protected void resumeThreads() throws DebugException {
        Iterator iterator = this.getThreadIterator();
        while (iterator.hasNext()) {
            ((DroolsThread)((Object)iterator.next())).resumedByVM();
        }
    }

    public void disconnect() throws DebugException {
        if (!this.isAvailable()) {
            return;
        }
        if (!this.canDisconnect()) {
            this.notSupported(JDIDebugModelMessages.JDIDebugTarget_does_not_support_disconnect);
        }
        try {
            this.disposeThreadHandler();
            VirtualMachine virtualMachine = this.getVM();
            if (virtualMachine != null) {
                virtualMachine.dispose();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.disconnected();
        }
        catch (RuntimeException runtimeException) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIDebugTarget_exception_disconnecting, runtimeException.toString()), runtimeException);
        }
    }

    public void terminate() throws DebugException {
        if (!this.isAvailable()) {
            return;
        }
        if (!this.supportsTerminate()) {
            this.notSupported(JDIDebugModelMessages.JDIDebugTarget_does_not_support_termination);
        }
        try {
            IProcess iProcess;
            this.setTerminating(true);
            this.disposeThreadHandler();
            VirtualMachine virtualMachine = this.getVM();
            if (virtualMachine != null) {
                virtualMachine.exit(1);
            }
            if ((iProcess = this.getProcess()) != null) {
                iProcess.terminate();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            this.terminated();
        }
        catch (TimeoutException timeoutException) {
            IProcess iProcess = this.getProcess();
            if (iProcess != null && iProcess.isTerminated()) {
                this.terminated();
            } else {
                this.disconnected();
            }
        }
        catch (RuntimeException runtimeException) {
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIDebugTarget_exception_terminating, runtimeException.toString()), runtimeException);
        }
    }

    public void handleVMStart(VMStartEvent vMStartEvent) {
        if (this.isResumeOnStartup()) {
            try {
                this.setSuspended(true);
                this.resume();
            }
            catch (DebugException debugException) {
                this.logError((Exception)((Object)debugException));
            }
        }
        IThread[] iThreadArray = this.getThreads();
        int n = 0;
        while (n < iThreadArray.length) {
            DroolsThread droolsThread = (DroolsThread)iThreadArray[n];
            if (droolsThread.isSuspended()) {
                try {
                    boolean bl = droolsThread.getUnderlyingThread().isSuspended();
                    if (!bl) {
                        droolsThread.setRunning(true);
                        droolsThread.fireResumeEvent(32);
                    }
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                }
                catch (ObjectCollectedException objectCollectedException) {
                }
                catch (RuntimeException runtimeException) {
                    this.logError(runtimeException);
                }
            }
            ++n;
        }
    }

    protected void initializeState() {
        List<ThreadReference> list = null;
        VirtualMachine virtualMachine = this.getVM();
        if (virtualMachine != null) {
            try {
                list = virtualMachine.allThreads();
            }
            catch (RuntimeException runtimeException) {
                this.internalError(runtimeException);
            }
            if (list != null) {
                Iterator<ThreadReference> iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.createThread(iterator.next());
                }
            }
        }
        if (this.isResumeOnStartup()) {
            this.setSuspended(false);
        }
    }

    public void suspend() throws DebugException {
        if (this.isSuspended()) {
            return;
        }
        try {
            VirtualMachine virtualMachine = this.getVM();
            if (virtualMachine != null) {
                virtualMachine.suspend();
            }
            this.suspendThreads();
            this.setSuspended(true);
            this.fireSuspendEvent(32);
        }
        catch (RuntimeException runtimeException) {
            this.setSuspended(false);
            this.fireResumeEvent(32);
            this.targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIDebugTarget_exception_suspend, runtimeException.toString()), runtimeException);
        }
    }

    public void prepareToSuspendByBreakpoint(JavaBreakpoint javaBreakpoint) {
        this.setSuspended(true);
        this.suspendThreads();
    }

    protected void cancelSuspendByBreakpoint(JavaBreakpoint javaBreakpoint) throws DebugException {
        this.setSuspended(false);
        this.resumeThreads();
    }

    public DroolsLineBreakpoint getDroolsBreakpoint(String string) {
        if (string == null) {
            return null;
        }
        for (IJavaBreakpoint iJavaBreakpoint : this.getBreakpoints()) {
            if (!(iJavaBreakpoint instanceof DroolsLineBreakpoint) || !((DroolsLineBreakpoint)iJavaBreakpoint).getDialectName().equals("mvel")) continue;
            DroolsLineBreakpoint droolsLineBreakpoint = (DroolsLineBreakpoint)iJavaBreakpoint;
            try {
                droolsLineBreakpoint.getLineNumber();
                String string2 = droolsLineBreakpoint.getRuleName();
                if (!string.equals(string2) && !droolsLineBreakpoint.getFileRuleMappings().containsKey(string)) continue;
                return droolsLineBreakpoint;
            }
            catch (CoreException coreException) {
                this.logError((Exception)((Object)coreException));
            }
        }
        return null;
    }

    private void addRemoteBreakpoint(DroolsLineBreakpoint droolsLineBreakpoint) {
        String string;
        int n;
        try {
            if (!droolsLineBreakpoint.isEnabled()) {
                return;
            }
        }
        catch (CoreException coreException) {
            this.logError((Exception)((Object)coreException));
            return;
        }
        Iterator<ReferenceType> iterator = this.getVM().classesByName("org.drools.base.mvel.MVELDebugHandler").iterator();
        ReferenceType referenceType = iterator.next();
        try {
            n = droolsLineBreakpoint.getLineNumber();
            string = droolsLineBreakpoint.getTypeName();
        }
        catch (CoreException coreException) {
            this.logError((Exception)((Object)coreException));
            return;
        }
        ReferenceType referenceType2 = referenceType;
        Method method = referenceType2.methodsByName("registerBreakpoint").iterator().next();
        ArrayList<Value> arrayList = new ArrayList<Value>();
        IntegerValue integerValue = this.getVM().mirrorOf(n);
        StringReference stringReference = this.getVM().mirrorOf(string);
        JDIObjectValue jDIObjectValue = (JDIObjectValue)this.newValue(string);
        jDIObjectValue.getUnderlyingObject();
        arrayList.add(stringReference);
        arrayList.add(integerValue);
        try {
            ClassType classType = (ClassType)referenceType;
            IThread[] iThreadArray = this.getThreads();
            ThreadReference threadReference = null;
            int n2 = 0;
            while (n2 < iThreadArray.length) {
                IThread iThread = iThreadArray[n2];
                ThreadReference threadReference2 = ((DroolsThread)iThreadArray[n2]).getUnderlyingThread();
                if (threadReference2.suspendCount() == 1 && iThread.getName().equals("main")) {
                    threadReference = threadReference2;
                    DroolsThread cfr_ignored_0 = (DroolsThread)iThread;
                }
                ++n2;
            }
            classType.invokeMethod(threadReference, method, arrayList, 1);
            super.breakpointAdded((IBreakpoint)droolsLineBreakpoint);
        }
        catch (Exception exception) {
            this.logError(exception);
        }
    }

    private void removeRemoteBreakpoint(DroolsLineBreakpoint droolsLineBreakpoint, IMarkerDelta iMarkerDelta) {
        String string;
        int n;
        Iterator<ReferenceType> iterator = this.getVM().classesByName("org.drools.base.mvel.MVELDebugHandler").iterator();
        ReferenceType referenceType = iterator.next();
        try {
            n = droolsLineBreakpoint.getLineNumber();
            string = droolsLineBreakpoint.getTypeName();
        }
        catch (CoreException coreException) {
            this.logError((Exception)((Object)coreException));
            return;
        }
        ReferenceType referenceType2 = referenceType;
        Method method = referenceType2.methodsByName("removeBreakpoint").iterator().next();
        ArrayList<Value> arrayList = new ArrayList<Value>();
        IntegerValue integerValue = this.getVM().mirrorOf(n);
        StringReference stringReference = this.getVM().mirrorOf(string);
        JDIObjectValue jDIObjectValue = (JDIObjectValue)this.newValue(string);
        jDIObjectValue.getUnderlyingObject();
        arrayList.add(stringReference);
        arrayList.add(integerValue);
        try {
            ClassType classType = (ClassType)referenceType;
            IThread[] iThreadArray = this.getThreads();
            ThreadReference threadReference = null;
            int n2 = 0;
            while (n2 < iThreadArray.length) {
                IThread iThread = iThreadArray[n2];
                ThreadReference threadReference2 = ((DroolsThread)iThreadArray[n2]).getUnderlyingThread();
                if (threadReference2.suspendCount() == 1 && iThread.getName().equals("main")) {
                    threadReference = threadReference2;
                    DroolsThread cfr_ignored_0 = (DroolsThread)iThread;
                }
                ++n2;
            }
            classType.invokeMethod(threadReference, method, arrayList, 1);
        }
        catch (Exception exception) {
            this.logError(exception);
        }
    }

    class MVELTraceHandler
    implements IJDIEventListener {
        protected MVELTraceHandler() {
            this.createRequest();
        }

        protected void createRequest() {
            EventRequestManager eventRequestManager = DroolsDebugTarget.this.getEventRequestManager();
            if (eventRequestManager != null) {
                try {
                    ClassPrepareRequest classPrepareRequest = eventRequestManager.createClassPrepareRequest();
                    classPrepareRequest.addClassFilter("org.drools.base.mvel.MVELDebugHandler");
                    classPrepareRequest.setSuspendPolicy(2);
                    DroolsDebugTarget.this.addJDIEventListener(this, classPrepareRequest);
                    classPrepareRequest.enable();
                }
                catch (RuntimeException runtimeException) {
                    DroolsDebugTarget.this.logError(runtimeException);
                }
            }
        }

        public boolean handleEvent(Event event, JDIDebugTarget jDIDebugTarget) {
            Location location;
            ClassType classType = (ClassType)((ClassPrepareEvent)event).referenceType();
            classType.name();
            BreakpointRequest breakpointRequest = null;
            List<Method> list = classType.methodsByName("onBreak");
            if (list.size() == 0) {
                throw new IllegalStateException("MVELDebugHandler.onBreak cannot be found by JDI");
            }
            Method method = list.get(0);
            if (method != null && !method.isNative()) {
                location = method.location();
                if (location == null || location.codeIndex() == -1L) {
                    throw new IllegalStateException("MVELDebugHandler.onBreak location cannot be found by JDI");
                }
            } else {
                throw new IllegalStateException("MVELDebugHandler.onBreak cannot be found by JDI");
            }
            breakpointRequest = DroolsDebugTarget.this.getEventRequestManager().createBreakpointRequest(location);
            breakpointRequest.addThreadFilter(((ClassPrepareEvent)event).thread());
            breakpointRequest.setSuspendPolicy(2);
            DroolsDebugTarget.this.addJDIEventListener(new IJDIEventListener(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public boolean handleEvent(Event event, JDIDebugTarget jDIDebugTarget) {
                    BreakpointEvent cfr_ignored_0 = (BreakpointEvent)event;
                    try {
                        IThread[] iThreadArray = DroolsDebugTarget.this.getThreads();
                        int n = 0;
                        while (true) {
                            if (n >= iThreadArray.length) {
                                return true;
                            }
                            DroolsThread droolsThread = (DroolsThread)iThreadArray[n];
                            ThreadReference threadReference = ((DroolsThread)iThreadArray[n]).getUnderlyingThread();
                            if (threadReference.suspendCount() == 1 && droolsThread.getName().equals("main")) {
                                threadReference.suspend();
                                droolsThread.setRunning(false);
                                droolsThread.fireSuspendEvent(32);
                                return true;
                            }
                            ++n;
                        }
                    }
                    catch (Exception exception) {
                        DroolsDebugTarget.this.logError(exception);
                    }
                    return true;
                }

                public void wonSuspendVote(Event event, JDIDebugTarget jDIDebugTarget) {
                }

                public void eventSetComplete(Event event, JDIDebugTarget jDIDebugTarget, boolean bl, EventSet eventSet) {
                    this.wonSuspendVote(event, jDIDebugTarget);
                }

                public boolean handleEvent(Event event, JDIDebugTarget jDIDebugTarget, boolean bl, EventSet eventSet) {
                    return this.handleEvent(event, jDIDebugTarget);
                }
            }, breakpointRequest);
            breakpointRequest.enable();
            DroolsDebugTarget.this.removeJDIEventListener(this, ((ClassPrepareEvent)event).request());
            return true;
        }

        public void wonSuspendVote(Event event, JDIDebugTarget jDIDebugTarget) {
        }

        public void eventSetComplete(Event event, JDIDebugTarget jDIDebugTarget, boolean bl, EventSet eventSet) {
            this.wonSuspendVote(event, jDIDebugTarget);
        }

        public boolean handleEvent(Event event, JDIDebugTarget jDIDebugTarget, boolean bl, EventSet eventSet) {
            return this.handleEvent(event, jDIDebugTarget);
        }
    }

    class ThreadDeathHandler
    implements IJDIEventListener {
        protected ThreadDeathHandler() {
            this.createRequest();
        }

        protected void createRequest() {
            EventRequestManager eventRequestManager = DroolsDebugTarget.this.getEventRequestManager();
            if (eventRequestManager != null) {
                try {
                    ThreadDeathRequest threadDeathRequest = eventRequestManager.createThreadDeathRequest();
                    threadDeathRequest.setSuspendPolicy(0);
                    threadDeathRequest.enable();
                    DroolsDebugTarget.this.addJDIEventListener(this, threadDeathRequest);
                }
                catch (RuntimeException runtimeException) {
                    DroolsDebugTarget.this.logError(runtimeException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleEvent(Event event, JDIDebugTarget jDIDebugTarget) {
            ThreadReference threadReference = ((ThreadDeathEvent)event).thread();
            DroolsThread droolsThread = (DroolsThread)DroolsDebugTarget.this.findThread(threadReference);
            if (droolsThread != null) {
                ArrayList arrayList = DroolsDebugTarget.this.fThreads;
                synchronized (arrayList) {
                    DroolsDebugTarget.this.fThreads.remove((Object)droolsThread);
                }
                droolsThread.terminated();
            }
            return true;
        }

        public void wonSuspendVote(Event event, JDIDebugTarget jDIDebugTarget) {
        }

        public void eventSetComplete(Event event, JDIDebugTarget jDIDebugTarget, boolean bl, EventSet eventSet) {
            this.wonSuspendVote(event, jDIDebugTarget);
        }

        public boolean handleEvent(Event event, JDIDebugTarget jDIDebugTarget, boolean bl, EventSet eventSet) {
            return this.handleEvent(event, jDIDebugTarget);
        }
    }

    class ThreadStartHandler
    implements IJDIEventListener {
        protected EventRequest fRequest;

        protected ThreadStartHandler() {
            this.createRequest();
        }

        protected void createRequest() {
            EventRequestManager eventRequestManager = DroolsDebugTarget.this.getEventRequestManager();
            if (eventRequestManager != null) {
                try {
                    ThreadStartRequest threadStartRequest = eventRequestManager.createThreadStartRequest();
                    threadStartRequest.setSuspendPolicy(0);
                    threadStartRequest.enable();
                    DroolsDebugTarget.this.addJDIEventListener(this, threadStartRequest);
                    this.setRequest(threadStartRequest);
                }
                catch (RuntimeException runtimeException) {
                    DroolsDebugTarget.this.logError(runtimeException);
                }
            }
        }

        public boolean handleEvent(Event event, JDIDebugTarget jDIDebugTarget) {
            DroolsThread droolsThread;
            ThreadReference threadReference = ((ThreadStartEvent)event).thread();
            try {
                if (threadReference.isCollected()) {
                    return false;
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                return false;
            }
            catch (ObjectCollectedException objectCollectedException) {
                return false;
            }
            catch (TimeoutException timeoutException) {}
            if ((droolsThread = (DroolsThread)DroolsDebugTarget.this.findThread(threadReference)) == null) {
                droolsThread = (DroolsThread)DroolsDebugTarget.this.createThread(threadReference);
                if (droolsThread == null) {
                    return false;
                }
            } else {
                droolsThread.disposeStackFrames();
                droolsThread.fireChangeEvent(512);
            }
            return !droolsThread.isSuspended();
        }

        public void wonSuspendVote(Event event, JDIDebugTarget jDIDebugTarget) {
        }

        protected void deleteRequest() {
            if (this.getRequest() != null) {
                DroolsDebugTarget.this.removeJDIEventListener(this, this.getRequest());
                this.setRequest(null);
            }
        }

        protected EventRequest getRequest() {
            return this.fRequest;
        }

        protected void setRequest(EventRequest eventRequest) {
            this.fRequest = eventRequest;
        }

        public void eventSetComplete(Event event, JDIDebugTarget jDIDebugTarget, boolean bl, EventSet eventSet) {
            this.wonSuspendVote(event, jDIDebugTarget);
        }

        public boolean handleEvent(Event event, JDIDebugTarget jDIDebugTarget, boolean bl, EventSet eventSet) {
            return this.handleEvent(event, jDIDebugTarget);
        }
    }
}

