/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import java.util.ArrayList;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.DebugUtil;
import org.drools.eclipse.debug.DroolsDebugEventHandlerView;
import org.drools.eclipse.debug.DroolsDebugViewContentProvider;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaModifiers;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;

public class WorkingMemoryViewContentProvider
extends DroolsDebugViewContentProvider {
    private DroolsDebugEventHandlerView view;

    public WorkingMemoryViewContentProvider(DroolsDebugEventHandlerView droolsDebugEventHandlerView) {
        this.view = droolsDebugEventHandlerView;
    }

    protected String getEmptyString() {
        return "The selected working memory is empty.";
    }

    public Object[] getChildren(Object object) {
        try {
            Object[] objectArray = null;
            if (object != null && object instanceof IJavaObject && "org.drools.reteoo.ReteooStatefulSession".equals(((IJavaObject)object).getReferenceTypeName())) {
                objectArray = this.getWorkingMemoryElements((IJavaObject)object);
            } else if (object instanceof IVariable) {
                if (this.view.isShowLogicalStructure()) {
                    IValue iValue = this.getLogicalValue(((IVariable)object).getValue(), new ArrayList());
                    objectArray = iValue.getVariables();
                }
                if (objectArray == null) {
                    objectArray = ((IVariable)object).getValue().getVariables();
                }
            }
            if (objectArray == null) {
                return new Object[0];
            }
            this.cache(object, objectArray);
            return objectArray;
        }
        catch (DebugException debugException) {
            DroolsEclipsePlugin.log(debugException);
            return new Object[0];
        }
    }

    private IVariable[] getWorkingMemoryElements(IJavaObject iJavaObject) throws DebugException {
        IValue iValue = DebugUtil.getValueByExpression("return iterateObjectsToList().toArray();", (IValue)iJavaObject);
        if (iValue instanceof IJavaArray) {
            IJavaArray iJavaArray = (IJavaArray)iValue;
            ArrayList<MyJavaVariable> arrayList = new ArrayList<MyJavaVariable>();
            IJavaValue[] iJavaValueArray = iJavaArray.getValues();
            int n = 0;
            while (n < iJavaValueArray.length) {
                arrayList.add(new MyJavaVariable("[" + n + "]", iJavaValueArray[n]));
                ++n;
            }
            return arrayList.toArray(new IVariable[0]);
        }
        return null;
    }

    public class MyJavaVariable
    implements IJavaVariable {
        private String name;
        private IJavaValue value;

        public MyJavaVariable(String string, IJavaValue iJavaValue) {
            this.name = string;
            this.value = iJavaValue;
        }

        public String getSignature() throws DebugException {
            return ((IJavaValue)this.getValue()).getSignature();
        }

        public String getGenericSignature() throws DebugException {
            return ((IJavaValue)this.getValue()).getGenericSignature();
        }

        public IJavaType getJavaType() throws DebugException {
            return ((IJavaValue)this.getValue()).getJavaType();
        }

        public boolean isLocal() {
            return false;
        }

        public IValue getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public String getReferenceTypeName() throws DebugException {
            return ((IJavaValue)this.getValue()).getReferenceTypeName();
        }

        public boolean hasValueChanged() {
            return false;
        }

        public boolean isPublic() {
            return false;
        }

        public boolean isPrivate() {
            return false;
        }

        public boolean isProtected() {
            return false;
        }

        public boolean isPackagePrivate() {
            return false;
        }

        public boolean isFinal() {
            return false;
        }

        public boolean isStatic() {
            return false;
        }

        public boolean isSynthetic() {
            return false;
        }

        public String getModelIdentifier() {
            return this.getValue().getModelIdentifier();
        }

        public IDebugTarget getDebugTarget() {
            return ((IJavaValue)this.getValue()).getDebugTarget();
        }

        public ILaunch getLaunch() {
            return this.getValue().getLaunch();
        }

        public void setValue(String string) {
        }

        public void setValue(IValue iValue) {
        }

        public boolean supportsValueModification() {
            return false;
        }

        public boolean verifyValue(String string) {
            return false;
        }

        public boolean verifyValue(IValue iValue) {
            return false;
        }

        public Object getAdapter(Class clazz) {
            if (IJavaVariable.class.equals((Object)clazz) || IJavaModifiers.class.equals((Object)clazz)) {
                return this;
            }
            return null;
        }

        public boolean equals(Object object) {
            if (object instanceof MyJavaVariable) {
                MyJavaVariable myJavaVariable = (MyJavaVariable)object;
                return myJavaVariable.getName().equals(this.getName()) && myJavaVariable.getValue().equals(this.getValue());
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() + this.value.hashCode();
        }
    }
}

