/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DroolsDebugViewContentProvider
implements ITreeContentProvider {
    private Map parentCache = new HashMap(10);

    public Object[] getChildren(Object object) {
        return null;
    }

    public Object[] getElements(Object object) {
        Object[] objectArray = this.getChildren(object);
        if (objectArray != null && objectArray.length == 0) {
            return new Object[]{this.getEmptyString()};
        }
        return objectArray;
    }

    protected String getEmptyString() {
        return "Empty";
    }

    protected void cache(Object object, Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.parentCache.put(objectArray[n], object);
            ++n;
        }
    }

    public Object getParent(Object object) {
        return this.parentCache.get(object);
    }

    public void dispose() {
        this.parentCache = null;
    }

    protected void clearCache() {
        if (this.parentCache != null) {
            this.parentCache.clear();
        }
    }

    public void removeCache(Object[] objectArray) {
        if (this.parentCache == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            this.parentCache.remove(objectArray[n]);
            ++n;
        }
    }

    public boolean hasChildren(Object object) {
        try {
            if (object instanceof IVariable) {
                IValue iValue = ((IVariable)object).getValue();
                return iValue != null && iValue.hasVariables();
            }
            if (object instanceof IValue) {
                return ((IValue)object).hasVariables();
            }
            if (object instanceof IStackFrame) {
                return ((IStackFrame)object).hasVariables();
            }
        }
        catch (DebugException debugException) {
            DroolsEclipsePlugin.log(debugException);
            return false;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.clearCache();
    }

    public List getCachedDecendants(Object object) {
        Iterator iterator = this.parentCache.keySet().iterator();
        ArrayList arrayList = new ArrayList(10);
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!this.isCachedDecendant(k, object)) continue;
            arrayList.add(k);
        }
        return arrayList;
    }

    protected boolean isCachedDecendant(Object object, Object object2) {
        Object object3 = this.getParent(object);
        while (object3 != null) {
            if (object3.equals(object2)) {
                return true;
            }
            object3 = this.getParent(object3);
        }
        return false;
    }

    protected IValue getLogicalValue(IValue iValue, List list) {
        ILogicalStructureType iLogicalStructureType;
        ILogicalStructureType[] iLogicalStructureTypeArray = DebugPlugin.getLogicalStructureTypes((IValue)iValue);
        if (iLogicalStructureTypeArray.length > 0 && (iLogicalStructureType = DebugPlugin.getDefaultStructureType((ILogicalStructureType[])iLogicalStructureTypeArray)) != null && !list.contains(iLogicalStructureType.getId())) {
            try {
                iValue = iLogicalStructureType.getLogicalStructure(iValue);
                list.add(iLogicalStructureType.getId());
                return this.getLogicalValue(iValue, list);
            }
            catch (CoreException coreException) {}
        }
        return iValue;
    }
}

