/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.actions.ShowLogicalStructureAction;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.VariablesViewModelPresentation;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public abstract class DroolsDebugEventHandlerView
extends AbstractDebugView
implements IDebugContextListener,
ISelectionListener {
    private VariablesViewModelPresentation modelPresentation;
    private boolean showLogical = true;
    private Object[] oldExpandedElements = new Object[0];

    public void dispose() {
        DebugContextManager.getDefault().removeDebugContextListener((IDebugContextListener)this);
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.VariableView", (ISelectionListener)this);
        super.dispose();
    }

    public boolean isShowLogicalStructure() {
        return this.showLogical;
    }

    public void setShowLogicalStructure(boolean bl) {
        this.showLogical = bl;
    }

    protected void setViewerInput(Object object) {
        Object object2;
        IValue iValue;
        Object object3;
        IValue iValue2 = null;
        if (object instanceof IVariable) {
            object3 = (IVariable)object;
            try {
                iValue = ((IVariable)object).getValue();
                if (iValue != null && iValue instanceof IJavaObject) {
                    if ("org.drools.reteoo.ReteooStatefulSession".equals(object3.getValue().getReferenceTypeName())) {
                        iValue2 = iValue;
                    } else if ("org.drools.impl.StatefulKnowledgeSessionImpl".equals(object3.getValue().getReferenceTypeName()) && (object2 = ((IJavaObject)iValue).getField("session", false)) != null) {
                        iValue2 = object2.getValue();
                    }
                }
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
            }
        }
        if (iValue2 == null && (object3 = DebugContextManager.getDefault().getContextService(this.getSite().getWorkbenchWindow())) != null && (iValue = object3.getActiveContext()) instanceof IStructuredSelection && (object2 = ((IStructuredSelection)iValue).getFirstElement()) instanceof IJavaStackFrame) {
            try {
                IJavaThread iJavaThread = (IJavaThread)((IJavaStackFrame)object2).getThread();
                IStackFrame[] iStackFrameArray = iJavaThread.getStackFrames();
                int n = 0;
                while (n < iStackFrameArray.length) {
                    IJavaObject iJavaObject = ((IJavaStackFrame)iStackFrameArray[n]).getThis();
                    if (iJavaObject != null && iJavaObject.getJavaType() != null && ("org.drools.reteoo.ReteooStatefulSession".equals(iJavaObject.getJavaType().getName()) || "org.drools.impl.StatefulKnowledgeSessionImpl".equals(iJavaObject.getJavaType().getName()))) {
                        iValue2 = iJavaObject;
                        break;
                    }
                    ++n;
                }
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
            }
        }
        if ((object3 = this.getViewer().getInput()) == null && iValue2 == null) {
            return;
        }
        iValue = ((TreeViewer)this.getViewer()).getExpandedElements();
        if (((Object[])iValue).length != 0) {
            this.oldExpandedElements = iValue;
        }
        this.getViewer().setInput(iValue2);
        if (iValue2 != null) {
            ((TreeViewer)this.getViewer()).setExpandedElements(this.oldExpandedElements);
            ((TreeViewer)this.getViewer()).expandToLevel(this.getAutoExpandLevel());
        }
    }

    protected Viewer createViewer(Composite composite) {
        TreeViewer treeViewer = new TreeViewer(composite);
        treeViewer.setContentProvider(this.createContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new VariablesViewLabelProvider(this.getModelPresentation()));
        treeViewer.setUseHashlookup(true);
        DebugContextManager.getDefault().addDebugContextListener((IDebugContextListener)this);
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.VariableView", (ISelectionListener)this);
        return treeViewer;
    }

    protected int getAutoExpandLevel() {
        return 0;
    }

    protected abstract IContentProvider createContentProvider();

    protected String getHelpContextId() {
        return null;
    }

    protected void becomesHidden() {
        this.setViewerInput(null);
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        ISelection iSelection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.VariableView");
        if (iSelection instanceof IStructuredSelection) {
            this.setViewerInput(((IStructuredSelection)iSelection).getFirstElement());
        } else {
            this.setViewerInput(null);
        }
    }

    protected void createActions() {
        ShowLogicalStructureAction showLogicalStructureAction = new ShowLogicalStructureAction(this);
        this.setAction("ShowLogicalStructure", (IAction)showLogicalStructureAction);
    }

    protected void configureToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add(this.getAction("ShowLogicalStructure"));
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void contextActivated(ISelection iSelection, IWorkbenchPart iWorkbenchPart) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (iSelection instanceof IStructuredSelection) {
            this.setViewerInput(((IStructuredSelection)iSelection).getFirstElement());
        }
        this.showViewer();
    }

    public void debugContextChanged(DebugContextEvent debugContextEvent) {
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (!this.isAvailable()) {
            return;
        }
        if (iWorkbenchPart instanceof VariablesView) {
            iSelection = ((VariablesView)iWorkbenchPart).getCurrentSelection();
        }
        if (iSelection == null) {
            this.setViewerInput(null);
        } else if (iSelection instanceof IStructuredSelection) {
            this.setViewerInput(((IStructuredSelection)iSelection).getFirstElement());
        }
    }

    protected void initActionState(IAction iAction) {
        String string = iAction.getId();
        if (string.endsWith("ShowLogicalStructureAction")) {
            iAction.setChecked(true);
        } else {
            super.initActionState(iAction);
        }
    }

    protected IDebugModelPresentation getModelPresentation() {
        if (this.modelPresentation == null) {
            this.modelPresentation = new VariablesViewModelPresentation();
        }
        return this.modelPresentation;
    }

    private class VariablesViewLabelProvider
    implements ILabelProvider,
    IColorProvider {
        private IDebugModelPresentation presentation;

        public VariablesViewLabelProvider(IDebugModelPresentation iDebugModelPresentation) {
            this.presentation = iDebugModelPresentation;
        }

        public IDebugModelPresentation getPresentation() {
            return this.presentation;
        }

        public Image getImage(Object object) {
            return this.presentation.getImage(object);
        }

        public String getText(Object object) {
            return this.presentation.getText(object);
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
            this.presentation.addListener(iLabelProviderListener);
        }

        public void dispose() {
            this.presentation.dispose();
        }

        public boolean isLabelProperty(Object object, String string) {
            return this.presentation.isLabelProperty(object, string);
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
            this.presentation.removeListener(iLabelProviderListener);
        }

        public Color getForeground(Object object) {
            if (object instanceof IVariable) {
                IVariable iVariable = (IVariable)object;
                try {
                    if (iVariable.hasValueChanged()) {
                        return JFaceResources.getColorRegistry().get("org.eclipse.debug.ui.changedDebugElement");
                    }
                }
                catch (DebugException debugException) {
                    DroolsEclipsePlugin.log(debugException);
                }
            }
            return null;
        }

        public Color getBackground(Object object) {
            return null;
        }
    }
}

