/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.action;

import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.wizard.project.NewDroolsProjectWizard;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ConvertToDroolsProjectAction
implements IObjectActionDelegate {
    private IJavaProject project;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
    }

    public void run(IAction iAction) {
        if (this.project != null && this.project.exists()) {
            try {
                ConvertToDroolsProjectAction.addDroolsBuilder(this.project, null);
                ConvertToDroolsProjectAction.addDroolsLibraries(this.project, null);
            }
            catch (Throwable throwable) {
                DroolsEclipsePlugin.log(throwable);
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        IStructuredSelection iStructuredSelection;
        if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1) {
            IJavaProject iJavaProject;
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof IJavaProject) {
                this.project = (IJavaProject)object;
            } else if (object instanceof IProject && (iJavaProject = JavaCore.create((IProject)((IProject)object))) != null && iJavaProject.exists()) {
                this.project = iJavaProject;
            }
        }
    }

    public static void addDroolsBuilder(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iJavaProject.getProject().getDescription();
        ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
        int n = 0;
        while (n < iCommandArray.length) {
            if ("org.drools.eclipse.droolsbuilder".equals(iCommandArray[n].getBuilderName())) {
                return;
            }
            ++n;
        }
        ICommand[] iCommandArray2 = new ICommand[iCommandArray.length + 1];
        System.arraycopy(iCommandArray, 0, iCommandArray2, 0, iCommandArray.length);
        ICommand iCommand = iProjectDescription.newCommand();
        iCommand.setBuilderName("org.drools.eclipse.droolsbuilder");
        iCommandArray2[iCommandArray.length] = iCommand;
        iProjectDescription.setBuildSpec(iCommandArray2);
        iJavaProject.getProject().setDescription(iProjectDescription, iProgressMonitor);
    }

    public static void addDroolsLibraries(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            if ("DROOLS/Drools".equals(iClasspathEntryArray[n].getPath().toString())) {
                return;
            }
            ++n;
        }
        NewDroolsProjectWizard.addDroolsLibraries(iJavaProject, null);
    }
}

