/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse;

import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuleBaseConfiguration;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.process.core.WorkDefinition;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkItemDefinitions {
    private WorkItemDefinitions() {
    }

    public static Map<String, WorkDefinition> getWorkDefinitions(IResource iResource) {
        IProject iProject = iResource.getProject();
        if (iProject != null) {
            try {
                IJavaProject iJavaProject;
                if (iProject.getNature("org.eclipse.jdt.core.javanature") != null && (iJavaProject = JavaCore.create((IProject)iProject)) != null && iJavaProject.exists()) {
                    return WorkItemDefinitions.getWorkDefinitions(iJavaProject);
                }
            }
            catch (CoreException coreException) {
                DroolsEclipsePlugin.log(coreException);
            }
        }
        return null;
    }

    public static Map<String, WorkDefinition> getWorkDefinitions(IJavaProject iJavaProject) {
        if (iJavaProject != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            URLClassLoader uRLClassLoader = ProjectClassLoader.getProjectClassLoader(iJavaProject);
            try {
                Thread.currentThread().setContextClassLoader(uRLClassLoader);
                Map map = new RuleBaseConfiguration().getProcessWorkDefinitions();
                return map;
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        return new HashMap<String, WorkDefinition>();
    }

    public static void main(String[] stringArray) {
        for (WorkDefinition workDefinition : new RuleBaseConfiguration().getProcessWorkDefinitions().values()) {
            System.out.println(workDefinition);
        }
    }
}

