/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.drools.bpmn2.legacy.beta1.BPMN2SemanticModule;
import org.drools.bpmn2.legacy.beta1.BPMNDISemanticModule;
import org.drools.bpmn2.legacy.beta1.BPMNSemanticModule;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsError;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.compiler.PackageRegistry;
import org.drools.compiler.ProcessBuilder;
import org.drools.compiler.xml.XmlProcessReader;
import org.drools.core.util.StringUtils;
import org.drools.definition.process.Process;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.ProcessInfo;
import org.drools.eclipse.builder.DroolsBuilder;
import org.drools.eclipse.builder.Util;
import org.drools.eclipse.dsl.editor.DSLAdapter;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.util.ProjectClassLoader;
import org.drools.io.ResourceFactory;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.drools.rule.builder.dialect.java.JavaDialectConfiguration;
import org.drools.xml.SemanticModule;
import org.drools.xml.SemanticModules;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DroolsEclipsePlugin
extends AbstractUIPlugin {
    public static final int INTERNAL_ERROR = 120;
    public static final String PLUGIN_ID = "org.drools.eclipse";
    public static final String BUILD_RESULT_PACKAGE = "Package";
    public static final String BUILD_RESULT_PACKAGE_DESCR = "PackageDescr";
    private static DroolsEclipsePlugin plugin;
    private ResourceBundle resourceBundle;
    private Map<String, Color> colors = new HashMap<String, Color>();
    private Map<IResource, DRLInfo> parsedRules = new HashMap<IResource, DRLInfo>();
    private Map<IResource, DRLInfo> compiledRules = new HashMap<IResource, DRLInfo>();
    private Map<String, DRLInfo.RuleInfo> ruleInfoByClassNameMap = new HashMap<String, DRLInfo.RuleInfo>();
    private Map<String, DRLInfo.FunctionInfo> functionInfoByClassNameMap = new HashMap<String, DRLInfo.FunctionInfo>();
    private Map<IResource, ProcessInfo> processInfos = new HashMap<IResource, ProcessInfo>();
    private Map<String, ProcessInfo> processInfosById = new HashMap<String, ProcessInfo>();
    private boolean useCachePreference;
    private FormColors ruleBuilderFormColors;

    public DroolsEclipsePlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        IPreferenceStore iPreferenceStore = this.getPreferenceStore();
        this.useCachePreference = iPreferenceStore.getBoolean("Drools.CacheParsedRules");
        iPreferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("Drools.CacheParsedRules".equals(propertyChangeEvent.getProperty())) {
                    DroolsEclipsePlugin.this.useCachePreference = (Boolean)propertyChangeEvent.getNewValue();
                    if (!DroolsEclipsePlugin.this.useCachePreference) {
                        DroolsEclipsePlugin.this.clearCache();
                    }
                }
            }
        });
    }

    public void clearCache() {
        this.parsedRules.clear();
        this.compiledRules.clear();
        this.ruleInfoByClassNameMap.clear();
        this.functionInfoByClassNameMap.clear();
        this.processInfos.clear();
        this.processInfosById = null;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        plugin = null;
        this.resourceBundle = null;
        this.parsedRules = null;
        this.compiledRules = null;
        this.processInfos = null;
        this.processInfosById = null;
        for (Color color : this.colors.values()) {
            color.dispose();
        }
    }

    public static DroolsEclipsePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = DroolsEclipsePlugin.getDefault().getResourceBundle();
        try {
            return resourceBundle != null ? resourceBundle.getString(string) : string;
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("droolsIDE.DroolsIDEPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        DroolsEclipsePlugin droolsEclipsePlugin = DroolsEclipsePlugin.getDefault();
        ImageRegistry imageRegistry = droolsEclipsePlugin.getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(string);
        if (imageDescriptor == null) {
            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)string);
            imageRegistry.put(string, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static String getUniqueIdentifier() {
        if (DroolsEclipsePlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return DroolsEclipsePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(Throwable throwable) {
        DebugException debugException;
        IStatus iStatus;
        Throwable throwable2 = throwable;
        if (throwable instanceof DebugException && (iStatus = (debugException = (DebugException)throwable).getStatus()).getException() != null) {
            throwable2 = iStatus.getException();
        }
        DroolsEclipsePlugin.log((IStatus)new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), 120, "Internal error in Drools Plugin: ", throwable2));
    }

    public static void log(IStatus iStatus) {
        DroolsEclipsePlugin.getDefault().getLog().log(iStatus);
    }

    public Color getColor(String string) {
        return this.colors.get(string);
    }

    public void setColor(String string, Color color) {
        this.colors.put(string, color);
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
        iPreferenceStore.setDefault("Drools.BuildAll", false);
        iPreferenceStore.setDefault("Drools.EditorFolding", true);
        iPreferenceStore.setDefault("Drools.CacheParsedRules", true);
        iPreferenceStore.setDefault("Drools.DSLRuleEditorCompletionFullSentences", true);
        iPreferenceStore.setDefault("Drools.Flow.Skin", "BPMN2");
        iPreferenceStore.setDefault("Drools.Flow.AllowNodeCustomization", false);
        iPreferenceStore.setDefault("Drools.InternalAPI", 2);
        iPreferenceStore.setDefault("Drools.FlowNodes", "1111111111111");
    }

    public DRLInfo parseResource(IResource iResource, boolean bl) throws DroolsParserException {
        DRLInfo dRLInfo = this.compiledRules.get(iResource);
        if (dRLInfo == null && !bl) {
            dRLInfo = this.parsedRules.get(iResource);
        }
        if (dRLInfo != null) {
            return dRLInfo;
        }
        return this.generateParsedResource(iResource, bl);
    }

    public DRLInfo parseResource(AbstractRuleEditor abstractRuleEditor, boolean bl, boolean bl2) throws DroolsParserException {
        IResource iResource = abstractRuleEditor.getResource();
        if (!abstractRuleEditor.isDirty() || !bl) {
            DRLInfo dRLInfo = this.compiledRules.get(iResource);
            if (dRLInfo == null && !bl2) {
                dRLInfo = this.parsedRules.get(iResource);
            }
            if (dRLInfo != null) {
                return dRLInfo;
            }
        }
        if (!abstractRuleEditor.isDirty()) {
            return this.generateParsedResource(abstractRuleEditor.getContent(), iResource, true, bl2);
        }
        return this.generateParsedResource(abstractRuleEditor.getContent(), iResource, !bl, bl2);
    }

    public DRLInfo parseXLSResource(String string, IResource iResource) throws DroolsParserException {
        DRLInfo dRLInfo = this.compiledRules.get(iResource);
        if (dRLInfo != null) {
            return dRLInfo;
        }
        return this.generateParsedResource(string, iResource, false, true);
    }

    public DRLInfo parseBRLResource(String string, IResource iResource) throws DroolsParserException {
        DRLInfo dRLInfo = this.compiledRules.get(iResource);
        if (dRLInfo != null) {
            return dRLInfo;
        }
        return this.generateParsedResource(string, iResource, false, true);
    }

    public DRLInfo parseGDSTResource(String string, IResource iResource) throws DroolsParserException {
        DRLInfo dRLInfo = this.compiledRules.get(iResource);
        if (dRLInfo != null) {
            return dRLInfo;
        }
        return this.generateParsedResource(string, iResource, false, true);
    }

    public void invalidateResource(IResource iResource) {
        Object object;
        DRLInfo dRLInfo = this.compiledRules.remove(iResource);
        if (dRLInfo != null) {
            object = dRLInfo.getRuleInfos();
            int n = 0;
            while (n < ((DRLInfo.RuleInfo[])object).length) {
                this.ruleInfoByClassNameMap.remove(object[n].getClassName());
                ++n;
            }
            DRLInfo.FunctionInfo[] functionInfoArray = dRLInfo.getFunctionInfos();
            int n2 = 0;
            while (n2 < functionInfoArray.length) {
                this.functionInfoByClassNameMap.remove(functionInfoArray[n2].getClassName());
                ++n2;
            }
        }
        this.parsedRules.remove(iResource);
        object = this.processInfos.remove(iResource);
        if (object != null) {
            this.processInfosById.remove(((ProcessInfo)object).getProcessId());
        }
    }

    private DRLInfo generateParsedResource(IResource iResource, boolean bl) throws DroolsParserException {
        if (iResource instanceof IFile) {
            IFile iFile = (IFile)iResource;
            try {
                String string = new String(Util.getResourceContentsAsCharArray(iFile));
                return this.generateParsedResource(string, (IResource)iFile, true, bl);
            }
            catch (CoreException coreException) {
                DroolsEclipsePlugin.log(coreException);
            }
        }
        return null;
    }

    public DRLInfo generateParsedResource(String string, IResource iResource, boolean bl, boolean bl2) throws DroolsParserException {
        PackageBuilderConfiguration packageBuilderConfiguration;
        bl = bl && this.useCachePreference;
        DrlParser drlParser = new DrlParser();
        Reader reader = DSLAdapter.getDSLContent(string, iResource);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader2 = DroolsBuilder.class.getClassLoader();
        String string2 = null;
        if (iResource != null && iResource.getProject().getNature("org.eclipse.jdt.core.javanature") != null) {
            packageBuilderConfiguration = JavaCore.create((IProject)iResource.getProject());
            classLoader2 = ProjectClassLoader.getProjectClassLoader((IJavaProject)packageBuilderConfiguration);
            string2 = packageBuilderConfiguration.getOption("org.eclipse.jdt.core.compiler.compliance", true);
        }
        try {
            DRLInfo.RuleInfo[] ruleInfoArray;
            Object object;
            JavaDialectConfiguration javaDialectConfiguration;
            Thread.currentThread().setContextClassLoader(classLoader2);
            packageBuilderConfiguration = new PackageBuilderConfiguration();
            if (string2 != null) {
                javaDialectConfiguration = (JavaDialectConfiguration)packageBuilderConfiguration.getDialectConfiguration("java");
                javaDialectConfiguration.setJavaLanguageLevel(string2);
            }
            packageBuilderConfiguration.setClassLoader(new ClassLoader[]{classLoader2});
            javaDialectConfiguration = null;
            List<DroolsError> list = null;
            if (bl && iResource != null && (object = this.parsedRules.get(iResource)) != null) {
                javaDialectConfiguration = ((DRLInfo)object).getPackageDescr();
                list = ((DRLInfo)object).getParserErrors();
            }
            if (javaDialectConfiguration == null) {
                javaDialectConfiguration = reader != null ? drlParser.parse(true, string, reader) : drlParser.parse(true, string);
                list = drlParser.getErrors();
            }
            object = new PackageBuilder(packageBuilderConfiguration);
            DRLInfo dRLInfo = null;
            if (javaDialectConfiguration != null && bl2 && !drlParser.hasErrors()) {
                if (iResource != null && iResource.getParent() != null) {
                    PackageDescr packageDescr;
                    ruleInfoArray = new MyResourceVisitor();
                    iResource.getParent().accept((IResourceVisitor)ruleInfoArray, 1, 0);
                    IResource iResource2 = ruleInfoArray.getPackageDef();
                    if (iResource2 != null && (packageDescr = this.parseResource(iResource2, false).getPackageDescr()) != null) {
                        object.addPackage(packageDescr);
                    }
                }
                object.addPackage((PackageDescr)javaDialectConfiguration);
                if (StringUtils.isEmpty((CharSequence)javaDialectConfiguration.getNamespace())) {
                    javaDialectConfiguration.setNamespace(object.getPackageBuilderConfiguration().getDefaultPackageName());
                }
                dRLInfo = new DRLInfo(iResource == null ? "" : iResource.getProjectRelativePath().toString(), (PackageDescr)javaDialectConfiguration, list, object.getPackageRegistry(javaDialectConfiguration.getNamespace()).getPackage(), object.getErrors().getErrors(), object.getPackageRegistry(javaDialectConfiguration.getNamespace()).getDialectCompiletimeRegistry());
            } else {
                dRLInfo = new DRLInfo(iResource == null ? "" : iResource.getProjectRelativePath().toString(), (PackageDescr)javaDialectConfiguration, list, new PackageRegistry((PackageBuilder)object, new Package("")).getDialectCompiletimeRegistry());
            }
            if (bl && iResource != null) {
                if (bl2 && !drlParser.hasErrors()) {
                    this.parsedRules.remove(iResource);
                    this.compiledRules.put(iResource, dRLInfo);
                    ruleInfoArray = dRLInfo.getRuleInfos();
                    int n = 0;
                    while (n < ruleInfoArray.length) {
                        this.ruleInfoByClassNameMap.put(ruleInfoArray[n].getClassName(), ruleInfoArray[n]);
                        ++n;
                    }
                    DRLInfo.FunctionInfo[] functionInfoArray = dRLInfo.getFunctionInfos();
                    int n2 = 0;
                    while (n2 < functionInfoArray.length) {
                        this.functionInfoByClassNameMap.put(functionInfoArray[n2].getClassName(), functionInfoArray[n2]);
                        ++n2;
                    }
                } else {
                    this.parsedRules.put(iResource, dRLInfo);
                }
            }
            DRLInfo dRLInfo2 = dRLInfo;
            Thread.currentThread().setContextClassLoader(classLoader);
            return dRLInfo2;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                throw throwable;
            }
            catch (CoreException coreException) {
                DroolsEclipsePlugin.log(coreException);
                return null;
            }
        }
    }

    public DRLInfo.RuleInfo getRuleInfoByClass(String string) {
        return this.ruleInfoByClassNameMap.get(string);
    }

    public DRLInfo.FunctionInfo getFunctionInfoByClass(String string) {
        return this.functionInfoByClassNameMap.get(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProcessInfo parseProcess(String string, IResource iResource) {
        try {
            IJavaProject iJavaProject;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader classLoader2 = ((Object)((Object)this)).getClass().getClassLoader();
            String string2 = null;
            if (iResource.getProject().getNature("org.eclipse.jdt.core.javanature") != null) {
                iJavaProject = JavaCore.create((IProject)iResource.getProject());
                classLoader2 = ProjectClassLoader.getProjectClassLoader(iJavaProject);
                string2 = iJavaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            }
            try {
                JavaDialectConfiguration javaDialectConfiguration;
                Thread.currentThread().setContextClassLoader(classLoader2);
                iJavaProject = new PackageBuilderConfiguration();
                if (string2 != null) {
                    javaDialectConfiguration = (JavaDialectConfiguration)iJavaProject.getDialectConfiguration("java");
                    javaDialectConfiguration.setJavaLanguageLevel(string2);
                }
                iJavaProject.setClassLoader(new ClassLoader[]{classLoader2});
                javaDialectConfiguration = iJavaProject.getSemanticModules();
                javaDialectConfiguration.addSemanticModule((SemanticModule)new org.drools.bpmn2.xml.BPMNSemanticModule());
                javaDialectConfiguration.addSemanticModule((SemanticModule)new BPMNSemanticModule());
                javaDialectConfiguration.addSemanticModule((SemanticModule)new BPMN2SemanticModule());
                javaDialectConfiguration.addSemanticModule((SemanticModule)new BPMNDISemanticModule());
                XmlProcessReader xmlProcessReader = new XmlProcessReader((SemanticModules)javaDialectConfiguration);
                org.drools.process.core.Process process = (org.drools.process.core.Process)xmlProcessReader.read((Reader)new StringReader(string));
                if (process == null) throw new IllegalArgumentException("Could not parse process " + iResource);
                ProcessInfo processInfo = this.parseProcess(process, iResource, (PackageBuilderConfiguration)iJavaProject);
                return processInfo;
            }
            finally {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
        }
        catch (Exception exception) {
            DroolsEclipsePlugin.log(exception);
            return null;
        }
    }

    public ProcessInfo getProcessInfo(String string) {
        return this.processInfosById.get(string);
    }

    public ProcessInfo parseProcess(org.drools.process.core.Process process, IResource iResource, PackageBuilderConfiguration packageBuilderConfiguration) {
        PackageBuilder packageBuilder = new PackageBuilder(packageBuilderConfiguration);
        ProcessBuilder processBuilder = new ProcessBuilder(packageBuilder);
        processBuilder.buildProcess((Process)process, ResourceFactory.newUrlResource((String)("file://" + iResource.getLocation().toString())));
        ProcessInfo processInfo = new ProcessInfo(process.getId(), (Process)process);
        ArrayList<DroolsError> arrayList = new ArrayList<DroolsError>();
        arrayList.addAll(processBuilder.getErrors());
        arrayList.addAll(Arrays.asList(packageBuilder.getErrors().getErrors()));
        processInfo.setErrors(arrayList);
        if (this.useCachePreference) {
            this.processInfos.put(iResource, processInfo);
            this.processInfosById.put(process.getId(), processInfo);
        }
        return processInfo;
    }

    public FormColors getRuleBuilderFormColors(Display display) {
        if (this.ruleBuilderFormColors == null) {
            this.ruleBuilderFormColors = new FormColors(display);
            this.ruleBuilderFormColors.markShared();
        }
        return this.ruleBuilderFormColors;
    }

    private class MyResourceVisitor
    implements IResourceVisitor {
        private IResource packageDef;

        private MyResourceVisitor() {
        }

        public boolean visit(IResource iResource) throws CoreException {
            if ("package".equals(iResource.getFileExtension())) {
                this.packageDef = iResource;
            }
            return true;
        }

        public IResource getPackageDef() {
            return this.packageDef;
        }
    }
}

