/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.compiler.Dialect;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.DroolsError;
import org.drools.lang.descr.AttributeDescr;
import org.drools.lang.descr.FunctionDescr;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.RuleDescr;
import org.drools.rule.DialectRuntimeRegistry;
import org.drools.rule.LineMappings;
import org.drools.rule.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DRLInfo {
    private static final DroolsError[] EMPTY_DROOLS_ERROR_ARRAY = new DroolsError[0];
    private static final List<DroolsError> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private String sourcePathName;
    private PackageDescr packageDescr;
    private List<DroolsError> parserErrors;
    private Package compiledPackage;
    private DroolsError[] builderErrors;
    private transient RuleInfo[] ruleInfos;
    private transient FunctionInfo[] functionInfos;
    private DialectCompiletimeRegistry dialectRegistry;

    public DRLInfo(String string, PackageDescr packageDescr, List<DroolsError> list, DialectCompiletimeRegistry dialectCompiletimeRegistry) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid sourcePathName " + string);
        }
        this.sourcePathName = string;
        this.packageDescr = packageDescr;
        this.parserErrors = list == null ? EMPTY_LIST : Collections.unmodifiableList(list);
        this.builderErrors = EMPTY_DROOLS_ERROR_ARRAY;
        this.dialectRegistry = dialectCompiletimeRegistry;
    }

    public DRLInfo(String string, PackageDescr packageDescr, List<DroolsError> list, Package package_, DroolsError[] droolsErrorArray, DialectCompiletimeRegistry dialectCompiletimeRegistry) {
        this(string, packageDescr, list, dialectCompiletimeRegistry);
        if (package_ == null) {
            throw new IllegalArgumentException("Null package");
        }
        this.compiledPackage = package_;
        this.builderErrors = droolsErrorArray == null ? EMPTY_DROOLS_ERROR_ARRAY : droolsErrorArray;
    }

    public String getSourcePathName() {
        return this.sourcePathName;
    }

    public PackageDescr getPackageDescr() {
        return this.packageDescr;
    }

    public List<DroolsError> getParserErrors() {
        return this.parserErrors;
    }

    public Package getPackage() {
        return this.compiledPackage;
    }

    public DroolsError[] getBuilderErrors() {
        return this.builderErrors;
    }

    public String getPackageName() {
        return this.packageDescr == null ? null : this.packageDescr.getName();
    }

    public boolean isCompiled() {
        return this.compiledPackage != null;
    }

    public RuleInfo[] getRuleInfos() {
        if (this.ruleInfos == null) {
            ArrayList<RuleInfo> arrayList = new ArrayList<RuleInfo>();
            if (this.packageDescr != null) {
                for (RuleDescr ruleDescr : this.packageDescr.getRules()) {
                    RuleInfo ruleInfo = new RuleInfo(ruleDescr);
                    arrayList.add(ruleInfo);
                }
            }
            this.ruleInfos = arrayList.toArray(new RuleInfo[0]);
        }
        return this.ruleInfos;
    }

    public RuleInfo getRuleInfo(int n) {
        RuleInfo[] ruleInfoArray = this.getRuleInfos();
        int n2 = -1;
        RuleInfo ruleInfo = null;
        int n3 = 0;
        while (n3 < ruleInfoArray.length) {
            int n4 = ruleInfoArray[n3].getDrlLineNumber();
            if (n4 > n2 && n4 <= n + 1) {
                n2 = n4;
                ruleInfo = ruleInfoArray[n3];
            }
            ++n3;
        }
        return ruleInfo;
    }

    public DialectCompiletimeRegistry getDialectRegistry() {
        return this.dialectRegistry;
    }

    public FunctionInfo[] getFunctionInfos() {
        if (this.functionInfos == null) {
            ArrayList<FunctionInfo> arrayList = new ArrayList<FunctionInfo>();
            if (this.packageDescr != null) {
                for (FunctionDescr functionDescr : this.packageDescr.getFunctions()) {
                    FunctionInfo functionInfo = new FunctionInfo(functionDescr);
                    arrayList.add(functionInfo);
                }
            }
            this.functionInfos = arrayList.toArray(new FunctionInfo[0]);
        }
        return this.functionInfos;
    }

    public FunctionInfo getFunctionInfo(int n) {
        FunctionInfo[] functionInfoArray = this.getFunctionInfos();
        int n2 = -1;
        FunctionInfo functionInfo = null;
        int n3 = 0;
        while (n3 < functionInfoArray.length) {
            int n4 = functionInfoArray[n3].getDrlLineNumber();
            if (n4 > n2 && n4 <= n + 1) {
                n2 = n4;
                functionInfo = functionInfoArray[n3];
            }
            ++n3;
        }
        return functionInfo;
    }

    public class FunctionInfo {
        private FunctionDescr functionDescr;
        private transient String className;
        private transient int javaLineNumber = -1;

        public FunctionInfo(FunctionDescr functionDescr) {
            if (functionDescr == null) {
                throw new IllegalArgumentException("Null functionDescr");
            }
            this.functionDescr = functionDescr;
        }

        public String getSourcePathName() {
            return DRLInfo.this.getSourcePathName();
        }

        public String getClassName() {
            if (!DRLInfo.this.isCompiled()) {
                throw new IllegalArgumentException("Package has not been compiled");
            }
            if (this.className == null) {
                this.className = this.functionDescr.getClassName();
            }
            return this.className;
        }

        public int getDrlLineNumber() {
            return this.functionDescr.getLine();
        }

        public int getJavaLineNumber() {
            if (this.javaLineNumber == -1) {
                if (!DRLInfo.this.isCompiled()) {
                    throw new IllegalArgumentException("Package has not been compiled");
                }
                this.javaLineNumber = DRLInfo.this.compiledPackage.getDialectRuntimeRegistry().getLineMappings(this.className).getOffset();
            }
            return this.javaLineNumber;
        }

        public String getPackageName() {
            return DRLInfo.this.packageDescr == null ? null : DRLInfo.this.packageDescr.getName();
        }

        public String getFunctionName() {
            return this.functionDescr.getName();
        }
    }

    public class RuleInfo {
        private final RuleDescr ruleDescr;
        private transient String className;
        private transient int consequenceJavaLineNumber = -1;

        public RuleInfo(RuleDescr ruleDescr) {
            if (ruleDescr == null) {
                throw new IllegalArgumentException("Null ruleDescr");
            }
            this.ruleDescr = ruleDescr;
        }

        public String getDialectName() {
            String string = null;
            string = ((AttributeDescr)this.ruleDescr.getAttributes().get("dialect")).getValue();
            if (string == null && DRLInfo.this.packageDescr != null) {
                for (AttributeDescr attributeDescr : DRLInfo.this.packageDescr.getAttributes()) {
                    if (!"dialect".equals(attributeDescr.getName())) continue;
                    string = attributeDescr.getValue();
                    break;
                }
            }
            return string;
        }

        public Dialect getDialect() {
            String string = this.getDialectName();
            if (string == null) {
                return null;
            }
            return DRLInfo.this.dialectRegistry.getDialect(string);
        }

        public String getSourcePathName() {
            return DRLInfo.this.getSourcePathName();
        }

        public String getClassName() {
            if (!DRLInfo.this.isCompiled()) {
                throw new IllegalArgumentException("Package has not been compiled");
            }
            if (this.className == null) {
                String string = this.getPackageName();
                this.className = String.valueOf(string == null ? "" : String.valueOf(string) + ".") + this.ruleDescr.getClassName();
            }
            return this.className;
        }

        public int getDrlLineNumber() {
            return this.ruleDescr.getLine();
        }

        public int getConsequenceDrlLineNumber() {
            return this.ruleDescr.getConsequenceLine();
        }

        public int getConsequenceJavaLineNumber() {
            if (this.consequenceJavaLineNumber == -1) {
                if (!DRLInfo.this.isCompiled()) {
                    throw new IllegalArgumentException("Package has not been compiled");
                }
                DialectRuntimeRegistry dialectRuntimeRegistry = DRLInfo.this.compiledPackage.getDialectRuntimeRegistry();
                LineMappings lineMappings = dialectRuntimeRegistry.getLineMappings(this.className);
                this.consequenceJavaLineNumber = lineMappings.getOffset();
            }
            return this.consequenceJavaLineNumber;
        }

        public String getPackageName() {
            return DRLInfo.this.packageDescr == null ? null : DRLInfo.this.packageDescr.getName();
        }

        public String getRuleName() {
            return this.ruleDescr.getName();
        }
    }
}

