/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testframework;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.event.AgendaEventListener;
import org.drools.ide.common.client.modeldriven.testing.ActivateRuleFlowGroup;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Expectation;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.FieldData;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.RetractFact;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;
import org.drools.ide.common.server.util.ScenarioXMLPersistence;
import org.drools.rule.DroolsCompositeClassLoader;
import org.drools.rule.Package;
import org.drools.rule.TimeMachine;
import org.drools.testframework.FactFieldValueVerifier;
import org.drools.testframework.TestingEventListener;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScenarioRunner {
    final Scenario scenario;
    final Map<String, Object> populatedData = new HashMap<String, Object>();
    final Map<String, Object> globalData = new HashMap<String, Object>();
    final Map<String, FactHandle> factHandles = new HashMap<String, FactHandle>();
    final InternalWorkingMemory workingMemory;

    public ScenarioRunner(Scenario scenario, TypeResolver resolver, InternalWorkingMemory wm) throws ClassNotFoundException {
        this.scenario = scenario;
        this.workingMemory = wm;
        this.runScenario(scenario, resolver);
    }

    public ScenarioRunner(String xml, RuleBase rb) throws ClassNotFoundException {
        this.scenario = ScenarioXMLPersistence.getInstance().unmarshal(xml);
        this.workingMemory = (InternalWorkingMemory)rb.newStatefulSession();
        Package pk = rb.getPackages()[0];
        DroolsCompositeClassLoader cl = ((InternalRuleBase)rb).getRootClassLoader();
        HashSet<String> imports = new HashSet<String>();
        imports.add(pk.getName() + ".*");
        imports.addAll(pk.getImports().keySet());
        ClassTypeResolver resolver = new ClassTypeResolver(imports, (ClassLoader)cl);
        this.runScenario(this.scenario, (TypeResolver)resolver);
    }

    private void runScenario(Scenario scenario, TypeResolver resolver) throws ClassNotFoundException {
        MVEL.COMPILER_OPT_ALLOW_NAKED_METH_CALL = true;
        scenario.lastRunResult = new Date();
        HashSet<String> ruleList = new HashSet<String>();
        ruleList.addAll(scenario.rules);
        TestingEventListener listener = null;
        ArrayList<Populate> toPopulate = new ArrayList<Populate>();
        for (final FactData fact : scenario.globals) {
            final Object factObject = MVEL.eval((String)("new " + this.getTypeName(resolver, fact) + "()"));
            toPopulate.add(new Populate(){

                public void go() {
                    ScenarioRunner.this.populateFields(fact, ScenarioRunner.this.globalData, factObject);
                }
            });
            this.globalData.put(fact.name, factObject);
            this.workingMemory.setGlobal(fact.name, factObject);
        }
        this.doPopulate(toPopulate);
        for (Fixture fixture : scenario.fixtures) {
            if (fixture instanceof FactData) {
                Object factObject;
                final FactData fact = (FactData)fixture;
                Object object = factObject = fact.isModify ? this.populatedData.get(fact.name) : MVEL.eval((String)("new " + this.getTypeName(resolver, fact) + "()"));
                if (fact.isModify) {
                    if (!this.factHandles.containsKey(fact.name)) {
                        throw new IllegalArgumentException("Was not a previously inserted fact. [" + fact.name + "]");
                    }
                    toPopulate.add(new Populate(){

                        public void go() {
                            ScenarioRunner.this.populateFields(fact, ScenarioRunner.this.populatedData, factObject);
                            ScenarioRunner.this.workingMemory.update((org.drools.runtime.rule.FactHandle)ScenarioRunner.this.factHandles.get(fact.name), factObject);
                        }
                    });
                    continue;
                }
                this.populatedData.put(fact.name, factObject);
                toPopulate.add(new Populate(){

                    public void go() {
                        ScenarioRunner.this.populateFields(fact, ScenarioRunner.this.populatedData, factObject);
                        ScenarioRunner.this.factHandles.put(fact.name, ScenarioRunner.this.workingMemory.insert(factObject));
                    }
                });
                continue;
            }
            if (fixture instanceof RetractFact) {
                RetractFact retractFact = (RetractFact)fixture;
                this.workingMemory.retract((org.drools.runtime.rule.FactHandle)this.factHandles.get(retractFact.name));
                this.populatedData.remove(retractFact.name);
                continue;
            }
            if (fixture instanceof ActivateRuleFlowGroup) {
                this.workingMemory.getAgenda().activateRuleFlowGroup(((ActivateRuleFlowGroup)fixture).name);
                continue;
            }
            if (fixture instanceof ExecutionTrace) {
                this.doPopulate(toPopulate);
                ExecutionTrace executionTrace = (ExecutionTrace)fixture;
                if (listener != null) {
                    this.workingMemory.removeEventListener(listener);
                }
                listener = new TestingEventListener();
                this.workingMemory.addEventListener((AgendaEventListener)listener);
                this.applyTimeMachine(this.workingMemory, executionTrace);
                long time = System.currentTimeMillis();
                this.workingMemory.fireAllRules(listener.getAgendaFilter(ruleList, scenario.inclusive), scenario.maxRuleFirings);
                executionTrace.executionTimeResult = System.currentTimeMillis() - time;
                executionTrace.numberOfRulesFired = listener.totalFires;
                executionTrace.rulesFired = listener.getRulesFiredSummary();
                continue;
            }
            if (fixture instanceof Expectation) {
                this.doPopulate(toPopulate);
                Expectation assertion = (Expectation)fixture;
                if (assertion instanceof VerifyFact) {
                    this.verify((VerifyFact)assertion);
                    continue;
                }
                if (!(assertion instanceof VerifyRuleFired)) continue;
                this.verify((VerifyRuleFired)assertion, listener.firingCounts != null ? listener.firingCounts : new HashMap());
                continue;
            }
            throw new IllegalArgumentException("Not sure what to do with " + fixture);
        }
        this.doPopulate(toPopulate);
    }

    private void doPopulate(List<Populate> toPopulate) {
        for (Populate p : toPopulate) {
            p.go();
        }
        toPopulate.clear();
    }

    private String getTypeName(TypeResolver resolver, FactData fact) throws ClassNotFoundException {
        String fullName = resolver.getFullTypeName(fact.type);
        if (fullName.equals("java.util.List") || fullName.equals("java.util.Collection")) {
            return "java.util.ArrayList";
        }
        return fullName;
    }

    private void applyTimeMachine(InternalWorkingMemory wm, ExecutionTrace executionTrace) {
        if (executionTrace.scenarioSimulatedDate != null) {
            final Calendar now = Calendar.getInstance();
            now.setTimeInMillis(executionTrace.scenarioSimulatedDate.getTime());
            wm.setTimeMachine(new TimeMachine(){

                public Calendar getNow() {
                    return now;
                }
            });
        } else {
            wm.setTimeMachine(new TimeMachine());
        }
    }

    void verify(VerifyRuleFired assertion, Map<String, Integer> firingCounts) {
        assertion.actualResult = firingCounts.containsKey(assertion.ruleName) ? firingCounts.get(assertion.ruleName) : 0;
        if (assertion.expectedFire != null) {
            if (assertion.expectedFire.booleanValue()) {
                if (assertion.actualResult > 0) {
                    assertion.successResult = true;
                    assertion.explanation = "Rule [" + assertion.ruleName + "] was actived " + assertion.actualResult + " times.";
                } else {
                    assertion.successResult = false;
                    assertion.explanation = "Rule [" + assertion.ruleName + "] was not activated. Expected it to be activated.";
                }
            } else if (assertion.actualResult == 0) {
                assertion.successResult = true;
                assertion.explanation = "Rule [" + assertion.ruleName + "] was not activated.";
            } else {
                assertion.successResult = false;
                assertion.explanation = "Rule [" + assertion.ruleName + "] was activated " + assertion.actualResult + " times, but expected none.";
            }
        }
        if (assertion.expectedCount != null) {
            if (assertion.actualResult.equals(assertion.expectedCount)) {
                assertion.successResult = true;
                assertion.explanation = "Rule [" + assertion.ruleName + "] activated " + assertion.actualResult + " times.";
            } else {
                assertion.successResult = false;
                assertion.explanation = "Rule [" + assertion.ruleName + "] activated " + assertion.actualResult + " times. Expected " + assertion.expectedCount + " times.";
            }
        }
    }

    void verify(VerifyFact value) {
        if (!value.anonymous) {
            Object factObject = this.populatedData.get(value.name);
            if (factObject == null) {
                factObject = this.globalData.get(value.name);
            }
            FactFieldValueVerifier fieldVerifier = new FactFieldValueVerifier(this.populatedData, value.name, factObject);
            fieldVerifier.checkFields(value.fieldValues);
        } else {
            Iterator obs = this.workingMemory.iterateObjects();
            while (obs.hasNext()) {
                Object factObject = obs.next();
                if (!factObject.getClass().getSimpleName().equals(value.name)) continue;
                FactFieldValueVerifier fieldVerifier = new FactFieldValueVerifier(this.populatedData, value.name, factObject);
                fieldVerifier.checkFields(value.fieldValues);
                if (!value.wasSuccessful()) continue;
                return;
            }
            for (VerifyField vfl : value.fieldValues) {
                if (vfl.successResult != null) continue;
                vfl.successResult = Boolean.FALSE;
                vfl.actualResult = "No match";
            }
        }
    }

    Object populateFields(FactData fact, Map<String, Object> factData, Object factObject) {
        for (int i = 0; i < fact.fieldData.size(); ++i) {
            FieldData field = fact.fieldData.get(i);
            if (field.value == null || field.value.equals("")) continue;
            Object val = field.value.startsWith("=") ? MVEL.eval((String)field.value.substring(1), factData) : field.value;
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.putAll(factData);
            vars.put("__val__", val);
            vars.put("__fact__", factObject);
            MVEL.eval((String)("__fact__." + field.name + " = __val__"), vars);
        }
        return factObject;
    }

    public boolean wasSuccess() {
        return this.scenario.wasSuccessful();
    }

    public String getReport() {
        return this.scenario.printFailureReport();
    }

    static interface Populate {
        public void go();
    }
}

