/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testframework;

import java.util.List;
import java.util.Map;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;
import org.drools.testframework.ResultVerifier;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactFieldValueVerifier {
    private final Map<String, Object> populatedData;
    private final String factName;
    private final Object factObject;
    private VerifyField currentField;

    public FactFieldValueVerifier(Map<String, Object> populatedData, String factName, Object factObject) {
        this.populatedData = populatedData;
        this.factName = factName;
        this.factObject = factObject;
    }

    public void checkFields(List<VerifyField> fieldValues) {
        for (VerifyField this.currentField : fieldValues) {
            if (this.currentField.expected == null) continue;
            ResultVerifier resultVerifier = new ResultVerifier(this.factObject);
            resultVerifier.setExpected(this.getExpectedResult());
            this.currentField.successResult = resultVerifier.isSuccess(this.currentField);
            if (!this.currentField.successResult.booleanValue()) {
                this.currentField.actualResult = resultVerifier.getActual(this.currentField);
                this.currentField.explanation = this.getFailingExplanation();
                continue;
            }
            this.currentField.explanation = this.getSuccesfulExplanation();
        }
    }

    private Object getExpectedResult() {
        Object expectedResult = this.currentField.expected.trim();
        if (this.currentField.expected.startsWith("=")) {
            expectedResult = MVEL.eval((String)this.currentField.expected.substring(1), this.populatedData);
        }
        return expectedResult;
    }

    private String getSuccesfulExplanation() {
        if (this.currentField.operator.equals("==")) {
            return "[" + this.factName + "] field [" + this.currentField.fieldName + "] was [" + this.currentField.expected + "].";
        }
        if (this.currentField.operator.equals("!=")) {
            return "[" + this.factName + "] field [" + this.currentField.fieldName + "] was not [" + this.currentField.expected + "].";
        }
        return "";
    }

    private String getFailingExplanation() {
        if (this.currentField.operator.equals("==")) {
            return "[" + this.factName + "] field [" + this.currentField.fieldName + "] was [" + this.currentField.actualResult + "] expected [" + this.currentField.expected + "].";
        }
        return "[" + this.factName + "] field [" + this.currentField.fieldName + "] was not expected to be [" + this.currentField.actualResult + "].";
    }
}

