/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.ide.common.client.modeldriven.FieldAccessorsAndMutators;
import org.drools.ide.common.client.modeldriven.ModelField;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.lang.dsl.DSLMappingEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionCompletionEngineBuilder {
    private SuggestionCompletionEngine instance = new SuggestionCompletionEngine();
    private Map<String, ModelField.FIELD_CLASS_TYPE> factTypes = new HashMap<String, ModelField.FIELD_CLASS_TYPE>();
    private Map<String, String[]> fieldsForType = new HashMap<String, String[]>();
    private Map<String, String[]> modifiersForType = new HashMap<String, String[]>();
    private Map<String, String> fieldTypes = new HashMap<String, String>();
    private Map<String, Class<?>> fieldClasses = new HashMap();
    private Map<String, Field> fieldTypesField = new HashMap<String, Field>();
    private Map<String, String> globalTypes = new HashMap<String, String>();
    private List<DSLSentence> actionDSLSentences = new ArrayList<DSLSentence>();
    private List<DSLSentence> conditionDSLSentences = new ArrayList<DSLSentence>();
    private List<DSLSentence> keywordDSLItems = new ArrayList<DSLSentence>();
    private List<DSLSentence> anyScopeDSLItems = new ArrayList<DSLSentence>();
    private List<String> globalCollections = new ArrayList<String>();
    private Map<String, FieldAccessorsAndMutators> accessorsAndMutators = new HashMap<String, FieldAccessorsAndMutators>();

    public void newCompletionEngine() {
        this.instance = new SuggestionCompletionEngine();
        this.factTypes = new HashMap<String, ModelField.FIELD_CLASS_TYPE>();
        this.fieldsForType = new HashMap<String, String[]>();
        this.modifiersForType = new HashMap<String, String[]>();
        this.fieldTypes = new HashMap<String, String>();
        this.fieldTypesField = new HashMap<String, Field>();
        this.globalTypes = new HashMap<String, String>();
        this.actionDSLSentences = new ArrayList<DSLSentence>();
        this.conditionDSLSentences = new ArrayList<DSLSentence>();
        this.keywordDSLItems = new ArrayList<DSLSentence>();
        this.anyScopeDSLItems = new ArrayList<DSLSentence>();
        this.globalCollections = new ArrayList<String>();
        this.accessorsAndMutators = new HashMap<String, FieldAccessorsAndMutators>();
    }

    public void addFactType(String factType, ModelField.FIELD_CLASS_TYPE type) {
        this.factTypes.put(factType, type);
    }

    public void addFieldsForType(String type, String[] fields) {
        this.fieldsForType.put(type, fields);
    }

    public void addModifiersForType(String type, String[] fields) {
        this.modifiersForType.put(type, fields);
    }

    public boolean hasFieldsForType(String type) {
        return this.fieldsForType.containsKey(type);
    }

    public void addFieldType(String field, String type, Class<?> clazz) {
        this.fieldTypes.put(field, type);
        this.fieldClasses.put(field, clazz);
    }

    public void addFieldTypeField(String field, Field type) {
        this.fieldTypesField.put(field, type);
    }

    public void addGlobalType(String global, String type) {
        this.globalTypes.put(global, type);
    }

    public void addGlobalCollection(String global) {
        this.globalCollections.add(global);
    }

    public void addDSLActionSentence(String sentence) {
        DSLSentence sen = new DSLSentence();
        sen.sentence = sentence;
        this.actionDSLSentences.add(sen);
    }

    public void addDSLConditionSentence(String sentence) {
        DSLSentence sen = new DSLSentence();
        sen.sentence = sentence;
        this.conditionDSLSentences.add(sen);
    }

    public static String obtainGenericType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Object goodType = null;
            for (Type t : pt.getActualTypeArguments()) {
                goodType = t;
            }
            int index = goodType.toString().lastIndexOf(".");
            return goodType.toString().substring(index + 1);
        }
        return null;
    }

    public void putParametricFieldType(String fieldName, String genericType) {
        this.instance.putParametricFieldType(fieldName, genericType);
    }

    public SuggestionCompletionEngine getInstance() {
        this.instance.setFactTypes(this.factTypes.keySet().toArray(new String[this.factTypes.keySet().size()]));
        this.instance.setModifiers(this.modifiersForType);
        HashMap<String, ModelField[]> modelMap = new HashMap<String, ModelField[]>();
        for (Map.Entry<String, String[]> typeEntry : this.fieldsForType.entrySet()) {
            ArrayList<ModelField> fields = new ArrayList<ModelField>();
            String[] arr$ = typeEntry.getValue();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String field;
                String fieldName = field = arr$[i$];
                String fieldType = this.fieldTypes.get(typeEntry.getKey() + "." + field);
                Class<?> fieldClazz = this.fieldClasses.get(typeEntry.getKey() + "." + field);
                fields.add(new ModelField(fieldName, fieldClazz == null ? null : fieldClazz.getName(), this.factTypes.get(typeEntry.getKey()), fieldType));
            }
            modelMap.put(typeEntry.getKey(), fields.toArray(new ModelField[fields.size()]));
        }
        this.instance.setFieldsForTypes(modelMap);
        for (String fieldName : this.fieldTypesField.keySet()) {
            Class<?> fieldClass;
            Field field = this.fieldTypesField.get(fieldName);
            if (field == null) continue;
            String genericType = SuggestionCompletionEngineBuilder.obtainGenericType(field.getGenericType());
            if (genericType != null) {
                this.instance.putParametricFieldType(fieldName, genericType);
            }
            if (!(fieldClass = field.getType()).isEnum()) continue;
            Field[] flds = fieldClass.getDeclaredFields();
            ArrayList<String> listEnum = new ArrayList<String>();
            int i = 0;
            for (Field f : flds) {
                if (!f.isEnumConstant()) continue;
                listEnum.add(i + "=" + f.getName());
                ++i;
            }
            String[] a = new String[listEnum.size()];
            i = 0;
            Iterator i$ = listEnum.iterator();
            while (i$.hasNext()) {
                String value;
                a[i] = value = (String)i$.next();
                ++i;
            }
            this.instance.putDataEnumList(fieldName, a);
        }
        this.instance.setGlobalVariables(this.globalTypes);
        this.instance.actionDSLSentences = this.makeArray(this.actionDSLSentences);
        this.instance.conditionDSLSentences = this.makeArray(this.conditionDSLSentences);
        this.instance.keywordDSLItems = this.makeArray(this.keywordDSLItems);
        this.instance.anyScopeDSLItems = this.makeArray(this.anyScopeDSLItems);
        this.instance.setGlobalCollections(this.globalCollections.toArray(new String[this.globalCollections.size()]));
        this.instance.setAccessorsAndMutators(this.accessorsAndMutators);
        return this.instance;
    }

    private DSLSentence[] makeArray(List<DSLSentence> ls) {
        return ls.toArray(new DSLSentence[ls.size()]);
    }

    public void addDSLMapping(DSLMappingEntry entry) {
        DSLSentence sen = new DSLSentence();
        sen.sentence = entry.getMappingKey();
        if (entry.getSection() == DSLMappingEntry.CONDITION) {
            this.conditionDSLSentences.add(sen);
        } else if (entry.getSection() == DSLMappingEntry.CONSEQUENCE) {
            this.actionDSLSentences.add(sen);
        } else if (entry.getSection() == DSLMappingEntry.KEYWORD) {
            this.keywordDSLItems.add(sen);
        } else if (entry.getSection() == DSLMappingEntry.ANY) {
            this.anyScopeDSLItems.add(sen);
        }
    }

    public void addFieldAccessorsAndMutatorsForField(Map<String, FieldAccessorsAndMutators> accessorsAndMutators) {
        this.accessorsAndMutators.putAll(accessorsAndMutators);
    }
}

