/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleMetadata;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.dt.ActionCol;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionRetractFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.server.util.BRDRLPersistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuidedDTDRLPersistence {
    public static GuidedDTDRLPersistence getInstance() {
        return new GuidedDTDRLPersistence();
    }

    public String marshal(GuidedDecisionTable dt) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dt.data.length; ++i) {
            String[] row = dt.data[i];
            String num = row[0];
            String desc = row[1];
            RuleModel rm = new RuleModel();
            rm.name = this.getName(dt.tableName, num);
            this.doMetadata(dt.getMetadataCols(), row, rm);
            this.doAttribs(dt.getMetadataCols().size(), dt.attributeCols, row, rm);
            this.doConditions(dt.getMetadataCols().size() + dt.attributeCols.size(), dt.conditionCols, row, rm);
            this.doActions(dt.getMetadataCols().size() + dt.attributeCols.size() + dt.conditionCols.size(), dt.actionCols, row, rm);
            if (dt.parentName != null) {
                rm.parentName = dt.parentName;
            }
            sb.append("#from row number: " + (i + 1) + "\n");
            String rule = BRDRLPersistence.getInstance().marshal(rm);
            sb.append(rule);
            sb.append("\n");
        }
        return sb.toString();
    }

    void doActions(int condAndAttrs, List<ActionCol> actionCols, String[] row, RuleModel rm) {
        int i;
        ArrayList<LabelledAction> actions = new ArrayList<LabelledAction>();
        for (i = 0; i < actionCols.size(); ++i) {
            ActionFieldValue val;
            LabelledAction a;
            ActionCol c = actionCols.get(i);
            String cell = row[condAndAttrs + i + 2];
            if (!this.validCell(cell)) {
                cell = c.defaultValue;
            }
            if (!this.validCell(cell)) continue;
            if (c instanceof ActionInsertFactCol) {
                ActionInsertFact ins;
                ActionInsertFactCol ac = (ActionInsertFactCol)c;
                a = this.findByLabelledAction(actions, ac.boundName);
                if (a == null) {
                    a = new LabelledAction();
                    a.boundName = ac.boundName;
                    ins = new ActionInsertFact(ac.factType);
                    ins.setBoundName(ac.boundName);
                    a.action = ins;
                    actions.add(a);
                }
                ins = (ActionInsertFact)a.action;
                val = new ActionFieldValue(ac.factField, cell, ac.type);
                ins.addFieldValue(val);
                continue;
            }
            if (c instanceof ActionRetractFactCol) {
                ActionRetractFactCol rf = (ActionRetractFactCol)c;
                a = this.findByLabelledAction(actions, rf.boundName);
                if (a != null) continue;
                a = new LabelledAction();
                a.action = new ActionRetractFact(rf.boundName);
                a.boundName = rf.boundName;
                actions.add(a);
                continue;
            }
            if (!(c instanceof ActionSetFieldCol)) continue;
            ActionSetFieldCol sf = (ActionSetFieldCol)c;
            a = this.findByLabelledAction(actions, sf.boundName);
            if (a == null) {
                a = new LabelledAction();
                a.boundName = sf.boundName;
                a.action = !sf.update ? new ActionSetField(sf.boundName) : new ActionUpdateField(sf.boundName);
                actions.add(a);
            } else if (sf.update && !(a.action instanceof ActionUpdateField)) {
                ActionSetField old = (ActionSetField)a.action;
                ActionUpdateField update = new ActionUpdateField(sf.boundName);
                update.fieldValues = old.fieldValues;
                a.action = update;
            }
            ActionSetField asf = (ActionSetField)a.action;
            val = new ActionFieldValue(sf.factField, cell, sf.type);
            asf.addFieldValue(val);
        }
        rm.rhs = new IAction[actions.size()];
        for (i = 0; i < rm.rhs.length; ++i) {
            rm.rhs[i] = ((LabelledAction)actions.get((int)i)).action;
        }
    }

    private LabelledAction findByLabelledAction(List<LabelledAction> actions, String boundName) {
        for (LabelledAction labelledAction : actions) {
            if (!labelledAction.boundName.equals(boundName)) continue;
            return labelledAction;
        }
        return null;
    }

    void doConditions(int numOfAttributesAndMeta, List<ConditionCol> conditionCols, String[] row, RuleModel rm) {
        ArrayList<FactPattern> patterns = new ArrayList<FactPattern>();
        block4: for (int i = 0; i < conditionCols.size(); ++i) {
            ConditionCol c = conditionCols.get(i);
            String cell = row[i + 2 + numOfAttributesAndMeta];
            if (!this.validCell(cell)) {
                cell = c.defaultValue;
            }
            if (!this.validCell(cell)) continue;
            FactPattern fp = this.findByFactPattern(patterns, c.boundName);
            if (fp == null) {
                fp = new FactPattern(c.factType);
                fp.boundName = c.boundName;
                patterns.add(fp);
            }
            switch (c.constraintValueType) {
                case 1: 
                case 3: {
                    SingleFieldConstraint sfc = new SingleFieldConstraint(c.factField);
                    if (this.no(c.operator)) {
                        String[] a = cell.split("\\s");
                        if (a.length > 1) {
                            sfc.setOperator(a[0]);
                            sfc.setValue(a[1]);
                        } else {
                            sfc.setValue(cell);
                        }
                    } else {
                        sfc.setOperator(c.operator);
                        if (c.operator.equals("in")) {
                            sfc.setValue(this.makeInList(cell));
                        } else {
                            sfc.setValue(cell);
                        }
                    }
                    sfc.setConstraintValueType(c.constraintValueType);
                    fp.addConstraint(sfc);
                    continue block4;
                }
                case 5: {
                    SingleFieldConstraint pred = new SingleFieldConstraint();
                    pred.setConstraintValueType(c.constraintValueType);
                    if (c.factField != null && c.factField.indexOf("$param") > -1) {
                        pred.setValue(c.factField.replace("$param", cell));
                    } else {
                        pred.setValue(cell);
                    }
                    fp.addConstraint(pred);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Unknown constraintValueType: " + c.constraintValueType);
                }
            }
        }
        rm.lhs = patterns.toArray(new IPattern[patterns.size()]);
    }

    String makeInList(String cell) {
        if (cell.startsWith("(")) {
            return cell;
        }
        String res = "";
        StringTokenizer st = new StringTokenizer(cell, ",");
        while (st.hasMoreTokens()) {
            String t = st.nextToken().trim();
            res = t.startsWith("\"") ? res + t : res + "\"" + t + "\"";
            if (!st.hasMoreTokens()) continue;
            res = res + ", ";
        }
        return "(" + res + ")";
    }

    private boolean no(String operator) {
        return operator == null || "".equals(operator);
    }

    private FactPattern findByFactPattern(List<FactPattern> patterns, String boundName) {
        for (FactPattern factPattern : patterns) {
            if (!factPattern.boundName.equals(boundName)) continue;
            return factPattern;
        }
        return null;
    }

    void doAttribs(int numOfMeta, List<AttributeCol> attributeCols, String[] row, RuleModel rm) {
        ArrayList<RuleAttribute> attribs = new ArrayList<RuleAttribute>();
        for (int j = 0; j < attributeCols.size(); ++j) {
            AttributeCol at = attributeCols.get(j);
            String cell = row[j + 2 + numOfMeta];
            if (this.validCell(cell)) {
                attribs.add(new RuleAttribute(at.attr, cell));
                continue;
            }
            if (at.defaultValue == null) continue;
            attribs.add(new RuleAttribute(at.attr, at.defaultValue));
        }
        if (attribs.size() > 0) {
            rm.attributes = attribs.toArray(new RuleAttribute[attribs.size()]);
        }
    }

    void doMetadata(List<MetadataCol> metadataCols, String[] row, RuleModel rm) {
        ArrayList<RuleMetadata> metadataList = new ArrayList<RuleMetadata>();
        for (int j = 0; j < metadataCols.size(); ++j) {
            MetadataCol meta = metadataCols.get(j);
            String cell = row[j + 2];
            if (!this.validCell(cell)) continue;
            metadataList.add(new RuleMetadata(meta.attr, cell));
        }
        if (metadataList.size() > 0) {
            rm.metadataList = metadataList.toArray(new RuleMetadata[metadataList.size()]);
        }
    }

    String getName(String tableName, String num) {
        return "Row " + num + " " + tableName;
    }

    boolean validCell(String c) {
        return c != null && !c.trim().equals("");
    }

    private class LabelledAction {
        String boundName;
        IAction action;

        private LabelledAction() {
        }
    }
}

