/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import org.drools.core.util.ReflectiveVisitor;
import org.drools.ide.common.client.modeldriven.brl.ActionCallMethod;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldFunction;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionGlobalCollectionAdd;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.ExpressionFormLine;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.FromAccumulateCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCollectCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;
import org.drools.ide.common.server.util.BRLPersistence;

public class BRDRLPersistence
implements BRLPersistence {
    private static final BRLPersistence INSTANCE = new BRDRLPersistence();

    protected BRDRLPersistence() {
    }

    public static BRLPersistence getInstance() {
        return INSTANCE;
    }

    public String marshal(RuleModel model) {
        return this.marshalRule(model);
    }

    protected String marshalRule(RuleModel model) {
        boolean isDSLEnhanced = model.hasDSLSentences();
        StringBuilder buf = new StringBuilder();
        this.marshalHeader(model, buf);
        this.marshalMetadata(buf, model);
        this.marshalAttributes(buf, model);
        buf.append("\twhen\n");
        this.marshalLHS(buf, model, isDSLEnhanced);
        buf.append("\tthen\n");
        this.marshalRHS(buf, model, isDSLEnhanced);
        this.marshalFooter(buf);
        return buf.toString();
    }

    protected void marshalFooter(StringBuilder buf) {
        buf.append("end\n");
    }

    protected void marshalHeader(RuleModel model, StringBuilder buf) {
        buf.append("rule \"" + this.marshalRuleName(model) + "\"");
        if (null != model.parentName && model.parentName.length() > 0) {
            buf.append(" extends \"" + model.parentName + "\"\n");
        } else {
            buf.append('\n');
        }
    }

    protected String marshalRuleName(RuleModel model) {
        return model.name;
    }

    public RuleModel unmarshal(String str) {
        throw new UnsupportedOperationException("Still not possible to convert pure DRL to RuleModel");
    }

    private void marshalAttributes(StringBuilder buf, RuleModel model) {
        boolean hasDialect = false;
        for (int i = 0; i < model.attributes.length; ++i) {
            RuleAttribute attr = model.attributes[i];
            buf.append("\t");
            buf.append(attr);
            buf.append("\n");
            if (!attr.attributeName.equals("dialect")) continue;
            hasDialect = true;
        }
        if (!hasDialect) {
            RuleAttribute attr = new RuleAttribute("dialect", "mvel");
            buf.append("\t");
            buf.append(attr);
            buf.append("\n");
        }
    }

    private void marshalMetadata(StringBuilder buf, RuleModel model) {
        if (model.metadataList != null) {
            for (int i = 0; i < model.metadataList.length; ++i) {
                buf.append("\t").append(model.metadataList[i]).append("\n");
            }
        }
    }

    private void marshalLHS(StringBuilder buf, RuleModel model, boolean isDSLEnhanced) {
        if (model.lhs != null) {
            LHSPatternVisitor visitor = new LHSPatternVisitor(isDSLEnhanced, buf);
            for (IPattern cond : model.lhs) {
                visitor.visit(cond);
            }
        }
    }

    private void marshalRHS(StringBuilder buf, RuleModel model, boolean isDSLEnhanced) {
        if (model.rhs != null) {
            RHSActionVisitor visitor = new RHSActionVisitor(isDSLEnhanced, buf);
            for (IAction action : model.rhs) {
                visitor.visit(action);
            }
        }
    }

    public static class RHSActionVisitor
    extends ReflectiveVisitor {
        private StringBuilder buf;
        private boolean isDSLEnhanced;
        private int idx = 0;

        public RHSActionVisitor(boolean isDSLEnhanced, StringBuilder b) {
            this.isDSLEnhanced = isDSLEnhanced;
            this.buf = b;
        }

        public void visitActionInsertFact(ActionInsertFact action) {
            this.generateInsertCall(action, false);
        }

        public void visitActionInsertLogicalFact(ActionInsertLogicalFact action) {
            this.generateInsertCall(action, true);
        }

        public void visitFreeFormLine(FreeFormLine ffl) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append(ffl.text);
            this.buf.append("\n");
        }

        private void generateInsertCall(ActionInsertFact action, boolean isLogic) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (action.fieldValues.length == 0 && action.getBoundName() == null) {
                this.buf.append(isLogic ? "insertLogical( new " : "insert( new ");
                this.buf.append(action.factType);
                this.buf.append("() );\n");
            } else {
                this.buf.append(action.factType);
                if (action.getBoundName() == null) {
                    this.buf.append(" fact");
                    this.buf.append(this.idx);
                } else {
                    this.buf.append(" " + action.getBoundName());
                }
                this.buf.append(" = new ");
                this.buf.append(action.factType);
                this.buf.append("();\n");
                if (action.getBoundName() == null) {
                    this.generateSetMethodCalls("fact" + this.idx, action.fieldValues);
                } else {
                    this.generateSetMethodCalls(action.getBoundName(), action.fieldValues);
                }
                this.buf.append("\t\t");
                if (this.isDSLEnhanced) {
                    this.buf.append(">");
                }
                if (isLogic) {
                    this.buf.append("insertLogical(");
                    if (action.getBoundName() == null) {
                        this.buf.append("fact");
                        this.buf.append(this.idx++);
                    } else {
                        this.buf.append(action.getBoundName());
                    }
                    this.buf.append(" );\n");
                } else {
                    this.buf.append("insert(");
                    if (action.getBoundName() == null) {
                        this.buf.append("fact");
                        this.buf.append(this.idx++);
                    } else {
                        this.buf.append(action.getBoundName());
                    }
                    this.buf.append(" );\n");
                }
            }
        }

        public void visitActionUpdateField(ActionUpdateField action) {
            this.visitActionSetField(action);
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append("update( ");
            this.buf.append(action.variable);
            this.buf.append(" );\n");
        }

        public void visitActionGlobalCollectionAdd(ActionGlobalCollectionAdd add) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append(add.globalName + ".add(" + add.factName + ");\n");
        }

        public void visitActionRetractFact(ActionRetractFact action) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append("retract( ");
            this.buf.append(action.variableName);
            this.buf.append(" );\n");
        }

        public void visitDSLSentence(DSLSentence sentence) {
            this.buf.append("\t\t");
            this.buf.append(sentence.toString());
            this.buf.append("\n");
        }

        public void visitActionSetField(ActionSetField action) {
            if (action instanceof ActionCallMethod) {
                this.generateSetMethodCallsMethod((ActionCallMethod)action, action.fieldValues);
            } else {
                this.generateSetMethodCalls(action.variable, action.fieldValues);
            }
        }

        private void generateSetMethodCalls(String variableName, ActionFieldValue[] fieldValues) {
            for (int i = 0; i < fieldValues.length; ++i) {
                this.buf.append("\t\t");
                if (this.isDSLEnhanced) {
                    this.buf.append(">");
                }
                this.buf.append(variableName);
                ActionFieldValue value = fieldValues[i];
                if (value instanceof ActionFieldFunction) {
                    this.buf.append(".");
                    this.buf.append(value.field);
                } else {
                    this.buf.append(".set");
                    this.buf.append(Character.toUpperCase(fieldValues[i].field.charAt(0)));
                    this.buf.append(fieldValues[i].field.substring(1));
                }
                this.buf.append("( ");
                if (fieldValues[i].isFormula()) {
                    this.buf.append(fieldValues[i].value.substring(1));
                } else if (fieldValues[i].nature == 7L) {
                    this.buf.append("@{").append(fieldValues[i].value).append("}");
                } else if ("String".equals(fieldValues[i].type)) {
                    this.buf.append("\"");
                    this.buf.append(this.generateFieldValue(fieldValues[i]));
                    this.buf.append("\"");
                } else {
                    this.buf.append(this.generateFieldValue(fieldValues[i]));
                }
                this.buf.append(" );\n");
            }
        }

        private String generateFieldValue(ActionFieldValue fieldValue) {
            return fieldValue.value;
        }

        private void generateSetMethodCallsMethod(ActionCallMethod action, ActionFieldValue[] fieldValues) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append(action.variable);
            this.buf.append(".");
            this.buf.append(action.methodName);
            this.buf.append("(");
            boolean isFirst = true;
            for (int i = 0; i < fieldValues.length; ++i) {
                ActionFieldFunction valueFunction = (ActionFieldFunction)fieldValues[i];
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.buf.append(",");
                }
                this.buf.append(valueFunction.value);
            }
            this.buf.append(" );\n");
        }
    }

    public static class LHSPatternVisitor
    extends ReflectiveVisitor {
        private StringBuilder buf;
        private boolean isDSLEnhanced;

        public LHSPatternVisitor(boolean isDSLEnhanced, StringBuilder b) {
            this.isDSLEnhanced = isDSLEnhanced;
            this.buf = b;
        }

        public void visitFactPattern(FactPattern pattern) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.generateFactPattern(pattern);
            this.buf.append("\n");
        }

        public void visitFreeFormLine(FreeFormLine ffl) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append(ffl.text);
            this.buf.append("\n");
        }

        public void visitCompositeFactPattern(CompositeFactPattern pattern) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if ("exists".equals(pattern.type)) {
                this.renderCompositeFOL(pattern);
            } else if ("not".equals(pattern.type)) {
                this.renderCompositeFOL(pattern);
            } else if ("or".equals(pattern.type)) {
                this.buf.append("( ");
                if (pattern.patterns != null) {
                    for (int i = 0; i < pattern.patterns.length; ++i) {
                        if (i > 0) {
                            this.buf.append(" ");
                            this.buf.append(pattern.type);
                            this.buf.append(" ");
                        }
                        this.renderSubPattern(pattern, i);
                    }
                }
                this.buf.append(" )\n");
            }
        }

        public void visitFromCompositeFactPattern(FromCompositeFactPattern pattern) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (pattern.getFactPattern() != null) {
                this.generateFactPattern(pattern.getFactPattern());
            }
            this.buf.append(" from\n\t\t  ");
            this.renderExpression(pattern.getExpression());
            this.buf.append("\n");
        }

        public void visitFromCollectCompositeFactPattern(FromCollectCompositeFactPattern pattern) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (pattern.getFactPattern() != null) {
                this.generateFactPattern(pattern.getFactPattern());
            }
            this.buf.append(" from collect ( ");
            if (pattern.getRightPattern() != null) {
                if (pattern.getRightPattern() instanceof FactPattern) {
                    this.generateFactPattern((FactPattern)pattern.getRightPattern());
                } else if (pattern.getRightPattern() instanceof FromAccumulateCompositeFactPattern) {
                    this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)pattern.getRightPattern());
                } else if (pattern.getRightPattern() instanceof FromCollectCompositeFactPattern) {
                    this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)pattern.getRightPattern());
                } else if (pattern.getRightPattern() instanceof FromCompositeFactPattern) {
                    this.visitFromCompositeFactPattern((FromCompositeFactPattern)pattern.getRightPattern());
                } else if (pattern.getRightPattern() instanceof FreeFormLine) {
                    this.visitFreeFormLine((FreeFormLine)pattern.getRightPattern());
                } else {
                    throw new IllegalArgumentException("Unuported pattern " + pattern.getRightPattern() + " for FROM COLLECT");
                }
            }
            this.buf.append(") \n");
        }

        public void visitFromAccumulateCompositeFactPattern(FromAccumulateCompositeFactPattern pattern) {
            this.buf.append("\t\t");
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (pattern.getFactPattern() != null) {
                this.generateFactPattern(pattern.getFactPattern());
            }
            this.buf.append(" from accumulate ( ");
            if (pattern.getSourcePattern() != null) {
                if (pattern.getSourcePattern() instanceof FactPattern) {
                    this.generateFactPattern((FactPattern)pattern.getSourcePattern());
                } else if (pattern.getSourcePattern() instanceof FromAccumulateCompositeFactPattern) {
                    this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)pattern.getSourcePattern());
                } else if (pattern.getSourcePattern() instanceof FromCollectCompositeFactPattern) {
                    this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)pattern.getSourcePattern());
                } else if (pattern.getSourcePattern() instanceof FromCompositeFactPattern) {
                    this.visitFromCompositeFactPattern((FromCompositeFactPattern)pattern.getSourcePattern());
                } else {
                    throw new IllegalArgumentException("Unuported pattern " + pattern.getSourcePattern() + " for FROM ACCUMULATE");
                }
            }
            this.buf.append(",\n");
            if (pattern.useFunctionOrCode().equals("use_function")) {
                this.buf.append("\t\t\t");
                this.buf.append(pattern.getFunction());
            } else {
                this.buf.append("\t\t\tinit( ");
                this.buf.append(pattern.getInitCode());
                this.buf.append(" ),\n");
                this.buf.append("\t\t\taction( ");
                this.buf.append(pattern.getActionCode());
                this.buf.append(" ),\n");
                if (pattern.getReverseCode() != null && !pattern.getReverseCode().trim().equals("")) {
                    this.buf.append("\t\t\treverse( ");
                    this.buf.append(pattern.getReverseCode());
                    this.buf.append(" ),\n");
                }
                this.buf.append("\t\t\tresult( ");
                this.buf.append(pattern.getResultCode());
                this.buf.append(" )\n");
            }
            this.buf.append(") \n");
        }

        private void renderCompositeFOL(CompositeFactPattern pattern) {
            this.buf.append(pattern.type);
            if (pattern.patterns != null && pattern.patterns.length > 1) {
                this.buf.append(" (");
                for (int i = 0; i < pattern.patterns.length; ++i) {
                    this.renderSubPattern(pattern, i);
                    if (i == pattern.patterns.length - 1) continue;
                    this.buf.append(" and ");
                }
                this.buf.append(") \n");
            } else {
                this.buf.append(" ");
                this.renderSubPattern(pattern, 0);
                this.buf.append("\n");
            }
        }

        private void renderSubPattern(CompositeFactPattern pattern, int subIndex) {
            if (pattern.patterns == null || pattern.patterns.length == 0) {
                return;
            }
            this.generateFactPattern(pattern.patterns[subIndex]);
        }

        private void renderExpression(ExpressionFormLine expression) {
            this.buf.append(expression.getText());
        }

        public void visitDSLSentence(DSLSentence sentence) {
            this.buf.append("\t\t");
            this.buf.append(sentence);
            this.buf.append("\n");
        }

        private void generateFactPattern(FactPattern pattern) {
            if (pattern.boundName != null) {
                this.buf.append(pattern.boundName);
                this.buf.append(" : ");
            }
            if (pattern.factType != null) {
                this.buf.append(pattern.factType);
            }
            this.buf.append("( ");
            if (pattern.constraintList != null) {
                this.generateConstraints(pattern);
            }
            this.buf.append(")");
        }

        private void generateConstraints(FactPattern pattern) {
            int printedCount = 0;
            for (int i = 0; i < pattern.getFieldConstraints().length; ++i) {
                StringBuilder buffer = new StringBuilder();
                this.generateConstraint(pattern.constraintList.constraints[i], false, buffer);
                if (buffer.length() <= 0) continue;
                if (printedCount > 0) {
                    this.buf.append(", ");
                }
                this.buf.append((CharSequence)buffer);
                ++printedCount;
            }
        }

        private void generateConstraint(FieldConstraint con, boolean nested, StringBuilder buf) {
            if (con instanceof CompositeFieldConstraint) {
                FieldConstraint[] nestedConstraints;
                CompositeFieldConstraint cfc = (CompositeFieldConstraint)con;
                if (nested) {
                    buf.append("( ");
                }
                if ((nestedConstraints = cfc.constraints) != null) {
                    for (int i = 0; i < nestedConstraints.length; ++i) {
                        this.generateConstraint(nestedConstraints[i], true, buf);
                        if (i >= nestedConstraints.length - 1) continue;
                        buf.append(cfc.compositeJunctionType + " ");
                    }
                }
                if (nested) {
                    buf.append(")");
                }
            } else {
                this.generateSingleFieldConstraint((SingleFieldConstraint)con, buf);
            }
        }

        private void generateSingleFieldConstraint(SingleFieldConstraint constr, StringBuilder buf) {
            if (constr.getConstraintValueType() == 5) {
                buf.append("eval( ");
                buf.append(constr.getValue());
                buf.append(" )");
            } else {
                if (constr.getFieldBinding() != null) {
                    buf.append(constr.getFieldBinding());
                    buf.append(" : ");
                }
                if (constr.getOperator() != null && constr.getValue() != null || constr.getFieldBinding() != null || constr.getConstraintValueType() == 6 || constr instanceof SingleFieldConstraintEBLeftSide) {
                    StringBuilder parentBuf = new StringBuilder();
                    for (SingleFieldConstraint parent = (SingleFieldConstraint)constr.getParent(); parent != null; parent = (SingleFieldConstraint)parent.getParent()) {
                        parentBuf.insert(0, parent.getFieldName() + ".");
                    }
                    buf.append((CharSequence)parentBuf);
                    if (constr instanceof SingleFieldConstraintEBLeftSide) {
                        buf.append(((SingleFieldConstraintEBLeftSide)constr).getExpressionLeftSide().getText());
                    } else {
                        buf.append(constr.getFieldName());
                    }
                }
                this.addFieldRestriction(buf, constr.getConstraintValueType(), constr.getOperator(), constr.getValue(), constr.getExpressionValue());
                if (constr.connectives != null) {
                    for (int j = 0; j < constr.connectives.length; ++j) {
                        ConnectiveConstraint conn = constr.connectives[j];
                        this.addFieldRestriction(buf, conn.getConstraintValueType(), conn.operator, conn.getValue(), null);
                    }
                }
            }
        }

        private void addFieldRestriction(StringBuilder buf, int type, String operator, String value, ExpressionFormLine expression) {
            if (operator == null) {
                return;
            }
            buf.append(" ");
            buf.append(operator);
            buf.append(" ");
            switch (type) {
                case 3: {
                    buf.append("( ");
                    buf.append(value);
                    buf.append(" )");
                    break;
                }
                case 1: {
                    if (operator.equals("in")) {
                        buf.append(value);
                        break;
                    }
                    buf.append('\"');
                    buf.append(value);
                    buf.append('\"');
                    break;
                }
                case 6: {
                    if (expression == null) break;
                    buf.append(expression.getText());
                    break;
                }
                case 7: {
                    buf.append("@{").append(value).append("}");
                    break;
                }
                default: {
                    buf.append(value);
                }
            }
            buf.append(" ");
        }
    }
}

