/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.util.test;

import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.pokersource.util.ValueSortedMap;

public class ValueSortedMapTest
extends TestCase {
    ValueSortedMap vsm1;

    public ValueSortedMapTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(ValueSortedMapTest.class);
    }

    public void setUp() {
        this.vsm1 = new ValueSortedMap();
        this.vsm1.put("A", new Double(80.0));
        this.vsm1.put("B", new Double(70.0));
        this.vsm1.put("C", new Double(30.0));
        this.vsm1.put("D", new Double(40.0));
        this.vsm1.put("E", new Double(40.0));
        this.vsm1.put("F", new Double(40.0));
    }

    public void testKeyList() {
        List list = this.vsm1.keyList();
        ValueSortedMapTest.assertEquals((int)6, (int)list.size());
        ValueSortedMapTest.assertEquals((Object)"C", list.get(0));
        ValueSortedMapTest.assertEquals((Object)"D", list.get(1));
        ValueSortedMapTest.assertEquals((Object)"E", list.get(2));
        ValueSortedMapTest.assertEquals((Object)"F", list.get(3));
        ValueSortedMapTest.assertEquals((Object)"B", list.get(4));
        ValueSortedMapTest.assertEquals((Object)"A", list.get(5));
    }

    public void testLess() {
        List list = this.vsm1.less(new Double(40.0));
        ValueSortedMapTest.assertEquals((int)1, (int)list.size());
        ValueSortedMapTest.assertEquals((Object)"C", list.get(0));
        list = this.vsm1.less(new Double(41.0));
        ValueSortedMapTest.assertEquals((int)4, (int)list.size());
        ValueSortedMapTest.assertEquals((Object)"C", list.get(0));
        ValueSortedMapTest.assertEquals((Object)"D", list.get(1));
        ValueSortedMapTest.assertEquals((Object)"E", list.get(2));
        ValueSortedMapTest.assertEquals((Object)"F", list.get(3));
    }

    public void testLessEqual() {
        List list = this.vsm1.lessEqual(new Double(39.0));
        ValueSortedMapTest.assertEquals((int)1, (int)list.size());
        ValueSortedMapTest.assertEquals((Object)"C", list.get(0));
        list = this.vsm1.lessEqual(new Double(40.0));
        ValueSortedMapTest.assertEquals((int)4, (int)list.size());
        ValueSortedMapTest.assertEquals((Object)"C", list.get(0));
        ValueSortedMapTest.assertEquals((Object)"D", list.get(1));
        ValueSortedMapTest.assertEquals((Object)"E", list.get(2));
        ValueSortedMapTest.assertEquals((Object)"F", list.get(3));
    }

    public void testGreater() {
        List list = this.vsm1.greater(new Double(39.0));
        ValueSortedMapTest.assertEquals((int)5, (int)list.size());
        ValueSortedMapTest.assertEquals((Object)"D", list.get(0));
        ValueSortedMapTest.assertEquals((Object)"E", list.get(1));
        ValueSortedMapTest.assertEquals((Object)"F", list.get(2));
        ValueSortedMapTest.assertEquals((Object)"B", list.get(3));
        ValueSortedMapTest.assertEquals((Object)"A", list.get(4));
        list = this.vsm1.greater(new Double(40.0));
        ValueSortedMapTest.assertEquals((int)2, (int)list.size());
        ValueSortedMapTest.assertEquals((Object)"B", list.get(0));
        ValueSortedMapTest.assertEquals((Object)"A", list.get(1));
    }

    public void testGreaterEqual() {
        List list = this.vsm1.greaterEqual(new Double(40.0));
        ValueSortedMapTest.assertEquals((int)5, (int)list.size());
        ValueSortedMapTest.assertEquals((Object)"D", list.get(0));
        ValueSortedMapTest.assertEquals((Object)"E", list.get(1));
        ValueSortedMapTest.assertEquals((Object)"F", list.get(2));
        ValueSortedMapTest.assertEquals((Object)"B", list.get(3));
        ValueSortedMapTest.assertEquals((Object)"A", list.get(4));
        list = this.vsm1.greaterEqual(new Double(41.0));
        ValueSortedMapTest.assertEquals((int)2, (int)list.size());
        ValueSortedMapTest.assertEquals((Object)"B", list.get(0));
        ValueSortedMapTest.assertEquals((Object)"A", list.get(1));
    }

    public void testToString() {
        ValueSortedMapTest.assertEquals((Object)"C:30.0 D:40.0 E:40.0 F:40.0 B:70.0 A:80.0", (Object)this.vsm1.toString());
    }
}

