/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;

public class ValueSortedMap {
    private HashMap values = new HashMap();

    public void put(Object object, Comparable comparable) {
        this.values.put(object, new ValueEntry(object, comparable));
    }

    public Comparable get(Object object) {
        ValueEntry valueEntry = (ValueEntry)this.values.get(object);
        return valueEntry.value;
    }

    private List toKeyList(List list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ValueEntry valueEntry = (ValueEntry)list.get(i);
            arrayList.add(i, valueEntry.key);
        }
        return arrayList;
    }

    public List keyList() {
        ArrayList arrayList = new ArrayList(this.values.values());
        Collections.sort(arrayList);
        return this.toKeyList(arrayList);
    }

    public List less(Comparable comparable) {
        ValueEntry valueEntry;
        ArrayList arrayList = new ArrayList(this.values.values());
        Collections.sort(arrayList);
        ValueEntry valueEntry2 = new ValueEntry(null, comparable);
        int n = 0;
        for (int i = 0; i < arrayList.size() && (valueEntry = (ValueEntry)arrayList.get(i)).compareTo(valueEntry2) < 0; ++i) {
            ++n;
        }
        return this.toKeyList(arrayList.subList(0, n));
    }

    public List lessEqual(Comparable comparable) {
        ValueEntry valueEntry;
        ArrayList arrayList = new ArrayList(this.values.values());
        Collections.sort(arrayList);
        ValueEntry valueEntry2 = new ValueEntry(null, comparable);
        int n = 0;
        for (int i = 0; i < arrayList.size() && (valueEntry = (ValueEntry)arrayList.get(i)).compareTo(valueEntry2) <= 0; ++i) {
            ++n;
        }
        return this.toKeyList(arrayList.subList(0, n));
    }

    public List greater(Comparable comparable) {
        ValueEntry valueEntry;
        ArrayList arrayList = new ArrayList(this.values.values());
        Collections.sort(arrayList);
        ValueEntry valueEntry2 = new ValueEntry(null, comparable);
        int n = arrayList.size();
        for (int i = arrayList.size() - 1; i >= 0 && (valueEntry = (ValueEntry)arrayList.get(i)).compareTo(valueEntry2) > 0; --i) {
            --n;
        }
        return this.toKeyList(arrayList.subList(n, arrayList.size()));
    }

    public List greaterEqual(Comparable comparable) {
        ValueEntry valueEntry;
        ArrayList arrayList = new ArrayList(this.values.values());
        Collections.sort(arrayList);
        ValueEntry valueEntry2 = new ValueEntry(null, comparable);
        int n = arrayList.size();
        for (int i = arrayList.size() - 1; i >= 0 && (valueEntry = (ValueEntry)arrayList.get(i)).compareTo(valueEntry2) >= 0; --i) {
            --n;
        }
        return this.toKeyList(arrayList.subList(n, arrayList.size()));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        TreeSet treeSet = new TreeSet(this.values.values());
        for (ValueEntry valueEntry : treeSet) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(valueEntry.key + ":" + valueEntry.value);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        int n;
        ValueSortedMap valueSortedMap = new ValueSortedMap();
        valueSortedMap.put("A", new Double(80.0));
        valueSortedMap.put("B", new Double(70.0));
        valueSortedMap.put("C", new Double(30.0));
        valueSortedMap.put("D", new Double(10.0));
        System.out.println("ValueSortedMap = [" + valueSortedMap + "]");
        List list = valueSortedMap.less(new Double(30.0));
        Object[] objectArray = list.toArray();
        System.out.print("Groups scoring <  30: ");
        for (n = 0; n < objectArray.length; ++n) {
            System.out.print(objectArray[n] + " ");
        }
        System.out.println();
        list = valueSortedMap.greaterEqual(new Double(30.0));
        objectArray = list.toArray();
        System.out.print("Groups scoring >= 30: ");
        for (n = 0; n < objectArray.length; ++n) {
            System.out.print(objectArray[n] + " ");
        }
        System.out.println();
    }

    private static class ValueEntry
    implements Comparable {
        public Object key;
        public Comparable value;

        public ValueEntry(Object object, Comparable comparable) {
            this.key = object;
            this.value = comparable;
        }

        public int compareTo(Object object) {
            ValueEntry valueEntry = (ValueEntry)object;
            int n = this.value.compareTo(valueEntry.value);
            if (n == 0 && this.key != null && valueEntry.key != null) {
                int n2;
                int n3;
                n = this.key.getClass() == valueEntry.key.getClass() && this.key instanceof Comparable && valueEntry.key instanceof Comparable ? ((Comparable)this.key).compareTo(valueEntry.key) : ((n3 = this.key.hashCode()) < (n2 = valueEntry.key.hashCode()) ? -1 : (n3 > n2 ? 1 : 0));
            }
            return n;
        }
    }
}

