/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.util;

import java.util.Enumeration;
import java.util.Random;

public class NestedLoopSampling
implements Enumeration {
    private int nsamples;
    private int[] elem;
    private int[] limits;
    private Random rand;

    public NestedLoopSampling(int[] nArray, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("nsamples must be positive");
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] > 0) continue;
            throw new IllegalArgumentException("limits must be positive");
        }
        this.nsamples = n;
        this.limits = nArray;
        this.elem = new int[nArray.length];
        this.rand = new Random();
    }

    public NestedLoopSampling(int[] nArray) {
        this(nArray, Integer.MAX_VALUE);
    }

    @Override
    public boolean hasMoreElements() {
        return this.nsamples > 0;
    }

    public Object nextElement() {
        if (this.nsamples == 0) {
            return null;
        }
        for (int i = 0; i < this.limits.length; ++i) {
            this.elem[i] = this.rand.nextInt(this.limits[i]);
        }
        --this.nsamples;
        return this.elem;
    }
}

