/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.util;

import java.util.Arrays;

public class LongArray
implements Comparable {
    public long[] values;
    private int hash;

    public LongArray(long[] lArray) {
        this.values = (long[])lArray.clone();
        this.computeHash();
    }

    private void computeHash() {
        this.hash = this.values.length;
        for (int i = 0; i < this.values.length && i < 32; ++i) {
            this.hash = 31 * this.hash + (int)(this.values[i] ^ this.values[i] >>> 32);
        }
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        LongArray longArray = (LongArray)object;
        return Arrays.equals(this.values, longArray.values);
    }

    public int compareTo(Object object) {
        LongArray longArray = (LongArray)object;
        for (int i = 0; i < this.values.length; ++i) {
            if (i >= longArray.values.length) {
                return 1;
            }
            if (this.values[i] < longArray.values[i]) {
                return -1;
            }
            if (this.values[i] <= longArray.values[i]) continue;
            return 1;
        }
        if (this.values.length < longArray.values.length) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.values[i]);
        }
        return stringBuffer.toString();
    }
}

