/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.util;

import java.util.Arrays;

public class IntArray
implements Comparable {
    public int[] values;
    private int hash;

    public IntArray(int[] nArray) {
        this.values = (int[])nArray.clone();
        this.computeHash();
    }

    private void computeHash() {
        this.hash = this.values.length;
        for (int i = 0; i < this.values.length && i < 32; ++i) {
            this.hash = 31 * this.hash + this.values[i];
        }
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        IntArray intArray = (IntArray)object;
        return Arrays.equals(this.values, intArray.values);
    }

    public int compareTo(Object object) {
        IntArray intArray = (IntArray)object;
        for (int i = 0; i < this.values.length; ++i) {
            if (i >= intArray.values.length) {
                return 1;
            }
            if (this.values[i] < intArray.values[i]) {
                return -1;
            }
            if (this.values[i] <= intArray.values[i]) continue;
            return 1;
        }
        if (this.values.length < intArray.values.length) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.values.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(this.values[i]);
        }
        return stringBuffer.toString();
    }
}

