/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.game.test;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.pokersource.game.Deck;

public class DeckTest
extends TestCase {
    private int indexAs;
    private int indexAh;
    private int indexAd;
    private int indexAc;
    private int index2s;
    private int index2h;
    private int index2d;
    private int index2c;
    private int indexJoker;
    private long maskAs;
    private long maskAh;
    private long maskAd;
    private long maskAc;
    private long mask2s;
    private long mask2h;
    private long mask2d;
    private long mask2c;
    private long maskJoker;

    public DeckTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(DeckTest.class);
    }

    protected void setUp() {
        this.indexAs = 51;
        this.indexAh = 12;
        this.indexAd = 25;
        this.indexAc = 38;
        this.index2s = 39;
        this.index2h = 0;
        this.index2d = 13;
        this.index2c = 26;
        this.maskAs = 1L << this.indexAs;
        this.maskAh = 1L << this.indexAh;
        this.maskAd = 1L << this.indexAd;
        this.maskAc = 1L << this.indexAc;
        this.mask2s = 1L << this.index2s;
        this.mask2h = 1L << this.index2h;
        this.mask2d = 1L << this.index2d;
        this.mask2c = 1L << this.index2c;
        this.indexJoker = 52;
        this.maskJoker = 1L << this.indexJoker;
    }

    public void testCreateCardIndex() {
        DeckTest.assertEquals((int)this.index2s, (int)Deck.createCardIndex(Deck.RANK_2, Deck.SUIT_SPADES));
        DeckTest.assertEquals((int)this.index2h, (int)Deck.createCardIndex(Deck.RANK_2, Deck.SUIT_HEARTS));
        DeckTest.assertEquals((int)this.index2d, (int)Deck.createCardIndex(Deck.RANK_2, Deck.SUIT_DIAMONDS));
        DeckTest.assertEquals((int)this.index2c, (int)Deck.createCardIndex(Deck.RANK_2, Deck.SUIT_CLUBS));
        DeckTest.assertEquals((int)this.indexAs, (int)Deck.createCardIndex(Deck.RANK_ACE, Deck.SUIT_SPADES));
        DeckTest.assertEquals((int)this.indexAh, (int)Deck.createCardIndex(Deck.RANK_ACE, Deck.SUIT_HEARTS));
        DeckTest.assertEquals((int)this.indexAd, (int)Deck.createCardIndex(Deck.RANK_ACE, Deck.SUIT_DIAMONDS));
        DeckTest.assertEquals((int)this.indexAc, (int)Deck.createCardIndex(Deck.RANK_ACE, Deck.SUIT_CLUBS));
        DeckTest.assertEquals((int)this.indexJoker, (int)Deck.createCardIndex(Deck.RANK_JOKER, Deck.SUIT_JOKER));
        try {
            Deck.createCardIndex(Deck.RANK_COUNT, Deck.SUIT_SPADES);
            DeckTest.fail((String)"Should raise IllegalArgumentException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            Deck.createCardIndex(Deck.RANK_2, Deck.SUIT_COUNT);
            DeckTest.fail((String)"Should raise IllegalArgumentException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            Deck.createCardIndex(Deck.RANK_JOKER, Deck.SUIT_SPADES);
            DeckTest.fail((String)"Should raise IllegalArgumentException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            Deck.createCardIndex(Deck.RANK_2, Deck.SUIT_JOKER);
            DeckTest.fail((String)"Should raise IllegalArgumentException");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testCreateCardMask() {
        DeckTest.assertEquals((long)this.maskAs, (long)Deck.createCardMask(Deck.RANK_ACE, Deck.SUIT_SPADES));
        DeckTest.assertEquals((long)this.maskJoker, (long)Deck.createCardMask(Deck.RANK_JOKER, Deck.SUIT_JOKER));
        int[] nArray = new int[]{Deck.RANK_ACE, Deck.RANK_ACE, Deck.RANK_2};
        int[] nArray2 = new int[]{Deck.SUIT_SPADES, Deck.SUIT_HEARTS, Deck.SUIT_HEARTS};
        long l = Deck.createCardMask(nArray, nArray2);
        long l2 = this.maskAs | this.maskAh | this.mask2h;
        DeckTest.assertEquals((long)l2, (long)l);
    }

    public void testParseCardMask() {
        long l = Deck.parseCardMask("As Ah 2h");
        long l2 = this.maskAs | this.maskAh | this.mask2h;
        DeckTest.assertEquals((long)l2, (long)l);
    }

    public void testCardString() {
        DeckTest.assertEquals((Object)"Td", (Object)Deck.cardString(Deck.RANK_TEN, Deck.SUIT_DIAMONDS));
        DeckTest.assertEquals((Object)"Xx", (Object)Deck.cardString(Deck.RANK_JOKER, Deck.SUIT_JOKER));
    }

    public void testParseRank() {
        DeckTest.assertEquals((int)Deck.RANK_ACE, (int)Deck.parseRank("A"));
        DeckTest.assertEquals((int)Deck.RANK_TEN, (int)Deck.parseRank("T"));
        DeckTest.assertEquals((int)Deck.RANK_2, (int)Deck.parseRank("2"));
        DeckTest.assertEquals((int)Deck.RANK_JOKER, (int)Deck.parseRank("X"));
    }

    public void testParseSuit() {
        DeckTest.assertEquals((int)Deck.SUIT_SPADES, (int)Deck.parseSuit("s"));
        DeckTest.assertEquals((int)Deck.SUIT_HEARTS, (int)Deck.parseSuit("h"));
        DeckTest.assertEquals((int)Deck.SUIT_DIAMONDS, (int)Deck.parseSuit("d"));
        DeckTest.assertEquals((int)Deck.SUIT_CLUBS, (int)Deck.parseSuit("c"));
    }

    public void testCardMaskString() {
        long l = this.maskAs | this.maskAh | this.mask2h;
        DeckTest.assertEquals((Object)"As Ah 2h", (Object)Deck.cardMaskString(l));
        DeckTest.assertEquals((Object)"AsAh2h", (Object)Deck.cardMaskString(l, ""));
        DeckTest.assertEquals((Object)"As Ah 2h", (Object)Deck.cardMaskString(l, " "));
        DeckTest.assertEquals((Object)"As/Ah/2h", (Object)Deck.cardMaskString(l, "/"));
    }
}

