/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.game;

public class Deck {
    public static int SUIT_HEARTS = 0;
    public static int SUIT_DIAMONDS = 1;
    public static int SUIT_CLUBS = 2;
    public static int SUIT_SPADES = 3;
    public static int SUIT_COUNT = 4;
    public static int RANK_2 = 0;
    public static int RANK_3 = 1;
    public static int RANK_4 = 2;
    public static int RANK_5 = 3;
    public static int RANK_6 = 4;
    public static int RANK_7 = 5;
    public static int RANK_8 = 6;
    public static int RANK_9 = 7;
    public static int RANK_TEN = 8;
    public static int RANK_JACK = 9;
    public static int RANK_QUEEN = 10;
    public static int RANK_KING = 11;
    public static int RANK_ACE = 12;
    public static int RANK_COUNT = 13;
    public static int RANK_JOKER = 13;
    public static int SUIT_JOKER = 4;
    private static String rankString = "23456789TJQKAX";
    private static String suitString = "hdcsx";

    private Deck() {
    }

    public static int createCardIndex(int n, int n2) {
        if (n >= 0 && n < RANK_COUNT && n2 >= 0 && n2 < SUIT_COUNT) {
            return RANK_COUNT * n2 + n;
        }
        if (n == RANK_JOKER && n2 == SUIT_JOKER) {
            return RANK_COUNT * SUIT_COUNT;
        }
        throw new IllegalArgumentException("unknown rank and suit combination");
    }

    public static long createCardMask(int n, int n2) {
        return 1L << Deck.createCardIndex(n, n2);
    }

    public static long createCardMask(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("ranks and suits must be same length");
        }
        long l = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            l |= Deck.createCardMask(nArray[i], nArray2[i]);
        }
        return l;
    }

    public static long parseCardMask(String string) {
        if (string.equalsIgnoreCase("nil")) {
            return 0L;
        }
        boolean bl = false;
        long l = 0L;
        int n = 0;
        while (n < string.length()) {
            while (n < string.length() && string.charAt(n) == ' ') {
                ++n;
            }
            if (n >= string.length()) continue;
            int n2 = Deck.parseRank(string.substring(n, n + 1));
            int n3 = Deck.parseSuit(string.substring(n + 1, n + 2));
            l |= Deck.createCardMask(n2, n3);
            n += 2;
        }
        return l;
    }

    public static String cardString(int n, int n2) {
        if (!(n >= 0 && n < RANK_COUNT && n2 >= 0 && n2 < SUIT_COUNT || n == RANK_JOKER && n2 == SUIT_JOKER)) {
            throw new IllegalArgumentException("unknown rank and suit combination");
        }
        if (n == RANK_JOKER) {
            n2 = SUIT_JOKER;
        }
        return rankString.substring(n, n + 1) + suitString.substring(n2, n2 + 1);
    }

    public static int parseRank(String string) {
        int n = rankString.indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("unable to parse rank: " + string);
        }
        return n;
    }

    public static int parseSuit(String string) {
        int n = suitString.indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("unable to parse suit: " + string);
        }
        return n;
    }

    public static String rankString(int n) {
        return rankString.substring(n, n + 1);
    }

    public static String suitString(int n) {
        return suitString.substring(n, n + 1);
    }

    public static String cardMaskString(long l, String string) {
        if (l == 0L) {
            return "nil";
        }
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = Deck.createCardMask(RANK_JOKER, SUIT_JOKER);
        if ((l & l2) != 0L) {
            stringBuffer.append(Deck.cardString(RANK_JOKER, SUIT_JOKER));
        }
        for (int i = RANK_COUNT - 1; i >= 0; --i) {
            for (int j = SUIT_COUNT - 1; j >= 0; --j) {
                l2 = Deck.createCardMask(i, j);
                if ((l & l2) == 0L) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(string);
                }
                stringBuffer.append(Deck.cardString(i, j));
            }
        }
        return stringBuffer.toString();
    }

    public static String cardMaskString(long l) {
        return Deck.cardMaskString(l, " ");
    }

    public static int numCards(long l) {
        int n = 0;
        for (int i = 0; i <= RANK_COUNT * SUIT_COUNT; ++i) {
            if ((l & 1L << i) == 0L) continue;
            ++n;
        }
        return n;
    }
}

