/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate.test;

import java.util.HashMap;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.pokersource.enumerate.BeliefVector;
import org.pokersource.enumerate.Enumerate;
import org.pokersource.enumerate.HoldemBeliefVector;
import org.pokersource.enumerate.MatchupOutcome;
import org.pokersource.enumerate.RankOrdering;
import org.pokersource.enumerate.SAIE;
import org.pokersource.game.Deck;

public class SAIETest
extends TestCase {
    private HoldemBeliefVector bv1;
    private HoldemBeliefVector bv2;
    private HoldemBeliefVector bv3;
    private HoldemBeliefVector bv4;
    private HoldemBeliefVector bv5;
    private long mask5h4h3d;

    public SAIETest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(SAIETest.class);
    }

    protected void setUp() {
        this.bv1 = new HoldemBeliefVector("KhQc");
        this.bv2 = new HoldemBeliefVector("SM1 SM2 SM3");
        this.bv3 = new HoldemBeliefVector("SM1 SM2 SM3 SM4 SM5");
        this.bv4 = new HoldemBeliefVector("TdTc");
        this.bv5 = new HoldemBeliefVector("65s");
        this.mask5h4h3d = Deck.parseCardMask("5h 4h 3d");
    }

    public void checkEV(double[] dArray, HashMap hashMap) {
        double[] dArray2 = new double[dArray.length];
        double d = 0.0;
        for (MatchupOutcome matchupOutcome : hashMap.values()) {
            for (int i = 0; i < dArray.length; ++i) {
                int n = i;
                dArray2[n] = dArray2[n] + matchupOutcome.matchEV[i] * matchupOutcome.matchProb;
            }
            d += matchupOutcome.matchProb;
        }
        SAIETest.assertEquals((double)1.0, (double)d, (double)1.0E-10);
        for (int i = 0; i < dArray.length; ++i) {
            int n = i;
            dArray2[n] = dArray2[n] / d;
            SAIETest.assertEquals((double)dArray2[i], (double)dArray[i], (double)1.0E-10);
        }
    }

    public void testFlopGameSAIE() {
        double[] dArray = new double[2];
        SAIE.FlopGameSAIE(Enumerate.GAME_HOLDEM, 0, 0, new BeliefVector[]{this.bv1, this.bv2}, this.mask5h4h3d, 0L, dArray, null, null);
        SAIETest.assertEquals((double)0.279634179634, (double)dArray[0], (double)1.0E-10);
        SAIETest.assertEquals((double)0.720365820366, (double)dArray[1], (double)1.0E-10);
        SAIE.FlopGameSAIE(Enumerate.GAME_HOLDEM, 0, 0, new BeliefVector[]{this.bv1, this.bv3}, this.mask5h4h3d, 0L, dArray, null, null);
        SAIETest.assertEquals((double)0.416602297485, (double)dArray[0], (double)1.0E-10);
        SAIETest.assertEquals((double)0.583397702515, (double)dArray[1], (double)1.0E-10);
        SAIE.FlopGameSAIE(Enumerate.GAME_HOLDEM, 0, 0, new BeliefVector[]{this.bv1, this.bv4}, Deck.parseCardMask("QhJhThTs"), 0L, dArray, null, null);
        SAIETest.assertEquals((double)0.045454545454545456, (double)dArray[0], (double)1.0E-10);
        SAIETest.assertEquals((double)0.9545454545454546, (double)dArray[1], (double)1.0E-10);
        SAIE.FlopGameSAIE(Enumerate.GAME_HOLDEM, 0, 0, new BeliefVector[]{this.bv1, this.bv4}, Deck.parseCardMask("QhThTs"), 0L, dArray, null, null);
        SAIETest.assertEquals((double)0.0030303030303030303, (double)dArray[0], (double)1.0E-10);
        SAIETest.assertEquals((double)0.996969696969697, (double)dArray[1], (double)1.0E-10);
    }

    public void testFlopGameSAIE_Matchup() {
        double[] dArray = new double[2];
        HashMap hashMap = new HashMap();
        SAIE.FlopGameSAIE(Enumerate.GAME_HOLDEM, 0, 0, new BeliefVector[]{this.bv1, this.bv4}, this.mask5h4h3d, 0L, dArray, hashMap, null);
        SAIETest.assertEquals((double)0.298484848485, (double)dArray[0], (double)1.0E-10);
        SAIETest.assertEquals((double)0.701515151515, (double)dArray[1], (double)1.0E-10);
        SAIETest.assertEquals((int)1, (int)hashMap.size());
        this.checkEV(dArray, hashMap);
        SAIE.FlopGameSAIE(Enumerate.GAME_HOLDEM, 0, 0, new BeliefVector[]{this.bv1, this.bv2}, this.mask5h4h3d, 0L, dArray, hashMap, null);
        SAIETest.assertEquals((double)0.279634179634, (double)dArray[0], (double)1.0E-10);
        SAIETest.assertEquals((double)0.720365820366, (double)dArray[1], (double)1.0E-10);
        SAIETest.assertEquals((int)74, (int)hashMap.size());
        this.checkEV(dArray, hashMap);
    }

    public void testFlopGameSAIE_Orderings() {
        double[] dArray = new double[2];
        HashMap hashMap = new HashMap();
        SAIE.FlopGameSAIE(Enumerate.GAME_HOLDEM, 0, 0, new BeliefVector[]{this.bv1, this.bv5}, this.mask5h4h3d, 0L, dArray, null, hashMap);
        SAIETest.assertEquals((double)0.218855218855, (double)dArray[0], (double)1.0E-10);
        SAIETest.assertEquals((double)0.781144781145, (double)dArray[1], (double)1.0E-10);
        SAIETest.assertEquals((int)3, (int)hashMap.size());
        RankOrdering rankOrdering = new RankOrdering(new int[]{0, 0});
        Integer n = (Integer)hashMap.get(rankOrdering);
        SAIETest.assertEquals((int)66, (int)n);
        rankOrdering = new RankOrdering(new int[]{0, 1});
        n = (Integer)hashMap.get(rankOrdering);
        SAIETest.assertEquals((int)617, (int)n);
        rankOrdering = new RankOrdering(new int[]{1, 0});
        n = (Integer)hashMap.get(rankOrdering);
        SAIETest.assertEquals((int)2287, (int)n);
    }

    public void testFlopGameSAIE_Sampling() {
        double[] dArray = new double[2];
        HashMap hashMap = new HashMap();
        int n = 0;
        int n2 = 0;
        SAIE.FlopGameSAIE(Enumerate.GAME_HOLDEM, n, n2, new BeliefVector[]{this.bv5, this.bv2}, this.mask5h4h3d, 0L, dArray, hashMap, null);
        SAIETest.assertEquals((double)0.640960327917, (double)dArray[0], (double)1.0E-10);
        SAIETest.assertEquals((double)0.359039672083, (double)dArray[1], (double)1.0E-10);
        SAIETest.assertEquals((int)276, (int)hashMap.size());
        this.checkEV(dArray, hashMap);
        n = 100;
        n2 = 0;
        SAIE.FlopGameSAIE(Enumerate.GAME_HOLDEM, n, n2, new BeliefVector[]{this.bv5, this.bv2}, this.mask5h4h3d, 0L, dArray, hashMap, null);
        SAIETest.assertEquals((double)0.640960327917, (double)dArray[0], (double)0.07);
        SAIETest.assertEquals((double)0.359039672083, (double)dArray[1], (double)0.07);
        SAIETest.assertTrue((hashMap.size() <= n ? 1 : 0) != 0);
        this.checkEV(dArray, hashMap);
        n = 0;
        n2 = 100;
        SAIE.FlopGameSAIE(Enumerate.GAME_HOLDEM, n, n2, new BeliefVector[]{this.bv5, this.bv2}, this.mask5h4h3d, 0L, dArray, hashMap, null);
        SAIETest.assertEquals((double)0.640960327917, (double)dArray[0], (double)0.07);
        SAIETest.assertEquals((double)0.359039672083, (double)dArray[1], (double)0.07);
        SAIETest.assertEquals((int)276, (int)hashMap.size());
        this.checkEV(dArray, hashMap);
        n = 100;
        n2 = 100;
        SAIE.FlopGameSAIE(Enumerate.GAME_HOLDEM, n, n2, new BeliefVector[]{this.bv5, this.bv2}, this.mask5h4h3d, 0L, dArray, hashMap, null);
        SAIETest.assertEquals((double)0.640960327917, (double)dArray[0], (double)0.07);
        SAIETest.assertEquals((double)0.359039672083, (double)dArray[1], (double)0.07);
        SAIETest.assertTrue((hashMap.size() <= n ? 1 : 0) != 0);
        this.checkEV(dArray, hashMap);
    }

    public void testFlopGameSAIE_Multiway() {
        double[] dArray = new double[4];
        HashMap hashMap = new HashMap();
        int n = 1000;
        int n2 = 0;
        SAIE.FlopGameSAIE(Enumerate.GAME_HOLDEM, n, n2, new BeliefVector[]{this.bv1, this.bv2, this.bv3, this.bv5}, this.mask5h4h3d, 0L, dArray, hashMap, null);
        SAIETest.assertEquals((double)0.12, (double)dArray[0], (double)0.02);
        SAIETest.assertEquals((double)0.2, (double)dArray[1], (double)0.02);
        SAIETest.assertEquals((double)0.19, (double)dArray[2], (double)0.02);
        SAIETest.assertEquals((double)0.49, (double)dArray[3], (double)0.05);
        this.checkEV(dArray, hashMap);
    }
}

