/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate.test;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.pokersource.enumerate.HoldemHandGroup;
import org.pokersource.enumerate.HoldemHandGroupFactory;
import org.pokersource.enumerate.HoldemHandOrdering;
import org.pokersource.enumerate.ThresholdHandGroup;
import org.pokersource.game.Deck;

public class HoldemThresholdGroupTest
extends TestCase {
    HoldemHandGroup ht1;

    public HoldemThresholdGroupTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(HoldemThresholdGroupTest.class);
    }

    protected void setUp() {
        try {
            HoldemHandOrdering holdemHandOrdering = new HoldemHandOrdering("sample1.hho");
            ThresholdHandGroup.registerHandValuation("SAMPLE1", holdemHandOrdering);
            this.ht1 = HoldemHandGroupFactory.getInstance("SAMPLE1>0.95");
        }
        catch (Exception exception) {
            HoldemThresholdGroupTest.fail((String)("exception " + exception));
        }
    }

    public void testToString() {
        HoldemThresholdGroupTest.assertEquals((Object)"SAMPLE1>0.95", (Object)this.ht1.toString());
    }

    public void testIsHandInGroup() {
        HoldemThresholdGroupTest.assertTrue((!this.ht1.isHandInGroup(Deck.parseCardMask("6h6d")) ? 1 : 0) != 0);
        HoldemThresholdGroupTest.assertTrue((!this.ht1.isHandInGroup(Deck.parseCardMask("AhKd")) ? 1 : 0) != 0);
        HoldemThresholdGroupTest.assertTrue((!this.ht1.isHandInGroup(Deck.parseCardMask("KcQc")) ? 1 : 0) != 0);
        HoldemThresholdGroupTest.assertTrue((boolean)this.ht1.isHandInGroup(Deck.parseCardMask("AhJh")));
        HoldemThresholdGroupTest.assertTrue((boolean)this.ht1.isHandInGroup(Deck.parseCardMask("AhQh")));
        HoldemThresholdGroupTest.assertTrue((boolean)this.ht1.isHandInGroup(Deck.parseCardMask("7s7d")));
        HoldemThresholdGroupTest.assertTrue((boolean)this.ht1.isHandInGroup(Deck.parseCardMask("AsKs")));
        HoldemThresholdGroupTest.assertTrue((boolean)this.ht1.isHandInGroup(Deck.parseCardMask("8s8d")));
        HoldemThresholdGroupTest.assertTrue((boolean)this.ht1.isHandInGroup(Deck.parseCardMask("9s9d")));
        HoldemThresholdGroupTest.assertTrue((boolean)this.ht1.isHandInGroup(Deck.parseCardMask("TsTd")));
        HoldemThresholdGroupTest.assertTrue((boolean)this.ht1.isHandInGroup(Deck.parseCardMask("JhJd")));
        HoldemThresholdGroupTest.assertTrue((boolean)this.ht1.isHandInGroup(Deck.parseCardMask("QhQs")));
        HoldemThresholdGroupTest.assertTrue((boolean)this.ht1.isHandInGroup(Deck.parseCardMask("AhAs")));
    }

    public void testGetHands() {
        HoldemThresholdGroupTest.assertEquals((int)60, (int)this.ht1.numHands());
        HoldemThresholdGroupTest.assertEquals((int)60, (int)this.ht1.getHands().length);
    }
}

