/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate.test;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.pokersource.enumerate.HoldemSMGroup;
import org.pokersource.game.Deck;

public class HoldemSMGroupTest
extends TestCase {
    private HoldemSMGroup gSM1;
    private HoldemSMGroup gSM2;
    private HoldemSMGroup gSM3;
    private HoldemSMGroup gSM4;
    private HoldemSMGroup gSM5;
    private HoldemSMGroup gSM6;
    private HoldemSMGroup gSM7;
    private HoldemSMGroup gSM8;
    private HoldemSMGroup gSM9;
    private long AhAd;
    private long KhQh;
    private long KhQs;
    private long Td9d;
    private long Td9c;
    private long _7d3c;

    public HoldemSMGroupTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(HoldemSMGroupTest.class);
    }

    protected void setUp() {
        this.gSM1 = new HoldemSMGroup("SM1");
        this.gSM2 = new HoldemSMGroup("SM2");
        this.gSM3 = new HoldemSMGroup("SM3");
        this.gSM4 = new HoldemSMGroup("SM4");
        this.gSM5 = new HoldemSMGroup("SM5");
        this.gSM6 = new HoldemSMGroup("SM6");
        this.gSM7 = new HoldemSMGroup("SM7");
        this.gSM8 = new HoldemSMGroup("SM8");
        this.gSM9 = new HoldemSMGroup("SM9");
        this.AhAd = Deck.parseCardMask("AhAd");
        this.KhQh = Deck.parseCardMask("KhQh");
        this.KhQs = Deck.parseCardMask("KhQs");
        this.Td9d = Deck.parseCardMask("Td9d");
        this.Td9c = Deck.parseCardMask("Td9c");
        this._7d3c = Deck.parseCardMask("7d3c");
    }

    public void testToString() {
        HoldemSMGroupTest.assertEquals((Object)"SM1", (Object)this.gSM1.toString());
        HoldemSMGroupTest.assertEquals((Object)"SM2", (Object)this.gSM2.toString());
        HoldemSMGroupTest.assertEquals((Object)"SM9", (Object)this.gSM9.toString());
    }

    public void testIsHandInGroup() {
        HoldemSMGroupTest.assertTrue((boolean)this.gSM1.isHandInGroup(this.AhAd));
        HoldemSMGroupTest.assertTrue((!this.gSM1.isHandInGroup(this.KhQh) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((!this.gSM1.isHandInGroup(this.KhQs) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((!this.gSM1.isHandInGroup(this.Td9d) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((!this.gSM1.isHandInGroup(this.Td9c) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((!this.gSM1.isHandInGroup(this._7d3c) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((!this.gSM2.isHandInGroup(this.AhAd) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((boolean)this.gSM2.isHandInGroup(this.KhQh));
        HoldemSMGroupTest.assertTrue((!this.gSM2.isHandInGroup(this.KhQs) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((!this.gSM2.isHandInGroup(this.Td9d) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((!this.gSM2.isHandInGroup(this.Td9c) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((!this.gSM2.isHandInGroup(this._7d3c) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((!this.gSM9.isHandInGroup(this.AhAd) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((!this.gSM9.isHandInGroup(this.KhQh) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((!this.gSM9.isHandInGroup(this.KhQs) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((!this.gSM9.isHandInGroup(this.Td9d) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((!this.gSM9.isHandInGroup(this.Td9c) ? 1 : 0) != 0);
        HoldemSMGroupTest.assertTrue((boolean)this.gSM9.isHandInGroup(this._7d3c));
    }

    public void testGetHands() {
        HoldemSMGroupTest.assertEquals((int)28, (int)this.gSM1.getHands().length);
        HoldemSMGroupTest.assertEquals((int)30, (int)this.gSM2.getHands().length);
        HoldemSMGroupTest.assertEquals((int)34, (int)this.gSM3.getHands().length);
        HoldemSMGroupTest.assertEquals((int)50, (int)this.gSM4.getHands().length);
        HoldemSMGroupTest.assertEquals((int)98, (int)this.gSM5.getHands().length);
        HoldemSMGroupTest.assertEquals((int)64, (int)this.gSM6.getHands().length);
        HoldemSMGroupTest.assertEquals((int)102, (int)this.gSM7.getHands().length);
        HoldemSMGroupTest.assertEquals((int)136, (int)this.gSM8.getHands().length);
        HoldemSMGroupTest.assertEquals((int)784, (int)this.gSM9.getHands().length);
    }

    public void testDisjoint() {
        HoldemSMGroup[] holdemSMGroupArray = new HoldemSMGroup[]{this.gSM1, this.gSM2, this.gSM3, this.gSM4, this.gSM5, this.gSM6, this.gSM7, this.gSM8, this.gSM9};
        for (int i = 0; i < holdemSMGroupArray.length; ++i) {
            long[] lArray = holdemSMGroupArray[i].getHands();
            for (int j = 0; j < lArray.length; ++j) {
                for (int k = 0; k < holdemSMGroupArray.length; ++k) {
                    boolean bl = i == k;
                    boolean bl2 = holdemSMGroupArray[k].isHandInGroup(lArray[j]);
                    HoldemSMGroupTest.assertTrue((bl == bl2 ? 1 : 0) != 0);
                }
            }
        }
    }
}

