/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate.test;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.pokersource.enumerate.HandGroup;
import org.pokersource.enumerate.HoldemHandOrdering;

public class HoldemHandOrderingTest
extends TestCase {
    private static final String SAMPLE_PATH = "sample1.hho";
    private HoldemHandOrdering hho1;

    public HoldemHandOrderingTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(HoldemHandOrderingTest.class);
    }

    protected void setUp() {
        try {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(SAMPLE_PATH);
            if (inputStream == null) {
                throw new FileNotFoundException(SAMPLE_PATH);
            }
            this.hho1 = new HoldemHandOrdering(inputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException("caught " + iOException);
        }
    }

    public void testToString() {
        HoldemHandOrderingTest.assertTrue((boolean)this.hho1.toString().startsWith("32:0.0 42:0.00904977"));
    }

    public void testGreaterEqual() {
        HandGroup[] handGroupArray = this.hho1.greaterEqual(0.95);
        HoldemHandOrderingTest.assertEquals((int)11, (int)handGroupArray.length);
        int n = 0;
        HoldemHandOrderingTest.assertEquals((Object)"AJs", (Object)((Object)handGroupArray[n++]).toString());
        HoldemHandOrderingTest.assertEquals((Object)"AQs", (Object)((Object)handGroupArray[n++]).toString());
        HoldemHandOrderingTest.assertEquals((Object)"77", (Object)((Object)handGroupArray[n++]).toString());
        HoldemHandOrderingTest.assertEquals((Object)"AKs", (Object)((Object)handGroupArray[n++]).toString());
        HoldemHandOrderingTest.assertEquals((Object)"88", (Object)((Object)handGroupArray[n++]).toString());
        HoldemHandOrderingTest.assertEquals((Object)"99", (Object)((Object)handGroupArray[n++]).toString());
        HoldemHandOrderingTest.assertEquals((Object)"TT", (Object)((Object)handGroupArray[n++]).toString());
        HoldemHandOrderingTest.assertEquals((Object)"JJ", (Object)((Object)handGroupArray[n++]).toString());
        HoldemHandOrderingTest.assertEquals((Object)"QQ", (Object)((Object)handGroupArray[n++]).toString());
        HoldemHandOrderingTest.assertEquals((Object)"KK", (Object)((Object)handGroupArray[n++]).toString());
        HoldemHandOrderingTest.assertEquals((Object)"AA", (Object)((Object)handGroupArray[n++]).toString());
    }
}

