/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate.test;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.pokersource.enumerate.HoldemHandGroup;
import org.pokersource.enumerate.HoldemHandGroupFactory;
import org.pokersource.enumerate.HoldemHandOrdering;
import org.pokersource.enumerate.ThresholdHandGroup;
import org.pokersource.game.Deck;

public class HoldemHandGroupFactoryTest
extends TestCase {
    public HoldemHandGroupFactoryTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(HoldemHandGroupFactoryTest.class);
    }

    protected void setUp() {
    }

    public void testCache() {
        HoldemHandGroup holdemHandGroup = HoldemHandGroupFactory.getInstance("AK");
        HoldemHandGroup holdemHandGroup2 = HoldemHandGroupFactory.getInstance("Q9s+");
        HoldemHandGroup holdemHandGroup3 = HoldemHandGroupFactory.getInstance("AK");
        HoldemHandGroupFactoryTest.assertTrue((holdemHandGroup != holdemHandGroup2 ? 1 : 0) != 0);
        HoldemHandGroupFactoryTest.assertTrue((!holdemHandGroup.equals(holdemHandGroup2) ? 1 : 0) != 0);
        HoldemHandGroupFactoryTest.assertTrue((holdemHandGroup == holdemHandGroup3 ? 1 : 0) != 0);
        HoldemHandGroupFactoryTest.assertTrue((boolean)holdemHandGroup.equals(holdemHandGroup3));
    }

    public void testException() {
        try {
            HoldemHandGroup holdemHandGroup = HoldemHandGroupFactory.getInstance("JUNK");
            HoldemHandGroupFactoryTest.fail((String)"Should raise IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (RuntimeException runtimeException) {
            HoldemHandGroupFactoryTest.fail((String)"Should raise IllegalArgumentException");
        }
    }

    public void testThreshold() {
        try {
            HoldemHandOrdering holdemHandOrdering = new HoldemHandOrdering("sample1.hho");
            ThresholdHandGroup.registerHandValuation("SAMPLE1", holdemHandOrdering);
            HoldemHandGroup holdemHandGroup = HoldemHandGroupFactory.getInstance("SAMPLE1>0.95");
            HoldemHandGroupFactoryTest.assertEquals((int)60, (int)holdemHandGroup.numHands());
            HoldemHandGroupFactoryTest.assertTrue((!holdemHandGroup.isHandInGroup(Deck.parseCardMask("6h6d")) ? 1 : 0) != 0);
            HoldemHandGroupFactoryTest.assertTrue((!holdemHandGroup.isHandInGroup(Deck.parseCardMask("AhTh")) ? 1 : 0) != 0);
            HoldemHandGroupFactoryTest.assertTrue((!holdemHandGroup.isHandInGroup(Deck.parseCardMask("AhKd")) ? 1 : 0) != 0);
            HoldemHandGroupFactoryTest.assertTrue((!holdemHandGroup.isHandInGroup(Deck.parseCardMask("KcQc")) ? 1 : 0) != 0);
            HoldemHandGroupFactoryTest.assertTrue((boolean)holdemHandGroup.isHandInGroup(Deck.parseCardMask("AhJh")));
            HoldemHandGroupFactoryTest.assertTrue((boolean)holdemHandGroup.isHandInGroup(Deck.parseCardMask("AsQs")));
            HoldemHandGroupFactoryTest.assertTrue((boolean)holdemHandGroup.isHandInGroup(Deck.parseCardMask("7s7d")));
            HoldemHandGroupFactoryTest.assertTrue((boolean)holdemHandGroup.isHandInGroup(Deck.parseCardMask("AsKs")));
            HoldemHandGroupFactoryTest.assertTrue((boolean)holdemHandGroup.isHandInGroup(Deck.parseCardMask("8s8d")));
            HoldemHandGroupFactoryTest.assertTrue((boolean)holdemHandGroup.isHandInGroup(Deck.parseCardMask("9s9d")));
            HoldemHandGroupFactoryTest.assertTrue((boolean)holdemHandGroup.isHandInGroup(Deck.parseCardMask("TsTd")));
            HoldemHandGroupFactoryTest.assertTrue((boolean)holdemHandGroup.isHandInGroup(Deck.parseCardMask("JhJd")));
            HoldemHandGroupFactoryTest.assertTrue((boolean)holdemHandGroup.isHandInGroup(Deck.parseCardMask("QhQs")));
            HoldemHandGroupFactoryTest.assertTrue((boolean)holdemHandGroup.isHandInGroup(Deck.parseCardMask("KhKs")));
            HoldemHandGroupFactoryTest.assertTrue((boolean)holdemHandGroup.isHandInGroup(Deck.parseCardMask("AhAs")));
        }
        catch (Exception exception) {
            HoldemHandGroupFactoryTest.fail((String)("exception " + exception));
        }
    }
}

