/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate.test;

import java.util.Iterator;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.pokersource.enumerate.HoldemCanonGroup;
import org.pokersource.game.Deck;

public class HoldemCanonGroupTest
extends TestCase {
    private HoldemCanonGroup gAA;
    private HoldemCanonGroup gKQs;
    private HoldemCanonGroup gT9;
    private long AhAd;
    private long KhQh;
    private long KhQs;
    private long Td9d;
    private long Td9c;

    public HoldemCanonGroupTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(HoldemCanonGroupTest.class);
    }

    protected void setUp() {
        this.gAA = new HoldemCanonGroup("AA");
        this.gKQs = new HoldemCanonGroup("KQs");
        this.gT9 = new HoldemCanonGroup("T9");
        this.AhAd = Deck.parseCardMask("AhAd");
        this.KhQh = Deck.parseCardMask("KhQh");
        this.KhQs = Deck.parseCardMask("KhQs");
        this.Td9d = Deck.parseCardMask("Td9d");
        this.Td9c = Deck.parseCardMask("Td9c");
    }

    public void testToString() {
        HoldemCanonGroupTest.assertEquals((Object)"AA", (Object)this.gAA.toString());
        HoldemCanonGroupTest.assertEquals((Object)"KQs", (Object)this.gKQs.toString());
        HoldemCanonGroupTest.assertEquals((Object)"T9", (Object)this.gT9.toString());
    }

    public void testIsHandInGroup() {
        HoldemCanonGroupTest.assertTrue((boolean)this.gAA.isHandInGroup(this.AhAd));
        HoldemCanonGroupTest.assertTrue((!this.gAA.isHandInGroup(this.KhQh) ? 1 : 0) != 0);
        HoldemCanonGroupTest.assertTrue((!this.gAA.isHandInGroup(this.KhQs) ? 1 : 0) != 0);
        HoldemCanonGroupTest.assertTrue((!this.gAA.isHandInGroup(this.Td9d) ? 1 : 0) != 0);
        HoldemCanonGroupTest.assertTrue((!this.gAA.isHandInGroup(this.Td9c) ? 1 : 0) != 0);
        HoldemCanonGroupTest.assertTrue((!this.gKQs.isHandInGroup(this.AhAd) ? 1 : 0) != 0);
        HoldemCanonGroupTest.assertTrue((boolean)this.gKQs.isHandInGroup(this.KhQh));
        HoldemCanonGroupTest.assertTrue((!this.gKQs.isHandInGroup(this.KhQs) ? 1 : 0) != 0);
        HoldemCanonGroupTest.assertTrue((!this.gKQs.isHandInGroup(this.Td9d) ? 1 : 0) != 0);
        HoldemCanonGroupTest.assertTrue((!this.gKQs.isHandInGroup(this.Td9c) ? 1 : 0) != 0);
        HoldemCanonGroupTest.assertTrue((!this.gT9.isHandInGroup(this.AhAd) ? 1 : 0) != 0);
        HoldemCanonGroupTest.assertTrue((!this.gT9.isHandInGroup(this.KhQh) ? 1 : 0) != 0);
        HoldemCanonGroupTest.assertTrue((!this.gT9.isHandInGroup(this.KhQs) ? 1 : 0) != 0);
        HoldemCanonGroupTest.assertTrue((!this.gT9.isHandInGroup(this.Td9d) ? 1 : 0) != 0);
        HoldemCanonGroupTest.assertTrue((boolean)this.gT9.isHandInGroup(this.Td9c));
    }

    public void testGetHands() {
        HoldemCanonGroupTest.assertEquals((int)6, (int)this.gAA.getHands().length);
        HoldemCanonGroupTest.assertEquals((int)4, (int)this.gKQs.getHands().length);
        HoldemCanonGroupTest.assertEquals((int)12, (int)this.gT9.getHands().length);
    }

    public void testAllGroups() {
        int n = 0;
        Iterator iterator = HoldemCanonGroup.allGroups();
        while (iterator.hasNext()) {
            HoldemCanonGroup holdemCanonGroup = (HoldemCanonGroup)iterator.next();
            ++n;
        }
        HoldemCanonGroupTest.assertEquals((int)169, (int)n);
    }
}

