/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate.test;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.pokersource.enumerate.HoldemBeliefVector;
import org.pokersource.game.Deck;

public class HoldemBeliefVectorTest
extends TestCase {
    HoldemBeliefVector v1;
    HoldemBeliefVector v2;
    HoldemBeliefVector v3;
    HoldemBeliefVector v4;

    public HoldemBeliefVectorTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(HoldemBeliefVectorTest.class);
    }

    protected void setUp() {
        this.v1 = new HoldemBeliefVector("AhKh");
        this.v2 = new HoldemBeliefVector("T9 52s:50");
        this.v3 = new HoldemBeliefVector("T9 52s:50");
        long l = Deck.parseCardMask("5h 5s");
        this.v3.setDeadCards(l);
        this.v4 = new HoldemBeliefVector("AA=50 SM2=50");
    }

    public void testGetHands() {
        HoldemBeliefVectorTest.assertEquals((int)1, (int)this.v1.getHands().length);
        HoldemBeliefVectorTest.assertEquals((int)16, (int)this.v2.getHands().length);
        HoldemBeliefVectorTest.assertEquals((int)14, (int)this.v3.getHands().length);
        HoldemBeliefVectorTest.assertEquals((int)36, (int)this.v4.getHands().length);
    }

    public void testGetBeliefProb() {
        double d = 1.0;
        HoldemBeliefVectorTest.assertEquals((double)(1.0 / d), (double)this.v1.getBeliefProb(Deck.parseCardMask("AhKh")), (double)1.0E-10);
        HoldemBeliefVectorTest.assertEquals((double)(0.0 / d), (double)this.v1.getBeliefProb(Deck.parseCardMask("AsKs")), (double)1.0E-10);
        double d2 = 14.0;
        HoldemBeliefVectorTest.assertEquals((double)(0.0 / d2), (double)this.v2.getBeliefProb(Deck.parseCardMask("Th9h")), (double)1.0E-10);
        HoldemBeliefVectorTest.assertEquals((double)(1.0 / d2), (double)this.v2.getBeliefProb(Deck.parseCardMask("Th9c")), (double)1.0E-10);
        HoldemBeliefVectorTest.assertEquals((double)(0.5 / d2), (double)this.v2.getBeliefProb(Deck.parseCardMask("5h2h")), (double)1.0E-10);
        HoldemBeliefVectorTest.assertEquals((double)(0.5 / d2), (double)this.v2.getBeliefProb(Deck.parseCardMask("5c2c")), (double)1.0E-10);
        HoldemBeliefVectorTest.assertEquals((double)(0.0 / d2), (double)this.v2.getBeliefProb(Deck.parseCardMask("5h2c")), (double)1.0E-10);
        double d3 = 13.0;
        HoldemBeliefVectorTest.assertEquals((double)(0.0 / d3), (double)this.v3.getBeliefProb(Deck.parseCardMask("Th9h")), (double)1.0E-10);
        HoldemBeliefVectorTest.assertEquals((double)(1.0 / d3), (double)this.v3.getBeliefProb(Deck.parseCardMask("Th9c")), (double)1.0E-10);
        HoldemBeliefVectorTest.assertEquals((double)(0.0 / d3), (double)this.v3.getBeliefProb(Deck.parseCardMask("5h2h")), (double)1.0E-10);
        HoldemBeliefVectorTest.assertEquals((double)(0.5 / d3), (double)this.v3.getBeliefProb(Deck.parseCardMask("5c2c")), (double)1.0E-10);
        HoldemBeliefVectorTest.assertEquals((double)(0.0 / d3), (double)this.v3.getBeliefProb(Deck.parseCardMask("5h2c")), (double)1.0E-10);
        double d4 = 6.0;
        double d5 = 30.0;
        HoldemBeliefVectorTest.assertEquals((double)(0.5 / d4), (double)this.v4.getBeliefProb(Deck.parseCardMask("AhAd")), (double)1.0E-10);
        HoldemBeliefVectorTest.assertEquals((double)(0.5 / d5), (double)this.v4.getBeliefProb(Deck.parseCardMask("KhQh")), (double)1.0E-10);
    }
}

