/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate.test;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.pokersource.enumerate.HandGroup;
import org.pokersource.enumerate.HandValuation;
import org.pokersource.enumerate.HoldemHandGroup;
import org.pokersource.enumerate.HoldemHandGroupFactory;

public class HandValuationTest
extends TestCase {
    private static final String SAMPLE_PATH = "sample2.hev";
    private HandValuation hv;

    public HandValuationTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(HandValuationTest.class);
    }

    protected void setUp() {
        this.hv = new HandValuation();
        HoldemHandGroup holdemHandGroup = HoldemHandGroupFactory.getInstance("AKs");
        this.hv.setValue(holdemHandGroup, 80.0);
        HoldemHandGroup holdemHandGroup2 = HoldemHandGroupFactory.getInstance("AQ");
        this.hv.setValue(holdemHandGroup2, 70.0);
        HoldemHandGroup holdemHandGroup3 = HoldemHandGroupFactory.getInstance("T8");
        this.hv.setValue(holdemHandGroup3, 70.0);
        HoldemHandGroup holdemHandGroup4 = HoldemHandGroupFactory.getInstance("32s");
        this.hv.setValue(holdemHandGroup4, 10.0);
    }

    public void testToString() {
        HandValuationTest.assertEquals((Object)"32s:10.0 AQ:70.0 T8:70.0 AKs:80.0", (Object)this.hv.toString());
    }

    public void testLess() {
        HandGroup[] handGroupArray = this.hv.less(70.0);
        HandValuationTest.assertEquals((int)1, (int)handGroupArray.length);
        HandValuationTest.assertEquals((Object)"32s", (Object)((Object)handGroupArray[0]).toString());
        handGroupArray = this.hv.less(71.0);
        HandValuationTest.assertEquals((int)3, (int)handGroupArray.length);
        HandValuationTest.assertEquals((Object)"32s", (Object)((Object)handGroupArray[0]).toString());
        HandValuationTest.assertEquals((Object)"AQ", (Object)((Object)handGroupArray[1]).toString());
        HandValuationTest.assertEquals((Object)"T8", (Object)((Object)handGroupArray[2]).toString());
    }

    public void testLessEqual() {
        HandGroup[] handGroupArray = this.hv.lessEqual(69.0);
        HandValuationTest.assertEquals((int)1, (int)handGroupArray.length);
        HandValuationTest.assertEquals((Object)"32s", (Object)((Object)handGroupArray[0]).toString());
        handGroupArray = this.hv.lessEqual(70.0);
        HandValuationTest.assertEquals((int)3, (int)handGroupArray.length);
        HandValuationTest.assertEquals((Object)"32s", (Object)((Object)handGroupArray[0]).toString());
        HandValuationTest.assertEquals((Object)"AQ", (Object)((Object)handGroupArray[1]).toString());
        HandValuationTest.assertEquals((Object)"T8", (Object)((Object)handGroupArray[2]).toString());
    }

    public void testGreater() {
        HandGroup[] handGroupArray = this.hv.greater(69.0);
        HandValuationTest.assertEquals((int)3, (int)handGroupArray.length);
        HandValuationTest.assertEquals((Object)"AQ", (Object)((Object)handGroupArray[0]).toString());
        HandValuationTest.assertEquals((Object)"T8", (Object)((Object)handGroupArray[1]).toString());
        HandValuationTest.assertEquals((Object)"AKs", (Object)((Object)handGroupArray[2]).toString());
        handGroupArray = this.hv.greater(70.0);
        HandValuationTest.assertEquals((int)1, (int)handGroupArray.length);
        HandValuationTest.assertEquals((Object)"AKs", (Object)((Object)handGroupArray[0]).toString());
    }

    public void testGreaterEqual() {
        HandGroup[] handGroupArray = this.hv.greaterEqual(70.0);
        HandValuationTest.assertEquals((int)3, (int)handGroupArray.length);
        HandValuationTest.assertEquals((Object)"AQ", (Object)((Object)handGroupArray[0]).toString());
        HandValuationTest.assertEquals((Object)"T8", (Object)((Object)handGroupArray[1]).toString());
        HandValuationTest.assertEquals((Object)"AKs", (Object)((Object)handGroupArray[2]).toString());
        handGroupArray = this.hv.greaterEqual(71.0);
        HandValuationTest.assertEquals((int)1, (int)handGroupArray.length);
        HandValuationTest.assertEquals((Object)"AKs", (Object)((Object)handGroupArray[0]).toString());
    }
}

