/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate.test;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.pokersource.enumerate.Enumerate;
import org.pokersource.game.Deck;

public class EnumerateTest
extends TestCase {
    private int[][] pocketRanks;
    private int[][] pocketSuits;
    private int[] boardRanks;
    private int[] boardSuits;
    private int[] deadRanks;
    private int[] deadSuits;
    private long[] pockets;
    private long board;
    private long dead;

    public EnumerateTest(String string) {
        super(string);
    }

    public static void main(String[] stringArray) {
        TestRunner.run(EnumerateTest.class);
    }

    protected void setUp() {
        this.pocketRanks = new int[3][2];
        this.pocketSuits = new int[3][2];
        this.boardRanks = new int[3];
        this.boardSuits = new int[3];
        this.deadRanks = new int[2];
        this.deadSuits = new int[2];
        this.pockets = new long[3];
        this.pocketRanks[0][0] = Deck.RANK_KING;
        this.pocketSuits[0][0] = Deck.SUIT_SPADES;
        this.pocketRanks[0][1] = Deck.RANK_KING;
        this.pocketSuits[0][1] = Deck.SUIT_HEARTS;
        this.pockets[0] = Deck.createCardMask(this.pocketRanks[0], this.pocketSuits[0]);
        this.pocketRanks[1][0] = Deck.RANK_ACE;
        this.pocketSuits[1][0] = Deck.SUIT_DIAMONDS;
        this.pocketRanks[1][1] = Deck.RANK_TEN;
        this.pocketSuits[1][1] = Deck.SUIT_DIAMONDS;
        this.pockets[1] = Deck.createCardMask(this.pocketRanks[1], this.pocketSuits[1]);
        this.pocketRanks[2][0] = Deck.RANK_9;
        this.pocketSuits[2][0] = Deck.SUIT_CLUBS;
        this.pocketRanks[2][1] = Deck.RANK_8;
        this.pocketSuits[2][1] = Deck.SUIT_CLUBS;
        this.pockets[2] = Deck.createCardMask(this.pocketRanks[2], this.pocketSuits[2]);
        this.boardRanks[0] = Deck.RANK_KING;
        this.boardSuits[0] = Deck.SUIT_DIAMONDS;
        this.boardRanks[1] = Deck.RANK_JACK;
        this.boardSuits[1] = Deck.SUIT_DIAMONDS;
        this.boardRanks[2] = Deck.RANK_TEN;
        this.boardSuits[2] = Deck.SUIT_HEARTS;
        this.board = Deck.createCardMask(this.boardRanks, this.boardSuits);
        this.deadRanks[0] = Deck.RANK_ACE;
        this.deadSuits[0] = Deck.SUIT_SPADES;
        this.deadRanks[1] = Deck.RANK_2;
        this.deadSuits[1] = Deck.SUIT_HEARTS;
        this.dead = Deck.createCardMask(this.deadRanks, this.deadSuits);
    }

    public void assertEquals(int[][] nArray, int[][] nArray2) {
        EnumerateTest.assertEquals((int)nArray.length, (int)nArray2.length);
        for (int i = 0; i < nArray.length; ++i) {
            EnumerateTest.assertEquals((int)nArray[i].length, (int)nArray2[i].length);
            for (int j = 0; j < nArray[i].length; ++j) {
                EnumerateTest.assertEquals((int)nArray[i][j], (int)nArray2[i][j]);
            }
        }
    }

    public void assertEquals(int[][][] nArray, int[][][] nArray2) {
        EnumerateTest.assertEquals((int)nArray.length, (int)nArray2.length);
        for (int i = 0; i < nArray.length; ++i) {
            EnumerateTest.assertEquals((int)nArray[i].length, (int)nArray2[i].length);
            for (int j = 0; j < nArray[i].length; ++j) {
                EnumerateTest.assertEquals((int)nArray[i][j].length, (int)nArray2[i][j].length);
                for (int k = 0; k < nArray[i][j].length; ++k) {
                    EnumerateTest.assertEquals((int)nArray[i][j][k], (int)nArray2[i][j][k]);
                }
            }
        }
    }

    public void testPotEquity1() {
        double[] dArray = new double[this.pockets.length];
        Enumerate.PotEquity(Enumerate.GAME_HOLDEM, 0, this.pockets, this.board, this.dead, dArray);
        EnumerateTest.assertEquals((double)0.531707317073, (double)dArray[0], (double)1.0E-10);
        EnumerateTest.assertEquals((double)0.392682926829, (double)dArray[1], (double)1.0E-10);
        EnumerateTest.assertEquals((double)0.075609756098, (double)dArray[2], (double)1.0E-10);
    }

    public void testPotEquity2() {
        double[] dArray = new double[this.pockets.length];
        int[][][] nArrayArray = new int[1][][];
        int[][] nArrayArray2 = new int[1][];
        Enumerate.PotEquity(Enumerate.GAME_HOLDEM, 0, this.pockets, this.board, this.dead, dArray, nArrayArray, nArrayArray2);
        EnumerateTest.assertEquals((double)0.531707317073, (double)dArray[0], (double)1.0E-10);
        EnumerateTest.assertEquals((double)0.392682926829, (double)dArray[1], (double)1.0E-10);
        EnumerateTest.assertEquals((double)0.075609756098, (double)dArray[2], (double)1.0E-10);
        int[][][] nArrayArray3 = new int[][][]{new int[][]{{0, 0, 0}, {0, 1, 2}, {0, 2, 1}, {1, 0, 1}, {1, 0, 2}, {1, 2, 0}, {2, 0, 1}}};
        int[][] nArrayArray4 = new int[][]{{6, 407, 27, 14, 154, 60, 152}};
        this.assertEquals(nArrayArray3, nArrayArray);
        this.assertEquals(nArrayArray4, nArrayArray2);
    }

    public void testPotEquity3() {
        this.pockets[0] = Deck.parseCardMask("Ah 2h");
        this.pockets[1] = Deck.parseCardMask("5s 3s");
        this.pockets[2] = Deck.parseCardMask("8h 8d");
        this.board = Deck.parseCardMask("2s 4c 4d");
        this.dead = 0L;
        double[] dArray = new double[this.pockets.length];
        int[][][] nArrayArray = new int[1][][];
        int[][] nArrayArray2 = new int[1][];
        Enumerate.PotEquity(Enumerate.GAME_HOLDEM8, 0, this.pockets, this.board, this.dead, dArray, nArrayArray, nArrayArray2);
        EnumerateTest.assertEquals((double)0.119601328904, (double)dArray[0], (double)1.0E-10);
        EnumerateTest.assertEquals((double)0.373754152824, (double)dArray[1], (double)1.0E-10);
        EnumerateTest.assertEquals((double)0.506644518272, (double)dArray[2], (double)1.0E-10);
        int[][][] nArrayArray3 = new int[][][]{new int[][]{{0, 1, 2, 3, 0, 3}, {0, 2, 1, 0, 3, 1}, {0, 2, 1, 3, 0, 3}, {0, 2, 1, 3, 3, 3}, {1, 0, 2, 3, 0, 1}, {1, 0, 2, 3, 0, 3}, {1, 1, 0, 3, 3, 3}, {1, 2, 0, 1, 0, 3}, {1, 2, 0, 3, 0, 3}, {1, 2, 0, 3, 3, 3}, {2, 0, 1, 0, 1, 2}, {2, 0, 1, 1, 0, 2}, {2, 0, 1, 3, 0, 3}, {2, 0, 1, 3, 3, 3}, {2, 1, 0, 0, 1, 2}, {2, 1, 0, 0, 1, 3}, {2, 1, 0, 1, 0, 3}, {2, 1, 0, 3, 0, 3}, {2, 1, 0, 3, 3, 3}}};
        int[][] nArrayArray4 = new int[][]{{17, 9, 13, 54, 42, 61, 4, 7, 140, 220, 24, 16, 92, 16, 24, 12, 9, 11, 132}};
        this.assertEquals(nArrayArray3, nArrayArray);
        this.assertEquals(nArrayArray4, nArrayArray2);
    }
}

