/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.pokersource.enumerate.BaseHandGroup;
import org.pokersource.enumerate.HandGroup;
import org.pokersource.enumerate.HandValuation;
import org.pokersource.enumerate.HoldemHandOrdering;

public class ThresholdHandGroup
extends BaseHandGroup {
    private static Perl5Compiler compiler = new Perl5Compiler();
    private static Perl5Matcher matcher = new Perl5Matcher();
    private static Pattern pattern;
    private static HashMap valuations;

    public static void registerHandValuation(String string, HandValuation handValuation) {
        valuations.put(string, handValuation);
    }

    public ThresholdHandGroup(String string) {
        this.myspec = string;
        this.myhands = new HashSet();
        if (matcher.matches(string, pattern)) {
            HandGroup[] handGroupArray;
            double d;
            MatchResult matchResult = matcher.getMatch();
            String string2 = matchResult.group(1);
            String string3 = matchResult.group(2);
            String string4 = matchResult.group(3);
            try {
                d = Double.parseDouble(string4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("threshold unparsed: " + string);
            }
            HandValuation handValuation = (HandValuation)valuations.get(string2);
            if (handValuation == null) {
                throw new IllegalArgumentException("unknown valuation: " + string);
            }
            if (string3.equals("<")) {
                handGroupArray = handValuation.less(d);
            } else if (string3.equals("<=")) {
                handGroupArray = handValuation.lessEqual(d);
            } else if (string3.equals(">")) {
                handGroupArray = handValuation.greater(d);
            } else if (string3.equals(">=")) {
                handGroupArray = handValuation.greaterEqual(d);
            } else {
                throw new IllegalArgumentException("unknown comparator: " + string);
            }
            if (handGroupArray.length == 0) {
                throw new IllegalArgumentException("no groups passed: " + string);
            }
            for (int i = 0; i < handGroupArray.length; ++i) {
                this.myhands.addAll(handGroupArray[i].getHandSet());
            }
        } else {
            throw new IllegalArgumentException("unable to parse: " + string);
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        try {
            HoldemHandOrdering holdemHandOrdering = new HoldemHandOrdering(string);
            ThresholdHandGroup.registerHandValuation(string2, holdemHandOrdering);
            ThresholdHandGroup thresholdHandGroup = new ThresholdHandGroup(string3);
            System.out.println("spec=" + string3 + ", parsed=" + thresholdHandGroup.toString() + ", atomic=" + thresholdHandGroup.toStringAtomic());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        try {
            pattern = compiler.compile("^(\\w+)(<=?|>=?)(\\d+|\\.\\d+|\\d+\\.\\d+)$");
        }
        catch (MalformedPatternException malformedPatternException) {
            throw new RuntimeException("BUG: " + malformedPatternException.toString());
        }
        valuations = new HashMap();
    }
}

