/*
 * Decompiled with CFR 0.152.
 */
package org.pokersource.enumerate;

import gnu.getopt.Getopt;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import org.pokersource.enumerate.BeliefVector;
import org.pokersource.enumerate.Enumerate;
import org.pokersource.enumerate.HoldemBeliefVector;
import org.pokersource.enumerate.HoldemHandOrdering;
import org.pokersource.enumerate.RankOrdering;
import org.pokersource.enumerate.SAIE;
import org.pokersource.enumerate.ThresholdHandGroup;
import org.pokersource.game.Deck;

public class SAIEMain {
    private static int verbose = 0;
    private static int nmatchups = 0;
    private static int noutcomes = 0;
    private static boolean terseFlag = false;
    private static boolean orderingFlag = false;
    private static boolean stdinFlag = false;
    private static HashMap orderingObjs = new HashMap();
    private static ArrayList beliefs = new ArrayList();
    private static HashMap bvcache = new HashMap();
    private static long board = 0L;
    private static long dead = 0L;

    private SAIEMain() {
    }

    private static void usage() {
        String[] stringArray = new String[]{"Usage: java org.pokersource.enumerate.SAIEMain [options] bv1 bv2 ...", "  where bv1 is a HoldemBeliefVector in string form", "Options:", "  -b board           Community cards", "  -d dead            Dead cards", "  -m nmatchups       Number of matchups to sample [default all]", "  -n noutcomes       Number of outcomes for each matchup [default all]", "  -r NAME:file       Register hand ordering in file as NAME", "  -O                 Track relative hand rank orderings", "  -t                 Terse output [default human-readable]", "  -i                 Read hands from stdin instead of command line", "  -v level           Verbosity level [default 0]", "", " Streaming usage: java pokeval.SAIEMain -i", "  followed by standard input of command lines as above", "", " Examples:", "  java org.pokersource.enumerate.SAIEMain -b Ah3d2c9d JsJd 'AQs+ TT+'", "", "   java org.pokersource.enumerate.SAIEMain -m 100 -n 100 'AQs+ TT+' AK", "", "   java org.pokersource.enumerate.SAIEMain -O -r SAMP:sample1.hho \\", "               -m 100 -n 100 'AhTd' 'SAMP>0.80' 'SAMP>0.95'"};
        for (int i = 0; i < stringArray.length; ++i) {
            System.err.println(stringArray[i]);
        }
    }

    private static boolean parseArgs(String[] stringArray) {
        if (verbose >= 1) {
            System.out.print("Parsing:");
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.print(" " + stringArray[i]);
            }
            System.out.println();
        }
        terseFlag = false;
        orderingFlag = false;
        noutcomes = 0;
        nmatchups = 0;
        dead = 0L;
        board = 0L;
        beliefs.clear();
        try {
            int n;
            Getopt getopt = new Getopt("SAIEMain", stringArray, "b:d:m:n:r:Otiv:");
            block15: while ((n = getopt.getopt()) != -1) {
                switch (n) {
                    case 98: {
                        board = Deck.parseCardMask(getopt.getOptarg());
                        continue block15;
                    }
                    case 100: {
                        dead = Deck.parseCardMask(getopt.getOptarg());
                        continue block15;
                    }
                    case 109: {
                        nmatchups = Integer.parseInt(getopt.getOptarg());
                        continue block15;
                    }
                    case 110: {
                        noutcomes = Integer.parseInt(getopt.getOptarg());
                        continue block15;
                    }
                    case 114: {
                        HoldemHandOrdering holdemHandOrdering;
                        String string = getopt.getOptarg();
                        int n2 = string.indexOf(":");
                        if (n2 < 0) {
                            throw new IllegalArgumentException("cannot parse " + string);
                        }
                        String string2 = string.substring(0, n2);
                        String string3 = string.substring(n2 + 1, string.length());
                        if (verbose >= 1) {
                            System.out.println("Registering " + string + " as " + string3);
                        }
                        if ((holdemHandOrdering = (HoldemHandOrdering)orderingObjs.get(string3)) == null) {
                            ClassLoader classLoader;
                            InputStream inputStream;
                            if (verbose >= 1) {
                                System.out.println("Loading and parsing " + string3);
                            }
                            if ((inputStream = (classLoader = ClassLoader.getSystemClassLoader()).getResourceAsStream(string3)) == null) {
                                throw new FileNotFoundException(string3);
                            }
                            holdemHandOrdering = new HoldemHandOrdering(inputStream);
                            orderingObjs.put(string3, holdemHandOrdering);
                        }
                        ThresholdHandGroup.registerHandValuation(string2, holdemHandOrdering);
                        continue block15;
                    }
                    case 79: {
                        orderingFlag = true;
                        continue block15;
                    }
                    case 116: {
                        terseFlag = true;
                        continue block15;
                    }
                    case 105: {
                        stdinFlag = true;
                        continue block15;
                    }
                    case 118: {
                        verbose = Integer.parseInt(getopt.getOptarg());
                        continue block15;
                    }
                    case 63: {
                        return false;
                    }
                }
                System.err.print("getopt() returned " + n + "\n");
                return false;
            }
            for (int i = getopt.getOptind(); i < stringArray.length; ++i) {
                HoldemBeliefVector holdemBeliefVector = (HoldemBeliefVector)bvcache.get(stringArray[i]);
                if (holdemBeliefVector != null) {
                    if (verbose >= 1) {
                        System.out.println("Using cached belief vector " + stringArray[i]);
                    }
                } else {
                    if (verbose >= 1) {
                        System.out.println("Creating new belief vector " + stringArray[i]);
                    }
                    holdemBeliefVector = new HoldemBeliefVector(stringArray[i]);
                    bvcache.put(stringArray[i], holdemBeliefVector);
                }
                beliefs.add(holdemBeliefVector);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    private static void chat1() {
        if (verbose >= 1) {
            int n;
            int n2 = beliefs.size();
            System.out.println("nplayers=" + n2 + ", nmatchups=" + nmatchups + (nmatchups == 0 ? " (enumerate)" : " (sample)") + ", noutcomes=" + noutcomes + (noutcomes == 0 ? " (enumerate)" : " (sample)"));
            long l = 1L;
            for (n = 0; n < n2; ++n) {
                HoldemBeliefVector holdemBeliefVector = (HoldemBeliefVector)beliefs.get(n);
                System.out.println("bv[" + n + "] = " + holdemBeliefVector + " (" + holdemBeliefVector.numHands() + " atomic hands)");
                l *= (long)holdemBeliefVector.numHands();
            }
            System.out.println("board = " + Deck.cardMaskString(board));
            System.out.println("dead = " + Deck.cardMaskString(dead));
            System.out.println("Upper bound on matchups: " + l);
            n = 52 - Deck.numCards(board) - Deck.numCards(dead) - 2 * n2;
            int n3 = 0;
            if (Deck.numCards(board) == 0) {
                n3 = n * (n - 1) * (n - 2) * (n - 3) * (n - 4) / 120;
            } else if (Deck.numCards(board) == 3) {
                n3 = n * (n - 1) / 2;
            } else if (Deck.numCards(board) == 4) {
                n3 = n;
            } else if (Deck.numCards(board) == 5) {
                n3 = 1;
            }
            System.out.println("Outcomes per matchup: " + n3);
            long l2 = (long)n3 * l * (long)n2;
            System.out.println("Upper bound on hand evals: " + l2);
        }
    }

    private static void execute() {
        SAIEMain.chat1();
        if (verbose >= 1) {
            System.gc();
            System.runFinalization();
        }
        long l = System.currentTimeMillis();
        int n = beliefs.size();
        BeliefVector[] beliefVectorArray = beliefs.toArray(new HoldemBeliefVector[n]);
        double[] dArray = new double[n];
        TreeMap treeMap = null;
        if (orderingFlag) {
            treeMap = new TreeMap();
        }
        try {
            SAIE.FlopGameSAIE(Enumerate.GAME_HOLDEM, nmatchups, noutcomes, beliefVectorArray, board, dead, dArray, null, treeMap);
        }
        catch (RuntimeException runtimeException) {
            System.out.println("ERROR internal error");
            runtimeException.printStackTrace(System.err);
            return;
        }
        if (verbose >= 1) {
            System.out.println("Player pot equity:");
        }
        System.out.println(":\tEV " + n);
        for (int i = 0; i < n; ++i) {
            System.out.println(":\t" + i + "\t" + dArray[i]);
        }
        if (treeMap != null) {
            if (verbose >= 1) {
                System.out.println("Relative rank ordering histogram:");
            }
            System.out.println("::\tORD " + treeMap.size() + " " + n);
            for (RankOrdering rankOrdering : treeMap.keySet()) {
                Integer n2 = (Integer)treeMap.get(rankOrdering);
                System.out.println("::\t" + rankOrdering + " " + n2);
            }
        }
        long l2 = System.currentTimeMillis() - l;
        if (verbose >= 1) {
            System.out.println("Elapsed time: " + l2 + "ms");
            System.out.println();
        }
    }

    public static void main(String[] stringArray) {
        if (!SAIEMain.parseArgs(stringArray)) {
            SAIEMain.usage();
            return;
        }
        if (!stdinFlag) {
            SAIEMain.execute();
        } else {
            System.out.println("Reading stdin...");
            try {
                int n;
                InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                StreamTokenizer streamTokenizer = new StreamTokenizer(inputStreamReader);
                streamTokenizer.resetSyntax();
                streamTokenizer.wordChars(0, 255);
                streamTokenizer.whitespaceChars(0, 32);
                streamTokenizer.quoteChar(39);
                streamTokenizer.quoteChar(34);
                streamTokenizer.eolIsSignificant(true);
                ArrayList<String> arrayList = new ArrayList<String>();
                do {
                    n = streamTokenizer.nextToken();
                    if (n == -3 || n == 34 || n == 39) {
                        arrayList.add(new String(streamTokenizer.sval));
                    } else {
                        if (n != 10) {
                            if (n != -1) {
                                throw new RuntimeException("unexpected tokenizing bug");
                            }
                        }
                        if (arrayList.size() > 0) {
                            String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                            if (!SAIEMain.parseArgs(stringArray2)) {
                                System.out.println("ERROR failed to parse arguments");
                            } else {
                                SAIEMain.execute();
                            }
                            arrayList.clear();
                        } else if (n == 10) {
                            System.out.println("ERROR no arguments found");
                        }
                        System.out.flush();
                    }
                } while (n != -1);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                return;
            }
        }
    }
}

